/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.io.druid.common.config.JacksonConfigManager;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.hive.druid.io.druid.server.coordinator.DatasourceWhitelist;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorSegmentMerger;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.LinearShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DruidCoordinatorSegmentMergerTest {
    private static final long mergeBytesLimit = 100L;
    private static final int mergeSegmentsLimit = 8;

    @Test
    public void testNoMerges() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("2").size(80L).build());
        Assert.assertEquals((Object)ImmutableList.of(), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testMergeAtStart() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(20L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("2").size(20L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("2").size(90L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(0), segments.get(1))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testMergeAtEnd() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("2").size(20L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(2), segments.get(3))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testMergeInMiddle() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("2").size(10L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("2").size(20L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(1), segments.get(2))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testMergeNoncontiguous() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(10L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("2").size(10L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("2").size(10L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(0), segments.get(1), segments.get(2))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testMergeSeriesByteLimited() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(40L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P1D")).version("2").size(40L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("2").size(40L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("2").size(40L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("2").size(40L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-06/P1D")).version("2").size(40L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(0), segments.get(1)), (Object)ImmutableList.of(segments.get(2), segments.get(3)), (Object)ImmutableList.of(segments.get(4), segments.get(5))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testMergeSeriesSegmentLimited() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P1D")).version("2").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("2").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("2").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("2").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-06/P1D")).version("2").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-07/P1D")).version("2").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-08/P1D")).version("2").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-09/P1D")).version("2").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-10/P1D")).version("2").size(1L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(0), segments.get(1), segments.get(2), segments.get(3), segments.get(4), segments.get(5), segments.get(6), segments.get(7)), (Object)ImmutableList.of(segments.get(8), segments.get(9))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testOverlappingMergeWithBacktracking() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(20L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P1D")).version("2").size(20L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P4D")).version("2").size(20L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("3").size(20L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("4").size(20L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-06/P1D")).version("3").size(20L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-07/P1D")).version("2").size(20L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(0), segments.get(1)), (Object)ImmutableList.of(segments.get(2), segments.get(3), segments.get(4), segments.get(5), segments.get(6))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testOverlappingMergeWithGapsAlignedStart() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P8D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("3").size(8L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("3").size(8L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-09/P1D")).version("3").size(8L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(1), segments.get(0), segments.get(2))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testOverlappingMergeWithGapsNonalignedStart() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P8D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P1D")).version("3").size(8L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("3").size(8L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-09/P1D")).version("3").size(8L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(0), segments.get(1), segments.get(2))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testOverlappingMerge1() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P4D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("3").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("1").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("3").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-06/P1D")).version("2").size(80L).build());
        Assert.assertEquals((Object)ImmutableList.of(), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testOverlappingMerge2() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(15L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P4D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("3").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("4").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("3").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-06/P1D")).version("2").size(80L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(2), segments.get(3), segments.get(4))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testOverlappingMerge3() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P4D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("3").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("1").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("3").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-06/P1D")).version("2").size(80L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(1), segments.get(2), segments.get(4))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testOverlappingMerge4() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P4D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("3").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("4").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("3").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-06/P1D")).version("2").size(80L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(1), segments.get(2), segments.get(3), segments.get(4))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testOverlappingMerge5() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P4D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("3").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("1").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("3").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-06/P1D")).version("2").size(80L).build());
        Assert.assertEquals((Object)ImmutableList.of(), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testOverlappingMerge6() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P4D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("3").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("4").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("3").size(25L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-06/P1D")).version("2").size(80L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(2), segments.get(3), segments.get(4))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testOverlappingMerge7() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P4D")).version("2").size(120L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("3").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("4").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("3").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-06/P1D")).version("2").size(80L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(2), segments.get(3), segments.get(4), segments.get(5))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testOverlappingMerge8() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("2").size(80L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P4D")).version("2").size(120L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("3").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("1").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("3").size(1L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-06/P1D")).version("2").size(80L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(4), segments.get(5))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testMergeLinearShardSpecs() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P1D")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(7))).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1500))).build());
        Assert.assertEquals((Object)ImmutableList.of(), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    @Test
    public void testMergeMixedShardSpecs() {
        ImmutableList segments = ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/P1D")).version("1").build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-02/P1D")).version("1").build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-03/P1D")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1500))).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-04/P1D")).version("1").build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-05/P1D")).version("1").build());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(segments.get(0), segments.get(1)), (Object)ImmutableList.of(segments.get(3), segments.get(4))), DruidCoordinatorSegmentMergerTest.merge((Collection<DataSegment>)segments));
    }

    private static List<List<DataSegment>> merge(Collection<DataSegment> segments) {
        JacksonConfigManager configManager = (JacksonConfigManager)EasyMock.createMock(JacksonConfigManager.class);
        EasyMock.expect((Object)configManager.watch("coordinator.whitelist", DatasourceWhitelist.class)).andReturn(new AtomicReference<Object>(null)).anyTimes();
        EasyMock.replay((Object[])new Object[]{configManager});
        final ArrayList retVal = Lists.newArrayList();
        IndexingServiceClient indexingServiceClient = new IndexingServiceClient(null, null){

            public void mergeSegments(List<DataSegment> segmentsToMerge) {
                retVal.add(segmentsToMerge);
            }
        };
        DruidCoordinatorSegmentMerger merger = new DruidCoordinatorSegmentMerger(indexingServiceClient, configManager);
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder().withAvailableSegments((Collection)ImmutableSet.copyOf(segments)).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMergeBytesLimit(100L).withMergeSegmentsLimit(8).build()).withEmitter((ServiceEmitter)EasyMock.createMock(ServiceEmitter.class)).build();
        merger.run(params);
        return retVal;
    }
}

