/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.coordinator.CostBalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class CostBalancerStrategyTest {
    private static final Interval day = Intervals.of((String)"2015-01-01T00/2015-01-01T01");

    public static List<ServerHolder> setupDummyCluster(int serverCount, int maxSegments) {
        DataSegment segment;
        int j;
        HashMap segments;
        ArrayList serverHolderList = Lists.newArrayList();
        for (int i = 0; i < serverCount; ++i) {
            LoadQueuePeonTester fromPeon = new LoadQueuePeonTester();
            segments = Maps.newHashMap();
            for (j = 0; j < maxSegments; ++j) {
                segment = CostBalancerStrategyTest.getSegment(j);
                segments.put(segment.getIdentifier(), segment);
            }
            serverHolderList.add(new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("DruidServer_Name_" + i, "localhost", null, 10000000L, ServerType.HISTORICAL, "hot", 1), 3000L, ImmutableMap.of((Object)"DUMMY", (Object)EasyMock.createMock(ImmutableDruidDataSource.class)), ImmutableMap.copyOf((Map)segments)), (LoadQueuePeon)fromPeon));
        }
        LoadQueuePeonTester fromPeon = new LoadQueuePeonTester();
        ImmutableDruidServer druidServer = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        EasyMock.expect((Object)druidServer.getName()).andReturn((Object)"BEST_SERVER").anyTimes();
        EasyMock.expect((Object)druidServer.getCurrSize()).andReturn((Object)3000L).anyTimes();
        EasyMock.expect((Object)druidServer.getMaxSize()).andReturn((Object)10000000L).anyTimes();
        EasyMock.expect((Object)druidServer.getSegment((String)EasyMock.anyObject())).andReturn(null).anyTimes();
        segments = Maps.newHashMap();
        for (j = 0; j < maxSegments - 2; ++j) {
            segment = CostBalancerStrategyTest.getSegment(j);
            segments.put(segment.getIdentifier(), segment);
            EasyMock.expect((Object)druidServer.getSegment(segment.getIdentifier())).andReturn((Object)segment).anyTimes();
        }
        EasyMock.expect((Object)druidServer.getSegments()).andReturn((Object)segments).anyTimes();
        EasyMock.replay((Object[])new Object[]{druidServer});
        serverHolderList.add(new ServerHolder(druidServer, (LoadQueuePeon)fromPeon));
        return serverHolderList;
    }

    public static DataSegment getSegment(int index) {
        return CostBalancerStrategyTest.getSegment(index, "DUMMY", day);
    }

    public static DataSegment getSegment(int index, String dataSource, Interval interval) {
        DataSegment segment = new DataSegment(dataSource, interval, String.valueOf(index), new ConcurrentHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), null, Integer.valueOf(0), (long)index * 100L);
        return segment;
    }

    @Test
    public void testCostBalancerMultiThreadedStrategy() throws InterruptedException {
        List<ServerHolder> serverHolderList = CostBalancerStrategyTest.setupDummyCluster(10, 20);
        DataSegment segment = CostBalancerStrategyTest.getSegment(1000);
        CostBalancerStrategy strategy = new CostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(4)));
        ServerHolder holder = strategy.findNewSegmentHomeReplicator(segment, serverHolderList);
        Assert.assertNotNull((String)"Should be able to find a place for new segment!!", (Object)holder);
        Assert.assertEquals((String)"Best Server should be BEST_SERVER", (Object)"BEST_SERVER", (Object)holder.getServer().getName());
    }

    @Test
    public void testCostBalancerSingleThreadStrategy() throws InterruptedException {
        List<ServerHolder> serverHolderList = CostBalancerStrategyTest.setupDummyCluster(10, 20);
        DataSegment segment = CostBalancerStrategyTest.getSegment(1000);
        DateTime referenceTimestamp = DateTimes.of((String)"2014-01-01");
        CostBalancerStrategy strategy = new CostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1)));
        ServerHolder holder = strategy.findNewSegmentHomeReplicator(segment, serverHolderList);
        Assert.assertNotNull((String)"Should be able to find a place for new segment!!", (Object)holder);
        Assert.assertEquals((String)"Best Server should be BEST_SERVER", (Object)"BEST_SERVER", (Object)holder.getServer().getName());
    }

    @Test
    public void testComputeJointSegmentCost() {
        DateTime referenceTime = DateTimes.of((String)"2014-01-01T00:00:00");
        CostBalancerStrategy strategy = new CostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(4)));
        double segmentCost = CostBalancerStrategy.computeJointSegmentsCost((DataSegment)CostBalancerStrategyTest.getSegment(100, "DUMMY", new Interval((ReadableInstant)referenceTime, (ReadableInstant)referenceTime.plusHours(1))), (DataSegment)CostBalancerStrategyTest.getSegment(101, "DUMMY", new Interval((ReadableInstant)referenceTime.minusHours(2), (ReadableInstant)referenceTime.minusHours(2).plusHours(1))));
        Assert.assertEquals((double)(CostBalancerStrategy.INV_LAMBDA_SQUARE * CostBalancerStrategy.intervalCost((double)(1.0 * CostBalancerStrategy.LAMBDA), (double)(-2.0 * CostBalancerStrategy.LAMBDA), (double)(-1.0 * CostBalancerStrategy.LAMBDA)) * 2.0), (double)segmentCost, (double)1.0E-6);
    }

    @Test
    public void testIntervalCost() throws Exception {
        Assert.assertEquals((double)CostBalancerStrategy.intervalCost((double)1.0, (double)1.0, (double)3.0), (double)(CostBalancerStrategy.intervalCost((double)1.0, (double)1.0, (double)2.0) + CostBalancerStrategy.intervalCost((double)1.0, (double)2.0, (double)3.0)), (double)1.0E-6);
        Assert.assertEquals((double)CostBalancerStrategy.intervalCost((double)2.0, (double)1.0, (double)3.0), (double)(CostBalancerStrategy.intervalCost((double)2.0, (double)1.0, (double)2.0) + CostBalancerStrategy.intervalCost((double)2.0, (double)2.0, (double)3.0)), (double)1.0E-6);
        Assert.assertEquals((double)CostBalancerStrategy.intervalCost((double)3.0, (double)1.0, (double)2.0), (double)(CostBalancerStrategy.intervalCost((double)1.0, (double)1.0, (double)2.0) + CostBalancerStrategy.intervalCost((double)1.0, (double)0.0, (double)1.0) + CostBalancerStrategy.intervalCost((double)1.0, (double)1.0, (double)2.0)), (double)1.0E-6);
        Assert.assertEquals((double)0.3995764, (double)CostBalancerStrategy.intervalCost((double)1.0, (double)1.0, (double)2.0), (double)1.0E-6);
        Assert.assertEquals((double)0.3995764, (double)CostBalancerStrategy.intervalCost((double)1.0, (double)-1.0, (double)0.0), (double)1.0E-6);
        Assert.assertEquals((double)0.7357589, (double)CostBalancerStrategy.intervalCost((double)1.0, (double)0.0, (double)1.0), (double)1.0E-6);
        Assert.assertEquals((double)2.270671, (double)CostBalancerStrategy.intervalCost((double)2.0, (double)0.0, (double)2.0), (double)1.0E-6);
        Assert.assertEquals((double)1.681908, (double)CostBalancerStrategy.intervalCost((double)2.0, (double)1.0, (double)3.0), (double)1.0E-6);
        Assert.assertEquals((double)1.135335, (double)CostBalancerStrategy.intervalCost((double)2.0, (double)1.0, (double)2.0), (double)1.0E-6);
        Assert.assertEquals((double)1.135335, (double)CostBalancerStrategy.intervalCost((double)2.0, (double)0.0, (double)1.0), (double)1.0E-6);
        Assert.assertEquals((double)1.534912, (double)CostBalancerStrategy.intervalCost((double)3.0, (double)1.0, (double)2.0), (double)1.0E-6);
    }
}

