/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Collection;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.guice.GuiceAnnotationIntrospector;
import org.apache.hive.druid.io.druid.guice.GuiceInjectableValues;
import org.apache.hive.druid.io.druid.guice.GuiceInjectors;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.segment.loading.LoadSpec;
import org.apache.hive.druid.io.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.hive.druid.io.druid.segment.loading.LocalLoadSpec;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LoadSpecTest {
    private final String value;
    private final String expectedId;
    private static ObjectMapper mapper;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return ImmutableList.of((Object)new Object[]{"{\"path\":\"/\",\"type\":\"local\"}", "local"});
    }

    public LoadSpecTest(String value, String expectedId) {
        this.value = value;
        this.expectedId = expectedId;
    }

    @BeforeClass
    public static void setUp() {
        Injector injector = GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bind(LocalDataSegmentPuller.class);
            }
        }));
        mapper = new DefaultObjectMapper();
        mapper.registerModule((org.apache.hive.druid.com.fasterxml.jackson.databind.Module)new SimpleModule("loadSpecTest").registerSubtypes(new Class[]{LocalLoadSpec.class}));
        mapper.setInjectableValues((InjectableValues)new GuiceInjectableValues(injector));
        GuiceAnnotationIntrospector guiceIntrospector = new GuiceAnnotationIntrospector();
        mapper.setAnnotationIntrospectors((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, mapper.getSerializationConfig().getAnnotationIntrospector()), (AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, mapper.getDeserializationConfig().getAnnotationIntrospector()));
    }

    @Test
    public void testStringResolve() throws IOException {
        LoadSpec loadSpec = (LoadSpec)mapper.readValue(this.value, LoadSpec.class);
        Assert.assertEquals((Object)this.expectedId, (Object)loadSpec.getClass().getAnnotation(JsonTypeName.class).value());
    }
}

