/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.UnmodifiableIterator;
import org.apache.hive.druid.io.druid.common.guava.SettableSupplier;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.BitmapResultFactory;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.groupby.RowBasedColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnSelector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.IndexBuilder;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexStorageAdapter;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.hive.druid.io.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.hive.druid.io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public abstract class BaseFilterTest {
    private static final VirtualColumns VIRTUAL_COLUMNS = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "1.0 + 0.1", ValueType.FLOAT, TestExprMacroTable.INSTANCE)));
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final List<InputRow> rows;
    protected final IndexBuilder indexBuilder;
    protected final Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher;
    protected StorageAdapter adapter;
    protected boolean cnf;
    protected boolean optimize;
    protected final String testName;
    protected static ThreadLocal<Map<String, Map<String, Pair<StorageAdapter, Closeable>>>> adapterCache = new ThreadLocal<Map<String, Map<String, Pair<StorageAdapter, Closeable>>>>(){

        @Override
        protected Map<String, Map<String, Pair<StorageAdapter, Closeable>>> initialValue() {
            return new HashMap<String, Map<String, Pair<StorageAdapter, Closeable>>>();
        }
    };

    public BaseFilterTest(String testName, List<InputRow> rows, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        this.testName = testName;
        this.rows = rows;
        this.indexBuilder = indexBuilder;
        this.finisher = finisher;
        this.cnf = cnf;
        this.optimize = optimize;
    }

    @Before
    public void setUp() throws Exception {
        Pair pair;
        String className = this.getClass().getName();
        Map<String, Pair<StorageAdapter, Closeable>> adaptersForClass = adapterCache.get().get(className);
        if (adaptersForClass == null) {
            adaptersForClass = new HashMap<String, Pair<StorageAdapter, Closeable>>();
            adapterCache.get().put(className, adaptersForClass);
        }
        if ((pair = adaptersForClass.get(this.testName)) == null) {
            pair = (Pair)this.finisher.apply((Object)this.indexBuilder.tmpDir(this.temporaryFolder.newFolder()).rows(this.rows));
            adaptersForClass.put(this.testName, (Pair<StorageAdapter, Closeable>)pair);
        }
        this.adapter = (StorageAdapter)pair.lhs;
    }

    public static void tearDown(String className) throws Exception {
        Map<String, Pair<StorageAdapter, Closeable>> adaptersForClass = adapterCache.get().get(className);
        if (adaptersForClass != null) {
            for (Map.Entry<String, Pair<StorageAdapter, Closeable>> entry : adaptersForClass.entrySet()) {
                Closeable closeable = (Closeable)entry.getValue().rhs;
                closeable.close();
            }
            adapterCache.get().put(className, null);
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() throws IOException {
        return BaseFilterTest.makeConstructors();
    }

    public static Collection<Object[]> makeConstructors() {
        ArrayList constructors = Lists.newArrayList();
        ImmutableMap bitmapSerdeFactories = ImmutableMap.of((Object)"concise", (Object)new ConciseBitmapSerdeFactory(), (Object)"roaring", (Object)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)));
        ImmutableMap segmentWriteOutMediumFactories = ImmutableMap.of((Object)"tmpFile segment write-out medium", (Object)TmpFileSegmentWriteOutMediumFactory.instance(), (Object)"off-heap memory segment write-out medium", (Object)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        ImmutableMap finishers = ImmutableMap.of((Object)"incremental", (Object)new Function<IndexBuilder, Pair<StorageAdapter, Closeable>>(){

            public Pair<StorageAdapter, Closeable> apply(IndexBuilder input) {
                final IncrementalIndex index = input.buildIncrementalIndex();
                return Pair.of((Object)new IncrementalIndexStorageAdapter(index), (Object)new Closeable(){

                    @Override
                    public void close() throws IOException {
                        index.close();
                    }
                });
            }
        }, (Object)"mmapped", (Object)new Function<IndexBuilder, Pair<StorageAdapter, Closeable>>(){

            public Pair<StorageAdapter, Closeable> apply(IndexBuilder input) {
                final QueryableIndex index = input.buildMMappedIndex();
                return Pair.of((Object)new QueryableIndexStorageAdapter(index), (Object)new Closeable(){

                    @Override
                    public void close() throws IOException {
                        index.close();
                    }
                });
            }
        }, (Object)"mmappedMerged", (Object)new Function<IndexBuilder, Pair<StorageAdapter, Closeable>>(){

            public Pair<StorageAdapter, Closeable> apply(IndexBuilder input) {
                final QueryableIndex index = input.buildMMappedMergedIndex();
                return Pair.of((Object)new QueryableIndexStorageAdapter(index), (Object)new Closeable(){

                    @Override
                    public void close() throws IOException {
                        index.close();
                    }
                });
            }
        });
        for (Map.Entry bitmapSerdeFactoryEntry : bitmapSerdeFactories.entrySet()) {
            for (Map.Entry segmentWriteOutMediumFactoryEntry : segmentWriteOutMediumFactories.entrySet()) {
                for (Map.Entry finisherEntry : finishers.entrySet()) {
                    UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
                    while (unmodifiableIterator.hasNext()) {
                        boolean cnf = (Boolean)unmodifiableIterator.next();
                        UnmodifiableIterator unmodifiableIterator2 = ImmutableList.of((Object)false, (Object)true).iterator();
                        while (unmodifiableIterator2.hasNext()) {
                            boolean optimize = (Boolean)unmodifiableIterator2.next();
                            String testName = StringUtils.format((String)"bitmaps[%s], indexMerger[%s], finisher[%s], optimize[%s]", (Object[])new Object[]{bitmapSerdeFactoryEntry.getKey(), segmentWriteOutMediumFactoryEntry.getKey(), finisherEntry.getKey(), optimize});
                            IndexBuilder indexBuilder = IndexBuilder.create().indexSpec(new IndexSpec((BitmapSerdeFactory)bitmapSerdeFactoryEntry.getValue(), null, null, null)).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)segmentWriteOutMediumFactoryEntry.getValue());
                            constructors.add(new Object[]{testName, indexBuilder, finisherEntry.getValue(), cnf, optimize});
                        }
                    }
                }
            }
        }
        return constructors;
    }

    private Filter makeFilter(DimFilter dimFilter) {
        if (dimFilter == null) {
            return null;
        }
        DimFilter maybeOptimized = this.optimize ? dimFilter.optimize() : dimFilter;
        Filter filter = maybeOptimized.toFilter();
        return this.cnf ? Filters.convertToCNF((Filter)filter) : filter;
    }

    private DimFilter maybeOptimize(DimFilter dimFilter) {
        if (dimFilter == null) {
            return null;
        }
        return this.optimize ? dimFilter.optimize() : dimFilter;
    }

    private Sequence<Cursor> makeCursorSequence(Filter filter) {
        return this.adapter.makeCursors(filter, Intervals.ETERNITY, VIRTUAL_COLUMNS, Granularities.ALL, false, null);
    }

    private List<String> selectColumnValuesMatchingFilter(DimFilter filter, final String selectColumn) {
        Sequence<Cursor> cursors = this.makeCursorSequence(this.makeFilter(filter));
        Sequence seq = Sequences.map(cursors, (Function)new Function<Cursor, List<String>>(){

            public List<String> apply(Cursor input) {
                DimensionSelector selector = input.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(selectColumn, selectColumn));
                ArrayList values = Lists.newArrayList();
                while (!input.isDone()) {
                    IndexedInts row = selector.getRow();
                    Preconditions.checkState((row.size() == 1 ? 1 : 0) != 0);
                    values.add(selector.lookupName(row.get(0)));
                    input.advance();
                }
                return values;
            }
        });
        return (List)((ArrayList)Sequences.toList((Sequence)seq, new ArrayList())).get(0);
    }

    private long selectCountUsingFilteredAggregator(final DimFilter filter) {
        Sequence<Cursor> cursors = this.makeCursorSequence(this.makeFilter(filter));
        Sequence aggSeq = Sequences.map(cursors, (Function)new Function<Cursor, Aggregator>(){

            public Aggregator apply(Cursor input) {
                Aggregator agg = new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("count"), BaseFilterTest.this.maybeOptimize(filter)).factorize(input.getColumnSelectorFactory());
                while (!input.isDone()) {
                    agg.aggregate();
                    input.advance();
                }
                return agg;
            }
        });
        return ((Aggregator)((ArrayList)Sequences.toList((Sequence)aggSeq, new ArrayList())).get(0)).getLong();
    }

    private List<String> selectColumnValuesMatchingFilterUsingPostFiltering(DimFilter filter, final String selectColumn) {
        final Filter theFilter = this.makeFilter(filter);
        Filter postFilteringFilter = new Filter(){

            public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
                throw new UnsupportedOperationException();
            }

            public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
                return theFilter.makeMatcher(factory);
            }

            public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
                return false;
            }

            public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
                return false;
            }

            public double estimateSelectivity(BitmapIndexSelector indexSelector) {
                return 1.0;
            }
        };
        Sequence<Cursor> cursors = this.makeCursorSequence(postFilteringFilter);
        Sequence seq = Sequences.map(cursors, (Function)new Function<Cursor, List<String>>(){

            public List<String> apply(Cursor input) {
                DimensionSelector selector = input.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(selectColumn, selectColumn));
                ArrayList values = Lists.newArrayList();
                while (!input.isDone()) {
                    IndexedInts row = selector.getRow();
                    Preconditions.checkState((row.size() == 1 ? 1 : 0) != 0);
                    values.add(selector.lookupName(row.get(0)));
                    input.advance();
                }
                return values;
            }
        });
        return (List)((ArrayList)Sequences.toList((Sequence)seq, new ArrayList())).get(0);
    }

    private List<String> selectColumnValuesMatchingFilterUsingRowBasedColumnSelectorFactory(DimFilter filter, String selectColumn) {
        HashMap rowSignature = Maps.newHashMap();
        for (String columnName : Iterables.concat((Iterable)this.adapter.getAvailableDimensions(), (Iterable)this.adapter.getAvailableMetrics())) {
            rowSignature.put(columnName, this.adapter.getColumnCapabilities(columnName).getType());
        }
        SettableSupplier rowSupplier = new SettableSupplier();
        ValueMatcher matcher = this.makeFilter(filter).makeMatcher(VIRTUAL_COLUMNS.wrap((ColumnSelectorFactory)RowBasedColumnSelectorFactory.create((Supplier)rowSupplier, (Map)rowSignature)));
        ArrayList values = Lists.newArrayList();
        for (InputRow row : this.rows) {
            rowSupplier.set((Object)row);
            if (!matcher.matches()) continue;
            values.add((String)row.getRaw(selectColumn));
        }
        return values;
    }

    protected void assertFilterMatches(DimFilter filter, List<String> expectedRows) {
        Assert.assertEquals((String)("Cursor: " + filter.toString()), expectedRows, this.selectColumnValuesMatchingFilter(filter, "dim0"));
        Assert.assertEquals((String)("Cursor with postFiltering: " + filter.toString()), expectedRows, this.selectColumnValuesMatchingFilterUsingPostFiltering(filter, "dim0"));
        Assert.assertEquals((String)("Filtered aggregator: " + filter.toString()), (long)expectedRows.size(), (long)this.selectCountUsingFilteredAggregator(filter));
        Assert.assertEquals((String)("RowBasedColumnSelectorFactory: " + filter.toString()), expectedRows, this.selectColumnValuesMatchingFilterUsingRowBasedColumnSelectorFactory(filter, "dim0"));
    }
}

