/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeseries;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryTest {
    private static final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    private final boolean descending;

    @Parameterized.Parameters(name="descending={0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.cartesian(Arrays.asList(false, true));
    }

    public TimeseriesQueryTest(boolean descending) {
        this.descending = descending;
    }

    @Test
    public void testQuerySerialization() throws IOException {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        String json = jsonMapper.writeValueAsString((Object)query);
        Query serdeQuery = (Query)jsonMapper.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }
}

