/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.metadata.metadata;

import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class ColumnAnalysisTest {
    private final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    private void assertSerDe(ColumnAnalysis analysis) throws Exception {
        Assert.assertEquals((Object)analysis, (Object)this.MAPPER.readValue(this.MAPPER.writeValueAsString((Object)analysis), ColumnAnalysis.class));
    }

    @Test
    public void testFoldStringColumns() throws Exception {
        ColumnAnalysis analysis1 = new ColumnAnalysis("STRING", false, 1L, Integer.valueOf(2), (Comparable)((Object)"aaA"), (Comparable)((Object)"Zzz"), null);
        ColumnAnalysis analysis2 = new ColumnAnalysis("STRING", true, 3L, Integer.valueOf(4), (Comparable)((Object)"aAA"), (Comparable)((Object)"ZZz"), null);
        this.assertSerDe(analysis1);
        this.assertSerDe(analysis2);
        ColumnAnalysis expected = new ColumnAnalysis("STRING", true, 4L, Integer.valueOf(4), (Comparable)((Object)"aAA"), (Comparable)((Object)"Zzz"), null);
        ColumnAnalysis fold1 = analysis1.fold(analysis2);
        ColumnAnalysis fold2 = analysis2.fold(analysis1);
        Assert.assertEquals((Object)expected, (Object)fold1);
        Assert.assertEquals((Object)expected, (Object)fold2);
        this.assertSerDe(fold1);
        this.assertSerDe(fold2);
    }

    @Test
    public void testFoldWithNull() throws Exception {
        ColumnAnalysis analysis1 = new ColumnAnalysis("STRING", false, 1L, Integer.valueOf(2), null, null, null);
        Assert.assertEquals((Object)analysis1, (Object)analysis1.fold(null));
        this.assertSerDe(analysis1);
    }

    @Test
    public void testFoldComplexColumns() throws Exception {
        ColumnAnalysis analysis1 = new ColumnAnalysis("hyperUnique", false, 0L, null, null, null, null);
        ColumnAnalysis analysis2 = new ColumnAnalysis("hyperUnique", false, 0L, null, null, null, null);
        this.assertSerDe(analysis1);
        this.assertSerDe(analysis2);
        ColumnAnalysis expected = new ColumnAnalysis("hyperUnique", false, 0L, null, null, null, null);
        ColumnAnalysis fold1 = analysis1.fold(analysis2);
        ColumnAnalysis fold2 = analysis2.fold(analysis1);
        Assert.assertEquals((Object)expected, (Object)fold1);
        Assert.assertEquals((Object)expected, (Object)fold2);
        this.assertSerDe(fold1);
        this.assertSerDe(fold2);
    }

    @Test
    public void testFoldDifferentTypes() throws Exception {
        ColumnAnalysis analysis1 = new ColumnAnalysis("hyperUnique", false, 1L, Integer.valueOf(1), null, null, null);
        ColumnAnalysis analysis2 = new ColumnAnalysis("COMPLEX", false, 2L, Integer.valueOf(2), null, null, null);
        this.assertSerDe(analysis1);
        this.assertSerDe(analysis2);
        ColumnAnalysis expected = new ColumnAnalysis("STRING", false, -1L, null, null, null, "error:cannot_merge_diff_types");
        ColumnAnalysis fold1 = analysis1.fold(analysis2);
        ColumnAnalysis fold2 = analysis2.fold(analysis1);
        Assert.assertEquals((Object)expected, (Object)fold1);
        Assert.assertEquals((Object)expected, (Object)fold2);
        this.assertSerDe(fold1);
        this.assertSerDe(fold2);
    }

    @Test
    public void testFoldSameErrors() throws Exception {
        ColumnAnalysis analysis1 = ColumnAnalysis.error((String)"foo");
        ColumnAnalysis analysis2 = ColumnAnalysis.error((String)"foo");
        this.assertSerDe(analysis1);
        this.assertSerDe(analysis2);
        ColumnAnalysis expected = new ColumnAnalysis("STRING", false, -1L, null, null, null, "error:foo");
        ColumnAnalysis fold1 = analysis1.fold(analysis2);
        ColumnAnalysis fold2 = analysis2.fold(analysis1);
        Assert.assertEquals((Object)expected, (Object)fold1);
        Assert.assertEquals((Object)expected, (Object)fold2);
        this.assertSerDe(fold1);
        this.assertSerDe(fold2);
    }

    @Test
    public void testFoldErrorAndNoError() throws Exception {
        ColumnAnalysis analysis1 = ColumnAnalysis.error((String)"foo");
        ColumnAnalysis analysis2 = new ColumnAnalysis("STRING", false, 2L, Integer.valueOf(2), (Comparable)((Object)"a"), (Comparable)((Object)"z"), null);
        this.assertSerDe(analysis1);
        this.assertSerDe(analysis2);
        ColumnAnalysis expected = new ColumnAnalysis("STRING", false, -1L, null, null, null, "error:foo");
        ColumnAnalysis fold1 = analysis1.fold(analysis2);
        ColumnAnalysis fold2 = analysis2.fold(analysis1);
        Assert.assertEquals((Object)expected, (Object)fold1);
        Assert.assertEquals((Object)expected, (Object)fold2);
        this.assertSerDe(fold1);
        this.assertSerDe(fold2);
    }

    @Test
    public void testFoldDifferentErrors() throws Exception {
        ColumnAnalysis analysis1 = ColumnAnalysis.error((String)"foo");
        ColumnAnalysis analysis2 = ColumnAnalysis.error((String)"bar");
        this.assertSerDe(analysis1);
        this.assertSerDe(analysis2);
        ColumnAnalysis expected = new ColumnAnalysis("STRING", false, -1L, null, null, null, "error:multiple_errors");
        ColumnAnalysis fold1 = analysis1.fold(analysis2);
        ColumnAnalysis fold2 = analysis2.fold(analysis1);
        Assert.assertEquals((Object)expected, (Object)fold1);
        Assert.assertEquals((Object)expected, (Object)fold2);
        this.assertSerDe(fold1);
        this.assertSerDe(fold2);
    }
}

