/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.expression;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.expression.LookupEnabledTestExprMacroTable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExprMacroTest {
    private static final Expr.ObjectBinding BINDINGS = Parser.withMap((Map)ImmutableMap.builder().put((Object)"t", (Object)DateTimes.of((String)"2000-02-03T04:05:06").getMillis()).put((Object)"tstr", (Object)"2000-02-03T04:05:06").put((Object)"tstr_sql", (Object)"2000-02-03 04:05:06").put((Object)"x", (Object)"foo").put((Object)"y", (Object)2).put((Object)"z", (Object)3.1).put((Object)"CityOfAngels", (Object)"America/Los_Angeles").put((Object)"spacey", (Object)"  hey there  ").build());
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testLike() {
        this.assertExpr("like(x, 'f%')", 1L);
        this.assertExpr("like(x, 'f__')", 1L);
        this.assertExpr("like(x, '%o%')", 1L);
        this.assertExpr("like(x, 'b%')", 0L);
        this.assertExpr("like(x, 'b__')", 0L);
        this.assertExpr("like(x, '%x%')", 0L);
        this.assertExpr("like(x, '')", 0L);
    }

    @Test
    public void testLookup() {
        this.assertExpr("lookup(x, 'lookyloo')", "xfoo");
    }

    @Test
    public void testLookupNotFound() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("Lookup [lookylook] not found");
        this.assertExpr("lookup(x, 'lookylook')", null);
    }

    @Test
    public void testRegexpExtract() {
        this.assertExpr("regexp_extract(x, 'f(.)')", "fo");
        this.assertExpr("regexp_extract(x, 'f(.)', 0)", "fo");
        this.assertExpr("regexp_extract(x, 'f(.)', 1)", "o");
    }

    @Test
    public void testTimestampCeil() {
        this.assertExpr("timestamp_ceil(t, 'P1M')", DateTimes.of((String)"2000-03-01").getMillis());
        this.assertExpr("timestamp_ceil(t, 'P1D','','America/Los_Angeles')", DateTimes.of((String)"2000-02-03T08").getMillis());
        this.assertExpr("timestamp_ceil(t, 'P1D','',CityOfAngels)", DateTimes.of((String)"2000-02-03T08").getMillis());
        this.assertExpr("timestamp_ceil(t, 'P1D','1970-01-01T01','Etc/UTC')", DateTimes.of((String)"2000-02-04T01").getMillis());
    }

    @Test
    public void testTimestampFloor() {
        this.assertExpr("timestamp_floor(t, 'P1M')", DateTimes.of((String)"2000-02-01").getMillis());
        this.assertExpr("timestamp_floor(t, 'P1D','','America/Los_Angeles')", DateTimes.of((String)"2000-02-02T08").getMillis());
        this.assertExpr("timestamp_floor(t, 'P1D','',CityOfAngels)", DateTimes.of((String)"2000-02-02T08").getMillis());
        this.assertExpr("timestamp_floor(t, 'P1D','1970-01-01T01','Etc/UTC')", DateTimes.of((String)"2000-02-03T01").getMillis());
    }

    @Test
    public void testTimestampShift() {
        this.assertExpr("timestamp_shift(t, 'P1D', 2)", DateTimes.of((String)"2000-02-05T04:05:06").getMillis());
        this.assertExpr("timestamp_shift(t, 'P1D', 2, 'America/Los_Angeles')", DateTimes.of((String)"2000-02-05T04:05:06").getMillis());
        this.assertExpr("timestamp_shift(t, 'P1D', 2, CityOfAngels)", DateTimes.of((String)"2000-02-05T04:05:06").getMillis());
        this.assertExpr("timestamp_shift(t, 'P1D', 2, '-08:00')", DateTimes.of((String)"2000-02-05T04:05:06").getMillis());
    }

    @Test
    public void testTimestampExtract() {
        this.assertExpr("timestamp_extract(t, 'DAY')", 3L);
        this.assertExpr("timestamp_extract(t, 'HOUR')", 4L);
        this.assertExpr("timestamp_extract(t, 'DAY', 'America/Los_Angeles')", 2L);
        this.assertExpr("timestamp_extract(t, 'HOUR', 'America/Los_Angeles')", 20L);
    }

    @Test
    public void testTimestampParse() {
        this.assertExpr("timestamp_parse(tstr)", DateTimes.of((String)"2000-02-03T04:05:06").getMillis());
        this.assertExpr("timestamp_parse(tstr_sql)", DateTimes.of((String)"2000-02-03T04:05:06").getMillis());
        this.assertExpr("timestamp_parse(tstr_sql,'','America/Los_Angeles')", DateTimes.of((String)"2000-02-03T04:05:06-08:00").getMillis());
        this.assertExpr("timestamp_parse('2000-02-03')", DateTimes.of((String)"2000-02-03").getMillis());
        this.assertExpr("timestamp_parse('2000-02')", DateTimes.of((String)"2000-02-01").getMillis());
        this.assertExpr("timestamp_parse('')", null);
        this.assertExpr("timestamp_parse('z2000')", null);
        this.assertExpr("timestamp_parse(tstr_sql,'yyyy-MM-dd HH:mm:ss')", DateTimes.of((String)"2000-02-03T04:05:06").getMillis());
        this.assertExpr("timestamp_parse('02/03/2000','MM/dd/yyyy')", DateTimes.of((String)"2000-02-03").getMillis());
        this.assertExpr("timestamp_parse(tstr_sql,'yyyy-MM-dd HH:mm:ss','America/Los_Angeles')", DateTimes.of((String)"2000-02-03T04:05:06-08:00").getMillis());
    }

    @Test
    public void testTimestampFormat() {
        this.assertExpr("timestamp_format(t)", "2000-02-03T04:05:06.000Z");
        this.assertExpr("timestamp_format(t,'yyyy-MM-dd HH:mm:ss')", "2000-02-03 04:05:06");
        this.assertExpr("timestamp_format(t,'yyyy-MM-dd HH:mm:ss','America/Los_Angeles')", "2000-02-02 20:05:06");
    }

    @Test
    public void testTrim() {
        this.assertExpr("trim('')", null);
        this.assertExpr("trim(concat(' ',x,' '))", "foo");
        this.assertExpr("trim(spacey)", "hey there");
        this.assertExpr("trim(spacey, '')", "  hey there  ");
        this.assertExpr("trim(spacey, 'he ')", "y ther");
        this.assertExpr("trim(spacey, spacey)", null);
        this.assertExpr("trim(spacey, substring(spacey, 0, 4))", "y ther");
    }

    @Test
    public void testLTrim() {
        this.assertExpr("ltrim('')", null);
        this.assertExpr("ltrim(concat(' ',x,' '))", "foo ");
        this.assertExpr("ltrim(spacey)", "hey there  ");
        this.assertExpr("ltrim(spacey, '')", "  hey there  ");
        this.assertExpr("ltrim(spacey, 'he ')", "y there  ");
        this.assertExpr("ltrim(spacey, spacey)", null);
        this.assertExpr("ltrim(spacey, substring(spacey, 0, 4))", "y there  ");
    }

    @Test
    public void testRTrim() {
        this.assertExpr("rtrim('')", null);
        this.assertExpr("rtrim(concat(' ',x,' '))", " foo");
        this.assertExpr("rtrim(spacey)", "  hey there");
        this.assertExpr("rtrim(spacey, '')", "  hey there  ");
        this.assertExpr("rtrim(spacey, 'he ')", "  hey ther");
        this.assertExpr("rtrim(spacey, spacey)", null);
        this.assertExpr("rtrim(spacey, substring(spacey, 0, 4))", "  hey ther");
    }

    private void assertExpr(String expression, Object expectedResult) {
        Expr expr = Parser.parse((String)expression, (ExprMacroTable)LookupEnabledTestExprMacroTable.INSTANCE);
        Assert.assertEquals((String)expression, (Object)expectedResult, (Object)expr.eval(BINDINGS).value());
    }
}

