/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import org.apache.hive.druid.io.druid.java.util.common.BufferUtils;
import org.apache.hive.druid.io.druid.java.util.common.FileUtils;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.MappedByteBufferHandler;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileUtilsTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testMap() throws IOException {
        File dataFile = this.folder.newFile("data");
        long buffersMemoryBefore = BufferUtils.totalMemoryUsedByDirectAndMappedBuffers();
        try (RandomAccessFile raf = new RandomAccessFile(dataFile, "rw");){
            raf.write(42);
            raf.setLength(0x100000L);
        }
        var5_5 = null;
        try (MappedByteBufferHandler mappedByteBufferHandler = FileUtils.map((File)dataFile);){
            Assert.assertEquals((long)42L, (long)mappedByteBufferHandler.get().get(0));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        long buffersMemoryAfter = BufferUtils.totalMemoryUsedByDirectAndMappedBuffers();
        Assert.assertEquals((long)buffersMemoryBefore, (long)buffersMemoryAfter);
    }

    @Test
    public void testWriteAtomically() throws IOException {
        File tmpDir = this.folder.newFolder();
        File tmpFile = new File(tmpDir, "file1");
        FileUtils.writeAtomically((File)tmpFile, out -> out.write(StringUtils.toUtf8((String)"foo")));
        Assert.assertEquals((Object)"foo", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(tmpFile.toPath())));
        try {
            FileUtils.writeAtomically((File)tmpFile, out -> {
                out.write(StringUtils.toUtf8((String)"bar"));
                out.flush();
                throw new ISE("OMG!", new Object[0]);
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"foo", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(tmpFile.toPath())));
        FileUtils.writeAtomically((File)tmpFile, out -> out.write(StringUtils.toUtf8((String)"baz")));
        Assert.assertEquals((Object)"baz", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(tmpFile.toPath())));
    }
}

