/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator.discovery;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.curator.CuratorTestBase;
import org.apache.hive.druid.io.druid.curator.announcement.Announcer;
import org.apache.hive.druid.io.druid.curator.discovery.CuratorDruidNodeAnnouncer;
import org.apache.hive.druid.io.druid.curator.discovery.CuratorDruidNodeDiscoveryProvider;
import org.apache.hive.druid.io.druid.discovery.DiscoveryDruidNode;
import org.apache.hive.druid.io.druid.discovery.DruidNodeDiscovery;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.initialization.ServerConfig;
import org.apache.hive.druid.io.druid.server.initialization.ZkPathsConfig;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CuratorDruidNodeAnnouncerAndDiscoveryTest
extends CuratorTestBase {
    @Before
    public void setUp() throws Exception {
        this.setupServerAndCurator();
    }

    @Test(timeout=5000L)
    public void testAnnouncementAndDiscovery() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        objectMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ServerConfig.class, (Object)new ServerConfig()).addValue("java.lang.String", (Object)"dummy").addValue("java.lang.Integer", (Object)1234));
        this.curator.start();
        this.curator.blockUntilConnected();
        Announcer announcer = new Announcer(this.curator, (ExecutorService)MoreExecutors.sameThreadExecutor());
        announcer.start();
        CuratorDruidNodeAnnouncer druidNodeAnnouncer = new CuratorDruidNodeAnnouncer(announcer, new ZkPathsConfig(), (ObjectMapper)objectMapper);
        DiscoveryDruidNode node1 = new DiscoveryDruidNode(new DruidNode("s1", "h1", Integer.valueOf(8080), null, true, false), "coordinator", (Map)ImmutableMap.of());
        DiscoveryDruidNode node2 = new DiscoveryDruidNode(new DruidNode("s2", "h2", Integer.valueOf(8080), null, true, false), "coordinator", (Map)ImmutableMap.of());
        DiscoveryDruidNode node3 = new DiscoveryDruidNode(new DruidNode("s3", "h3", Integer.valueOf(8080), null, true, false), "overlord", (Map)ImmutableMap.of());
        DiscoveryDruidNode node4 = new DiscoveryDruidNode(new DruidNode("s4", "h4", Integer.valueOf(8080), null, true, false), "overlord", (Map)ImmutableMap.of());
        druidNodeAnnouncer.announce(node1);
        druidNodeAnnouncer.announce(node3);
        CuratorDruidNodeDiscoveryProvider druidNodeDiscoveryProvider = new CuratorDruidNodeDiscoveryProvider(this.curator, new ZkPathsConfig(), (ObjectMapper)objectMapper);
        druidNodeDiscoveryProvider.start();
        DruidNodeDiscovery coordDiscovery = druidNodeDiscoveryProvider.getForNodeType("coordinator");
        DruidNodeDiscovery overlordDiscovery = druidNodeDiscoveryProvider.getForNodeType("overlord");
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)node1), coordDiscovery.getAllNodes())) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)node3), overlordDiscovery.getAllNodes())) {
            Thread.sleep(100L);
        }
        final HashSet<DiscoveryDruidNode> coordNodes = new HashSet<DiscoveryDruidNode>();
        coordDiscovery.registerListener(new DruidNodeDiscovery.Listener(){

            public void nodesAdded(List<DiscoveryDruidNode> nodes) {
                coordNodes.addAll(nodes);
            }

            public void nodesRemoved(List<DiscoveryDruidNode> nodes) {
                coordNodes.removeAll(nodes);
            }
        });
        final HashSet<DiscoveryDruidNode> overlordNodes = new HashSet<DiscoveryDruidNode>();
        overlordDiscovery.registerListener(new DruidNodeDiscovery.Listener(){

            public void nodesAdded(List<DiscoveryDruidNode> nodes) {
                overlordNodes.addAll(nodes);
            }

            public void nodesRemoved(List<DiscoveryDruidNode> nodes) {
                overlordNodes.removeAll(nodes);
            }
        });
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)node1), coordNodes)) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)node3), overlordNodes)) {
            Thread.sleep(100L);
        }
        druidNodeAnnouncer.announce(node2);
        druidNodeAnnouncer.announce(node4);
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)node1, (Object)node2), coordDiscovery.getAllNodes())) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)node3, (Object)node4), overlordDiscovery.getAllNodes())) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)node1, (Object)node2), coordNodes)) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)node3, (Object)node4), overlordNodes)) {
            Thread.sleep(100L);
        }
        druidNodeAnnouncer.unannounce(node1);
        druidNodeAnnouncer.unannounce(node2);
        druidNodeAnnouncer.unannounce(node3);
        druidNodeAnnouncer.unannounce(node4);
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of(), coordDiscovery.getAllNodes())) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of(), overlordDiscovery.getAllNodes())) {
            Thread.sleep(100L);
        }
        while (!coordNodes.isEmpty()) {
            Thread.sleep(100L);
        }
        while (!overlordNodes.isEmpty()) {
            Thread.sleep(100L);
        }
        druidNodeDiscoveryProvider.stop();
        announcer.stop();
    }

    private boolean checkNodes(Set<DiscoveryDruidNode> expected, Collection<DiscoveryDruidNode> actual) {
        return expected.equals(ImmutableSet.copyOf(actual));
    }

    @After
    public void tearDown() {
        this.tearDownServerAndCurator();
    }
}

