/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.collections.IteratorShell;
import org.apache.hive.druid.io.druid.collections.OrderedMergeSequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.BaseSequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.MergeSequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.SequenceTestHelper;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.guava.TestSequence;
import org.junit.Assert;
import org.junit.Test;

public class OrderedMergeSequenceTest {
    @Test
    public void testSanity() throws Exception {
        ArrayList testSequences = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(2, 8), TestSequence.create(4, 6, 8)});
        OrderedMergeSequence seq = this.makeMergedSequence(Ordering.natural(), testSequences);
        SequenceTestHelper.testAll(seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSequences) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testMergeEmptySequence() throws Exception {
        ArrayList testSequences = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(ImmutableList.of()), TestSequence.create(2, 8), TestSequence.create(4, 6, 8)});
        OrderedMergeSequence seq = this.makeMergedSequence(Ordering.natural(), testSequences);
        SequenceTestHelper.testAll(seq, Arrays.asList(2, 4, 6, 8, 8));
        for (TestSequence sequence : testSequences) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testMergeEmptySequenceAtEnd() throws Exception {
        ArrayList testSequences = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(2, 8), TestSequence.create(4, 6, 8), TestSequence.create(ImmutableList.of())});
        OrderedMergeSequence seq = this.makeMergedSequence(Ordering.natural(), testSequences);
        SequenceTestHelper.testAll(seq, Arrays.asList(2, 4, 6, 8, 8));
        for (TestSequence sequence : testSequences) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testMergeEmptySequenceMiddle() throws Exception {
        ArrayList testSequences = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(2, 8), TestSequence.create(ImmutableList.of()), TestSequence.create(4, 6, 8)});
        OrderedMergeSequence seq = this.makeMergedSequence(Ordering.natural(), testSequences);
        SequenceTestHelper.testAll(seq, Arrays.asList(2, 4, 6, 8, 8));
        for (TestSequence sequence : testSequences) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testScrewsUpOnOutOfOrderBeginningOfList() throws Exception {
        ArrayList testSequences = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(4, 6, 8), TestSequence.create(2, 8)});
        OrderedMergeSequence seq = this.makeMergedSequence(Ordering.natural(), testSequences);
        SequenceTestHelper.testAll(seq, Arrays.asList(1, 3, 4, 2, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSequences) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testScrewsUpOnOutOfOrderInList() throws Exception {
        ArrayList testSequences = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1, 3, 5, 4, 7, 9), TestSequence.create(2, 8), TestSequence.create(4, 6)});
        OrderedMergeSequence seq = this.makeMergedSequence(Ordering.natural(), testSequences);
        SequenceTestHelper.testAll(seq, Arrays.asList(1, 2, 3, 4, 5, 4, 6, 7, 8, 9));
        for (TestSequence sequence : testSequences) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testLazinessAccumulation() throws Exception {
        ArrayList<Sequence<Integer>> sequences = this.makeSyncedSequences();
        OrderedMergeSequence seq = new OrderedMergeSequence(Ordering.natural(), Sequences.simple(sequences));
        SequenceTestHelper.testAccumulation("", (Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9));
    }

    @Test
    public void testLazinessYielder() throws Exception {
        ArrayList<Sequence<Integer>> sequences = this.makeSyncedSequences();
        OrderedMergeSequence seq = new OrderedMergeSequence(Ordering.natural(), Sequences.simple(sequences));
        SequenceTestHelper.testYield("", (Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9));
    }

    private ArrayList<Sequence<Integer>> makeSyncedSequences() {
        final boolean[] done = new boolean[]{false, false};
        ArrayList sequences = Lists.newArrayList();
        sequences.add(new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Integer, Iterator<Integer>>(){

            public Iterator<Integer> make() {
                return Arrays.asList(1, 2, 3).iterator();
            }

            public void cleanup(Iterator<Integer> iterFromMake) {
                done[0] = true;
            }
        }));
        sequences.add(new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Integer, Iterator<Integer>>(){

            public Iterator<Integer> make() {
                return new IteratorShell<Integer>(Arrays.asList(4, 5, 6).iterator()){
                    int count;
                    {
                        this.count = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.count >= 1) {
                            Assert.assertTrue((String)"First iterator not complete", (boolean)done[0]);
                        }
                        return super.hasNext();
                    }

                    @Override
                    public Integer next() {
                        if (this.count >= 1) {
                            Assert.assertTrue((String)"First iterator not complete", (boolean)done[0]);
                        }
                        ++this.count;
                        return (Integer)super.next();
                    }
                };
            }

            public void cleanup(Iterator<Integer> iterFromMake) {
                done[1] = true;
            }
        }));
        sequences.add(new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Integer, Iterator<Integer>>(){

            public Iterator<Integer> make() {
                return new IteratorShell<Integer>(Arrays.asList(7, 8, 9).iterator()){
                    int count;
                    {
                        this.count = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.count >= 1) {
                            Assert.assertTrue((String)"Second iterator not complete", (boolean)done[1]);
                        }
                        Assert.assertTrue((String)"First iterator not complete", (boolean)done[0]);
                        return super.hasNext();
                    }

                    @Override
                    public Integer next() {
                        if (this.count >= 1) {
                            Assert.assertTrue((String)"Second iterator not complete", (boolean)done[1]);
                        }
                        Assert.assertTrue((String)"First iterator not complete", (boolean)done[0]);
                        ++this.count;
                        return (Integer)super.next();
                    }
                };
            }

            public void cleanup(Iterator<Integer> iterFromMake) {
            }
        }));
        return sequences;
    }

    private <T> OrderedMergeSequence<T> makeMergedSequence(Ordering<T> ordering, List<TestSequence<T>> seqs) {
        return new OrderedMergeSequence(ordering, Sequences.simple(seqs));
    }

    private <T> MergeSequence<T> makeUnorderedMergedSequence(Ordering<T> ordering, List<TestSequence<T>> seqs) {
        return new MergeSequence(ordering, Sequences.simple(seqs));
    }

    @Test
    public void testHierarchicalMerge() throws Exception {
        MergeSequence seq1 = this.makeUnorderedMergedSequence(Ordering.natural(), Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1)}));
        MergeSequence seq2 = this.makeUnorderedMergedSequence(Ordering.natural(), Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1)}));
        OrderedMergeSequence finalMerged = new OrderedMergeSequence(Ordering.natural(), Sequences.simple((Iterable)Lists.newArrayList((Object[])new Sequence[]{seq1, seq2})));
        SequenceTestHelper.testAll((Sequence<Integer>)finalMerged, Arrays.asList(1, 1));
    }

    @Test
    public void testMergeMerge() throws Exception {
        MergeSequence seq1 = this.makeUnorderedMergedSequence(Ordering.natural(), Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1)}));
        OrderedMergeSequence finalMerged = new OrderedMergeSequence(Ordering.natural(), Sequences.simple((Iterable)Lists.newArrayList((Object[])new Sequence[]{seq1})));
        SequenceTestHelper.testAll((Sequence<Integer>)finalMerged, Collections.singletonList(1));
    }

    @Test
    public void testOne() throws Exception {
        MergeSequence seq1 = this.makeUnorderedMergedSequence(Ordering.natural(), Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1)}));
        SequenceTestHelper.testAll(seq1, Collections.singletonList(1));
    }
}

