/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonFactory;
import org.apache.hive.druid.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.hive.druid.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.com.google.common.hash.Hashing;
import org.apache.hive.druid.com.google.common.util.concurrent.ForwardingListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.druid.io.druid.client.CachingClusteredClient;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.RangeIterable;
import org.apache.hive.druid.io.druid.client.ServerView;
import org.apache.hive.druid.io.druid.client.TimelineServerView;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.client.cache.MapCache;
import org.apache.hive.druid.io.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.hive.druid.io.druid.client.selector.QueryableDruidServer;
import org.apache.hive.druid.io.druid.client.selector.RandomServerSelectorStrategy;
import org.apache.hive.druid.io.druid.client.selector.ServerSelector;
import org.apache.hive.druid.io.druid.client.selector.ServerSelectorStrategy;
import org.apache.hive.druid.io.druid.client.selector.TierSelectorStrategy;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.java.util.common.guava.FunctionalIterable;
import org.apache.hive.druid.io.druid.java.util.common.guava.MergeIterable;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.TrinaryFn;
import org.apache.hive.druid.io.druid.query.BySegmentResultValueClass;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.io.druid.query.MapQueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.io.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.InDimFilter;
import org.apache.hive.druid.io.druid.query.filter.OrDimFilter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.search.SearchHit;
import org.apache.hive.druid.io.druid.query.search.SearchQuery;
import org.apache.hive.druid.io.druid.query.search.SearchQueryConfig;
import org.apache.hive.druid.io.druid.query.search.SearchQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.search.SearchResultValue;
import org.apache.hive.druid.io.druid.query.select.EventHolder;
import org.apache.hive.druid.io.druid.query.select.PagingSpec;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.select.SelectQueryConfig;
import org.apache.hive.druid.io.druid.query.select.SelectQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.select.SelectResultValue;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryConfig;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.SingleDimensionShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.SingleElementPartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.StringPartitionChunk;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CachingClusteredClientTest {
    public static final ImmutableMap<String, Object> CONTEXT = ImmutableMap.of((Object)"finalize", (Object)false, (Object)"groupByStrategy", (Object)"v1");
    public static final MultipleIntervalSegmentSpec SEG_SPEC = new MultipleIntervalSegmentSpec((List)ImmutableList.of());
    public static final String DATA_SOURCE = "test";
    static final DefaultObjectMapper jsonMapper = new DefaultObjectMapper((JsonFactory)new SmileFactory());
    private static final int RANDOMNESS = 10;
    private static final List<AggregatorFactory> AGGS;
    private static final List<PostAggregator> POST_AGGS;
    private static final List<AggregatorFactory> RENAMED_AGGS;
    private static final List<PostAggregator> DIFF_ORDER_POST_AGGS;
    private static final DimFilter DIM_FILTER;
    private static final List<PostAggregator> RENAMED_POST_AGGS;
    private static final Granularity GRANULARITY;
    private static final DateTimeZone TIMEZONE;
    private static final Granularity PT1H_TZ_GRANULARITY;
    private static final String TOP_DIM = "a_dim";
    private static final Supplier<SelectQueryConfig> selectConfigSupplier;
    static final QueryToolChestWarehouse WAREHOUSE;
    private final Random random;
    public CachingClusteredClient client;
    private Runnable queryCompletedCallback;
    protected VersionedIntervalTimeline<String, ServerSelector> timeline;
    protected TimelineServerView serverView;
    protected Cache cache;
    DruidServer[] servers;

    public CachingClusteredClientTest(int randomSeed) {
        this.random = new Random(randomSeed);
    }

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return Lists.transform((List)Lists.newArrayList((Iterable)new RangeIterable(10)), (Function)new Function<Integer, Object[]>(){

            public Object[] apply(Integer input) {
                return new Object[]{input};
            }
        });
    }

    @Before
    public void setUp() throws Exception {
        this.timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        this.serverView = (TimelineServerView)EasyMock.createNiceMock(TimelineServerView.class);
        this.cache = MapCache.create((long)100000L);
        this.client = this.makeClient(MoreExecutors.sameThreadExecutor());
        this.servers = new DruidServer[]{new DruidServer("test1", "test1", null, 10L, ServerType.HISTORICAL, "bye", 0), new DruidServer("test2", "test2", null, 10L, ServerType.HISTORICAL, "bye", 0), new DruidServer("test3", "test3", null, 10L, ServerType.HISTORICAL, "bye", 0), new DruidServer("test4", "test4", null, 10L, ServerType.HISTORICAL, "bye", 0), new DruidServer("test5", "test5", null, 10L, ServerType.HISTORICAL, "bye", 0)};
    }

    @Test
    public void testOutOfOrderBackgroundCachePopulation() throws Exception {
        final ForwardingListeningExecutorService randomizingExecutorService = new ForwardingListeningExecutorService(){
            final ConcurrentLinkedDeque<Pair<SettableFuture, Object>> taskQueue = new ConcurrentLinkedDeque();
            final ListeningExecutorService delegate = MoreExecutors.listeningDecorator((ExecutorService)MoreExecutors.sameThreadExecutor());

            protected ListeningExecutorService delegate() {
                return this.delegate;
            }

            private <T> ListenableFuture<T> maybeSubmitTask(Object task, boolean wait) {
                if (wait) {
                    SettableFuture future = SettableFuture.create();
                    this.taskQueue.addFirst((Pair<SettableFuture, Object>)Pair.of((Object)future, (Object)task));
                    return future;
                }
                ArrayList tasks = Lists.newArrayList(this.taskQueue.iterator());
                Collections.shuffle(tasks, new Random(0L));
                for (final Pair pair : tasks) {
                    ListenableFuture future = pair.rhs instanceof Callable ? this.delegate.submit((Callable)pair.rhs) : this.delegate.submit((Runnable)pair.rhs);
                    Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback(){

                        public void onSuccess(@Nullable Object result) {
                            ((SettableFuture)pair.lhs).set(result);
                        }

                        public void onFailure(Throwable t) {
                            ((SettableFuture)pair.lhs).setException(t);
                        }
                    });
                }
                return task instanceof Callable ? this.delegate.submit((Callable)task) : this.delegate.submit((Runnable)task);
            }

            public <T> ListenableFuture<T> submit(Callable<T> task) {
                return this.maybeSubmitTask(task, true);
            }

            public ListenableFuture<?> submit(Runnable task) {
                abstract class DrainTask
                implements Runnable {
                    DrainTask() {
                    }
                }
                if (task instanceof DrainTask) {
                    return this.maybeSubmitTask(task, false);
                }
                return this.maybeSubmitTask(task, true);
            }
        };
        this.client = this.makeClient((ListeningExecutorService)randomizingExecutorService);
        this.queryCompletedCallback = new Runnable(){

            @Override
            public void run() {
                try {
                    randomizingExecutorService.submit((Runnable)new DrainTask(){
                        {
                        }

                        @Override
                        public void run() {
                        }
                    }).get();
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        };
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        this.testQueryCaching((QueryRunner)runner, (Query)builder.build(), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-05"), 85, 102, DateTimes.of((String)"2011-01-06"), 412, 521, DateTimes.of((String)"2011-01-07"), 122, 21894, DateTimes.of((String)"2011-01-08"), 5, 20, DateTimes.of((String)"2011-01-09"), 18, 521), Intervals.of((String)"2011-01-10/2011-01-13"), this.makeTimeResults(DateTimes.of((String)"2011-01-10"), 85, 102, DateTimes.of((String)"2011-01-11"), 412, 521, DateTimes.of((String)"2011-01-12"), 122, 21894));
    }

    @Test
    public void testTimeseriesCaching() throws Exception {
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        this.testQueryCaching((QueryRunner)runner, (Query)builder.build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeTimeResults(DateTimes.of((String)"2011-01-02"), 30, 6000), Intervals.of((String)"2011-01-04/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-04"), 23, 85312), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-05"), 85, 102, DateTimes.of((String)"2011-01-06"), 412, 521, DateTimes.of((String)"2011-01-07"), 122, 21894, DateTimes.of((String)"2011-01-08"), 5, 20, DateTimes.of((String)"2011-01-09"), 18, 521), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-05T01"), 80, 100, DateTimes.of((String)"2011-01-06T01"), 420, 520, DateTimes.of((String)"2011-01-07T01"), 12, 2194, DateTimes.of((String)"2011-01-08T01"), 59, 201, DateTimes.of((String)"2011-01-09T01"), 181, 52));
        HashMap context = new HashMap();
        TimeseriesQuery query = builder.intervals("2011-01-01/2011-01-10").aggregators(RENAMED_AGGS).postAggregators(RENAMED_POST_AGGS).build();
        TestHelper.assertExpectedResults(this.makeRenamedTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000, DateTimes.of((String)"2011-01-02"), 30, 6000, DateTimes.of((String)"2011-01-04"), 23, 85312, DateTimes.of((String)"2011-01-05"), 85, 102, DateTimes.of((String)"2011-01-05T01"), 80, 100, DateTimes.of((String)"2011-01-06"), 412, 521, DateTimes.of((String)"2011-01-06T01"), 420, 520, DateTimes.of((String)"2011-01-07"), 122, 21894, DateTimes.of((String)"2011-01-07T01"), 12, 2194, DateTimes.of((String)"2011-01-08"), 5, 20, DateTimes.of((String)"2011-01-08T01"), 59, 201, DateTimes.of((String)"2011-01-09"), 18, 521, DateTimes.of((String)"2011-01-09T01"), 181, 52), runner.run(QueryPlus.wrap((Query)query), context));
    }

    @Test
    public void testCachingOverBulkLimitEnforcesLimit() throws Exception {
        int limit = 10;
        Interval interval = Intervals.of((String)"2011-01-01/2011-01-02");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)interval))).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT).build();
        HashMap context = new HashMap();
        Cache cache = (Cache)EasyMock.createStrictMock(Cache.class);
        Capture cacheKeyCapture = EasyMock.newCapture();
        EasyMock.expect((Object)cache.getBulk((Iterable)EasyMock.capture((Capture)cacheKeyCapture))).andReturn((Object)ImmutableMap.of()).once();
        EasyMock.replay((Object[])new Object[]{cache});
        this.client = this.makeClient(MoreExecutors.sameThreadExecutor(), cache, 10);
        DruidServer lastServer = this.servers[this.random.nextInt(this.servers.length)];
        DataSegment dataSegment = (DataSegment)EasyMock.createNiceMock(DataSegment.class);
        EasyMock.expect((Object)dataSegment.getIdentifier()).andReturn((Object)DATA_SOURCE).anyTimes();
        EasyMock.replay((Object[])new Object[]{dataSegment});
        ServerSelector selector = new ServerSelector(dataSegment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
        selector.addServerAndUpdateSegment(new QueryableDruidServer(lastServer, null), dataSegment);
        this.timeline.add(interval, (Object)"v", (PartitionChunk)new SingleElementPartitionChunk((Object)selector));
        this.getDefaultQueryRunner().run(QueryPlus.wrap((Query)query), context);
        Assert.assertTrue((String)"Capture cache keys", (boolean)cacheKeyCapture.hasCaptured());
        Assert.assertTrue((String)"Cache key below limit", (ImmutableList.copyOf((Iterable)((Iterable)cacheKeyCapture.getValue())).size() <= 10 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{cache});
        EasyMock.reset((Object[])new Object[]{cache});
        cacheKeyCapture.reset();
        EasyMock.expect((Object)cache.getBulk((Iterable)EasyMock.capture((Capture)cacheKeyCapture))).andReturn((Object)ImmutableMap.of()).once();
        EasyMock.replay((Object[])new Object[]{cache});
        this.client = this.makeClient(MoreExecutors.sameThreadExecutor(), cache, 0);
        this.getDefaultQueryRunner().run(QueryPlus.wrap((Query)query), context);
        EasyMock.verify((Object[])new Object[]{cache});
        EasyMock.verify((Object[])new Object[]{dataSegment});
        Assert.assertTrue((String)"Capture cache keys", (boolean)cacheKeyCapture.hasCaptured());
        Assert.assertTrue((String)"Cache Keys empty", (boolean)ImmutableList.copyOf((Iterable)((Iterable)cacheKeyCapture.getValue())).isEmpty());
    }

    @Test
    public void testTimeseriesMergingOutOfOrderPartitions() throws Exception {
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        this.testQueryCaching((QueryRunner)runner, (Query)builder.build(), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-05T02"), 80, 100, DateTimes.of((String)"2011-01-06T02"), 420, 520, DateTimes.of((String)"2011-01-07T02"), 12, 2194, DateTimes.of((String)"2011-01-08T02"), 59, 201, DateTimes.of((String)"2011-01-09T02"), 181, 52), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-05T00"), 85, 102, DateTimes.of((String)"2011-01-06T00"), 412, 521, DateTimes.of((String)"2011-01-07T00"), 122, 21894, DateTimes.of((String)"2011-01-08T00"), 5, 20, DateTimes.of((String)"2011-01-09T00"), 18, 521));
        TimeseriesQuery query = builder.intervals("2011-01-05/2011-01-10").aggregators(RENAMED_AGGS).postAggregators(RENAMED_POST_AGGS).build();
        TestHelper.assertExpectedResults(this.makeRenamedTimeResults(DateTimes.of((String)"2011-01-05T00"), 85, 102, DateTimes.of((String)"2011-01-05T02"), 80, 100, DateTimes.of((String)"2011-01-06T00"), 412, 521, DateTimes.of((String)"2011-01-06T02"), 420, 520, DateTimes.of((String)"2011-01-07T00"), 122, 21894, DateTimes.of((String)"2011-01-07T02"), 12, 2194, DateTimes.of((String)"2011-01-08T00"), 5, 20, DateTimes.of((String)"2011-01-08T02"), 59, 201, DateTimes.of((String)"2011-01-09T00"), 18, 521, DateTimes.of((String)"2011-01-09T02"), 181, 52), runner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()));
    }

    @Test
    public void testTimeseriesCachingTimeZone() throws Exception {
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(PT1H_TZ_GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        this.testQueryCaching((QueryRunner)runner, (Query)builder.build(), Intervals.of((String)"2011-11-04/2011-11-08"), this.makeTimeResults(new DateTime((Object)"2011-11-04", TIMEZONE), 50, 5000, new DateTime((Object)"2011-11-05", TIMEZONE), 30, 6000, new DateTime((Object)"2011-11-06", TIMEZONE), 23, 85312, new DateTime((Object)"2011-11-07", TIMEZONE), 85, 102));
        HashMap context = new HashMap();
        TimeseriesQuery query = builder.intervals("2011-11-04/2011-11-08").aggregators(RENAMED_AGGS).postAggregators(RENAMED_POST_AGGS).build();
        TestHelper.assertExpectedResults(this.makeRenamedTimeResults(new DateTime((Object)"2011-11-04", TIMEZONE), 50, 5000, new DateTime((Object)"2011-11-05", TIMEZONE), 30, 6000, new DateTime((Object)"2011-11-06", TIMEZONE), 23, 85312, new DateTime((Object)"2011-11-07", TIMEZONE), 85, 102), runner.run(QueryPlus.wrap((Query)query), context));
    }

    @Test
    public void testDisableUseCache() throws Exception {
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        this.testQueryCaching((QueryRunner)runner, 1, true, (Query)builder.context((Map)ImmutableMap.of((Object)"useCache", (Object)"false", (Object)"populateCache", (Object)"true")).build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000));
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        this.cache.close("0_0");
        this.testQueryCaching((QueryRunner)runner, 1, false, (Query)builder.context((Map)ImmutableMap.of((Object)"useCache", (Object)"false", (Object)"populateCache", (Object)"false")).build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000));
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        this.testQueryCaching(this.getDefaultQueryRunner(), 1, false, (Query)builder.context((Map)ImmutableMap.of((Object)"useCache", (Object)"true", (Object)"populateCache", (Object)"false")).build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000));
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
    }

    @Test
    public void testTopNCaching() throws Exception {
        TopNQueryBuilder builder = new TopNQueryBuilder().dataSource(DATA_SOURCE).dimension(TOP_DIM).metric("imps").threshold(3).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        this.testQueryCaching((QueryRunner)runner, (Query)builder.build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-01"), "a", 50, 5000, "b", 50, 4999, "c", 50, 4998), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-02"), "a", 50, 4997, "b", 50, 4996, "c", 50, 4995), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "c1", 50, 4985, "b", 50, 4984, "c", 50, 4983), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09T01"), "c2", 50, 4985, "b", 50, 4984, "c", 50, 4983));
        HashMap context = new HashMap();
        TopNQuery query = builder.intervals("2011-01-01/2011-01-10").metric("imps").aggregators(RENAMED_AGGS).postAggregators(DIFF_ORDER_POST_AGGS).build();
        TestHelper.assertExpectedResults(this.makeRenamedTopNResults(DateTimes.of((String)"2011-01-01"), "a", 50, 5000, "b", 50, 4999, "c", 50, 4998, DateTimes.of((String)"2011-01-02"), "a", 50, 4997, "b", 50, 4996, "c", 50, 4995, DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "c1", 50, 4985, "b", 50, 4984, "c", 50, 4983, DateTimes.of((String)"2011-01-09T01"), "c2", 50, 4985, "b", 50, 4984, "c", 50, 4983), runner.run(QueryPlus.wrap((Query)query), context));
    }

    @Test
    public void testTopNCachingTimeZone() throws Exception {
        TopNQueryBuilder builder = new TopNQueryBuilder().dataSource(DATA_SOURCE).dimension(TOP_DIM).metric("imps").threshold(3).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(PT1H_TZ_GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        this.testQueryCaching((QueryRunner)runner, (Query)builder.build(), Intervals.of((String)"2011-11-04/2011-11-08"), this.makeTopNResultsWithoutRename(new DateTime((Object)"2011-11-04", TIMEZONE), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, new DateTime((Object)"2011-11-05", TIMEZONE), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, new DateTime((Object)"2011-11-06", TIMEZONE), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, new DateTime((Object)"2011-11-07", TIMEZONE), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986));
        HashMap context = new HashMap();
        TopNQuery query = builder.intervals("2011-11-04/2011-11-08").metric("imps").aggregators(RENAMED_AGGS).postAggregators(DIFF_ORDER_POST_AGGS).build();
        TestHelper.assertExpectedResults(this.makeRenamedTopNResults(new DateTime((Object)"2011-11-04", TIMEZONE), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, new DateTime((Object)"2011-11-05", TIMEZONE), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, new DateTime((Object)"2011-11-06", TIMEZONE), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, new DateTime((Object)"2011-11-07", TIMEZONE), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986), runner.run(QueryPlus.wrap((Query)query), context));
    }

    @Test
    public void testOutOfOrderSequenceMerging() throws Exception {
        ImmutableList sequences = ImmutableList.of((Object)Sequences.simple(this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983)), (Object)Sequences.simple(this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09T01"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983)));
        TestHelper.assertExpectedResults(this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983, DateTimes.of((String)"2011-01-09T01"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983), CachingClusteredClientTest.mergeSequences(new TopNQueryBuilder().dataSource(DATA_SOURCE).intervals("2011-01-06/2011-01-10").dimension("a").metric("b").threshold(3).aggregators(Arrays.asList(new CountAggregatorFactory("b"))).build(), sequences));
    }

    private static <T> Sequence<T> mergeSequences(Query<T> query, List<Sequence<T>> sequences) {
        return Sequences.simple(sequences).flatMerge(seq -> seq, query.getResultOrdering());
    }

    @Test
    public void testTopNCachingEmptyResults() throws Exception {
        TopNQueryBuilder builder = new TopNQueryBuilder().dataSource(DATA_SOURCE).dimension(TOP_DIM).metric("imps").threshold(3).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        this.testQueryCaching((QueryRunner)runner, (Query)builder.build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTopNResultsWithoutRename(new Object[0]), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeTopNResultsWithoutRename(new Object[0]), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09T01"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983));
        HashMap context = new HashMap();
        TopNQuery query = builder.intervals("2011-01-01/2011-01-10").metric("imps").aggregators(RENAMED_AGGS).postAggregators(DIFF_ORDER_POST_AGGS).build();
        TestHelper.assertExpectedResults(this.makeRenamedTopNResults(DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983, DateTimes.of((String)"2011-01-09T01"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983), runner.run(QueryPlus.wrap((Query)query), context));
    }

    @Test
    public void testTopNOnPostAggMetricCaching() {
        TopNQueryBuilder builder = new TopNQueryBuilder().dataSource(DATA_SOURCE).dimension(TOP_DIM).metric("avg_imps_per_row_double").threshold(3).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        this.testQueryCaching((QueryRunner)runner, (Query)builder.build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTopNResultsWithoutRename(new Object[0]), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeTopNResultsWithoutRename(new Object[0]), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "c1", 50, 4985, "b", 50, 4984, "c", 50, 4983), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09T01"), "c2", 50, 4985, "b", 50, 4984, "c", 50, 4983));
        HashMap context = new HashMap();
        TopNQuery query = builder.intervals("2011-01-01/2011-01-10").metric("avg_imps_per_row_double").aggregators(AGGS).postAggregators(DIFF_ORDER_POST_AGGS).build();
        TestHelper.assertExpectedResults(this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "c1", 50, 4985, "b", 50, 4984, "c", 50, 4983, DateTimes.of((String)"2011-01-09T01"), "c2", 50, 4985, "b", 50, 4984, "c", 50, 4983), runner.run(QueryPlus.wrap((Query)query), context));
    }

    @Test
    public void testSearchCaching() throws Exception {
        Druids.SearchQueryBuilder builder = Druids.newSearchQueryBuilder().dataSource(DATA_SOURCE).filters(DIM_FILTER).granularity(GRANULARITY).limit(1000).intervals((QuerySegmentSpec)SEG_SPEC).dimensions(Arrays.asList(TOP_DIM)).query("how").context(CONTEXT);
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)builder.build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-01"), "how", 1, "howdy", 2, "howwwwww", 3, "howwy", 4), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-02"), "how1", 1, "howdy1", 2, "howwwwww1", 3, "howwy1", 4), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-05"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-05T01"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06T01"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07T01"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08T01"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09T01"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4));
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new SearchQueryQueryToolChest(new SearchQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-01"), "how", 1, "howdy", 2, "howwwwww", 3, "howwy", 4, DateTimes.of((String)"2011-01-02"), "how1", 1, "howdy1", 2, "howwwwww1", 3, "howwy1", 4, DateTimes.of((String)"2011-01-05"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-05T01"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-06T01"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-07T01"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-08T01"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4, DateTimes.of((String)"2011-01-09T01"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4), runner.run(QueryPlus.wrap((Query)builder.intervals("2011-01-01/2011-01-10").build()), context));
    }

    @Test
    public void testSearchCachingRenamedOutput() throws Exception {
        Druids.SearchQueryBuilder builder = Druids.newSearchQueryBuilder().dataSource(DATA_SOURCE).filters(DIM_FILTER).granularity(GRANULARITY).limit(1000).intervals((QuerySegmentSpec)SEG_SPEC).dimensions(Arrays.asList(TOP_DIM)).query("how").context(CONTEXT);
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)builder.build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-01"), "how", 1, "howdy", 2, "howwwwww", 3, "howwy", 4), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-02"), "how1", 1, "howdy1", 2, "howwwwww1", 3, "howwy1", 4), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-05"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-05T01"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06T01"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07T01"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08T01"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09T01"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4));
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new SearchQueryQueryToolChest(new SearchQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-01"), "how", 1, "howdy", 2, "howwwwww", 3, "howwy", 4, DateTimes.of((String)"2011-01-02"), "how1", 1, "howdy1", 2, "howwwwww1", 3, "howwy1", 4, DateTimes.of((String)"2011-01-05"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-05T01"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-06T01"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-07T01"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-08T01"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4, DateTimes.of((String)"2011-01-09T01"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4), runner.run(QueryPlus.wrap((Query)builder.intervals("2011-01-01/2011-01-10").build()), context));
        SearchQuery query = builder.intervals("2011-01-01/2011-01-10").dimensions((DimensionSpec)new DefaultDimensionSpec(TOP_DIM, "new_dim")).build();
        TestHelper.assertExpectedResults(this.makeSearchResults("new_dim", DateTimes.of((String)"2011-01-01"), "how", 1, "howdy", 2, "howwwwww", 3, "howwy", 4, DateTimes.of((String)"2011-01-02"), "how1", 1, "howdy1", 2, "howwwwww1", 3, "howwy1", 4, DateTimes.of((String)"2011-01-05"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-05T01"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-06T01"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-07T01"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-08T01"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4, DateTimes.of((String)"2011-01-09T01"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4), runner.run(QueryPlus.wrap((Query)query), context));
    }

    @Test
    public void testSelectCaching() throws Exception {
        HashSet dimensions = Sets.newHashSet((Object[])new String[]{"a"});
        HashSet metrics = Sets.newHashSet((Object[])new String[]{"rows"});
        Druids.SelectQueryBuilder builder = Druids.newSelectQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).dimensions(Arrays.asList("a")).metrics(Arrays.asList("rows")).pagingSpec(new PagingSpec(null, 3)).context(CONTEXT);
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)builder.build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeSelectResults(dimensions, metrics, DateTimes.of((String)"2011-01-01"), ImmutableMap.of((Object)"a", (Object)"b", (Object)"rows", (Object)1)), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeSelectResults(dimensions, metrics, DateTimes.of((String)"2011-01-02"), ImmutableMap.of((Object)"a", (Object)"c", (Object)"rows", (Object)5)), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSelectResults(dimensions, metrics, DateTimes.of((String)"2011-01-05"), DateTimes.of((String)"2011-01-06"), DateTimes.of((String)"2011-01-07"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)7), ImmutableMap.of((Object)"a", (Object)"ff"), DateTimes.of((String)"2011-01-08"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)8), DateTimes.of((String)"2011-01-09"), ImmutableMap.of((Object)"a", (Object)"h", (Object)"rows", (Object)9)), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSelectResults(dimensions, metrics, DateTimes.of((String)"2011-01-05T01"), ImmutableMap.of((Object)"a", (Object)"d", (Object)"rows", (Object)5), DateTimes.of((String)"2011-01-06T01"), ImmutableMap.of((Object)"a", (Object)"e", (Object)"rows", (Object)6), DateTimes.of((String)"2011-01-07T01"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)7), DateTimes.of((String)"2011-01-08T01"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)8), DateTimes.of((String)"2011-01-09T01"), ImmutableMap.of((Object)"a", (Object)"h", (Object)"rows", (Object)9)));
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new SelectQueryQueryToolChest((ObjectMapper)jsonMapper, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator(), selectConfigSupplier));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(this.makeSelectResults(dimensions, metrics, DateTimes.of((String)"2011-01-01"), ImmutableMap.of((Object)"a", (Object)"b", (Object)"rows", (Object)1), DateTimes.of((String)"2011-01-02"), ImmutableMap.of((Object)"a", (Object)"c", (Object)"rows", (Object)5), DateTimes.of((String)"2011-01-05"), DateTimes.of((String)"2011-01-05T01"), ImmutableMap.of((Object)"a", (Object)"d", (Object)"rows", (Object)5), DateTimes.of((String)"2011-01-06"), DateTimes.of((String)"2011-01-06T01"), ImmutableMap.of((Object)"a", (Object)"e", (Object)"rows", (Object)6), DateTimes.of((String)"2011-01-07"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)7), ImmutableMap.of((Object)"a", (Object)"ff"), DateTimes.of((String)"2011-01-07T01"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)7), DateTimes.of((String)"2011-01-08"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)8), DateTimes.of((String)"2011-01-08T01"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)8), DateTimes.of((String)"2011-01-09"), ImmutableMap.of((Object)"a", (Object)"h", (Object)"rows", (Object)9), DateTimes.of((String)"2011-01-09T01"), ImmutableMap.of((Object)"a", (Object)"h", (Object)"rows", (Object)9)), runner.run(QueryPlus.wrap((Query)builder.intervals("2011-01-01/2011-01-10").build()), context));
    }

    @Test
    public void testSelectCachingRenamedOutputName() throws Exception {
        HashSet dimensions = Sets.newHashSet((Object[])new String[]{"a"});
        HashSet metrics = Sets.newHashSet((Object[])new String[]{"rows"});
        Druids.SelectQueryBuilder builder = Druids.newSelectQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).dimensions(Arrays.asList("a")).metrics(Arrays.asList("rows")).pagingSpec(new PagingSpec(null, 3)).context(CONTEXT);
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)builder.build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeSelectResults(dimensions, metrics, DateTimes.of((String)"2011-01-01"), ImmutableMap.of((Object)"a", (Object)"b", (Object)"rows", (Object)1)), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeSelectResults(dimensions, metrics, DateTimes.of((String)"2011-01-02"), ImmutableMap.of((Object)"a", (Object)"c", (Object)"rows", (Object)5)), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSelectResults(dimensions, metrics, DateTimes.of((String)"2011-01-05"), ImmutableMap.of((Object)"a", (Object)"d", (Object)"rows", (Object)5), DateTimes.of((String)"2011-01-06"), ImmutableMap.of((Object)"a", (Object)"e", (Object)"rows", (Object)6), DateTimes.of((String)"2011-01-07"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)7), DateTimes.of((String)"2011-01-08"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)8), DateTimes.of((String)"2011-01-09"), ImmutableMap.of((Object)"a", (Object)"h", (Object)"rows", (Object)9)), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSelectResults(dimensions, metrics, DateTimes.of((String)"2011-01-05T01"), ImmutableMap.of((Object)"a", (Object)"d", (Object)"rows", (Object)5), DateTimes.of((String)"2011-01-06T01"), ImmutableMap.of((Object)"a", (Object)"e", (Object)"rows", (Object)6), DateTimes.of((String)"2011-01-07T01"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)7), DateTimes.of((String)"2011-01-08T01"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)8), DateTimes.of((String)"2011-01-09T01"), ImmutableMap.of((Object)"a", (Object)"h", (Object)"rows", (Object)9)));
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new SelectQueryQueryToolChest((ObjectMapper)jsonMapper, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator(), selectConfigSupplier));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(this.makeSelectResults(dimensions, metrics, DateTimes.of((String)"2011-01-01"), ImmutableMap.of((Object)"a", (Object)"b", (Object)"rows", (Object)1), DateTimes.of((String)"2011-01-02"), ImmutableMap.of((Object)"a", (Object)"c", (Object)"rows", (Object)5), DateTimes.of((String)"2011-01-05"), ImmutableMap.of((Object)"a", (Object)"d", (Object)"rows", (Object)5), DateTimes.of((String)"2011-01-05T01"), ImmutableMap.of((Object)"a", (Object)"d", (Object)"rows", (Object)5), DateTimes.of((String)"2011-01-06"), ImmutableMap.of((Object)"a", (Object)"e", (Object)"rows", (Object)6), DateTimes.of((String)"2011-01-06T01"), ImmutableMap.of((Object)"a", (Object)"e", (Object)"rows", (Object)6), DateTimes.of((String)"2011-01-07"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)7), DateTimes.of((String)"2011-01-07T01"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)7), DateTimes.of((String)"2011-01-08"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)8), DateTimes.of((String)"2011-01-08T01"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)8), DateTimes.of((String)"2011-01-09"), ImmutableMap.of((Object)"a", (Object)"h", (Object)"rows", (Object)9), DateTimes.of((String)"2011-01-09T01"), ImmutableMap.of((Object)"a", (Object)"h", (Object)"rows", (Object)9)), runner.run(QueryPlus.wrap((Query)builder.intervals("2011-01-01/2011-01-10").build()), context));
        SelectQuery query = builder.intervals("2011-01-01/2011-01-10").dimensionSpecs((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("a", "a2")})).build();
        TestHelper.assertExpectedResults(this.makeSelectResults(dimensions, metrics, DateTimes.of((String)"2011-01-01"), ImmutableMap.of((Object)"a2", (Object)"b", (Object)"rows", (Object)1), DateTimes.of((String)"2011-01-02"), ImmutableMap.of((Object)"a2", (Object)"c", (Object)"rows", (Object)5), DateTimes.of((String)"2011-01-05"), ImmutableMap.of((Object)"a2", (Object)"d", (Object)"rows", (Object)5), DateTimes.of((String)"2011-01-05T01"), ImmutableMap.of((Object)"a2", (Object)"d", (Object)"rows", (Object)5), DateTimes.of((String)"2011-01-06"), ImmutableMap.of((Object)"a2", (Object)"e", (Object)"rows", (Object)6), DateTimes.of((String)"2011-01-06T01"), ImmutableMap.of((Object)"a2", (Object)"e", (Object)"rows", (Object)6), DateTimes.of((String)"2011-01-07"), ImmutableMap.of((Object)"a2", (Object)"f", (Object)"rows", (Object)7), DateTimes.of((String)"2011-01-07T01"), ImmutableMap.of((Object)"a2", (Object)"f", (Object)"rows", (Object)7), DateTimes.of((String)"2011-01-08"), ImmutableMap.of((Object)"a2", (Object)"g", (Object)"rows", (Object)8), DateTimes.of((String)"2011-01-08T01"), ImmutableMap.of((Object)"a2", (Object)"g", (Object)"rows", (Object)8), DateTimes.of((String)"2011-01-09"), ImmutableMap.of((Object)"a2", (Object)"h", (Object)"rows", (Object)9), DateTimes.of((String)"2011-01-09T01"), ImmutableMap.of((Object)"a2", (Object)"h", (Object)"rows", (Object)9)), runner.run(QueryPlus.wrap((Query)query), context));
    }

    @Test
    public void testGroupByCaching() throws Exception {
        ImmutableList aggsWithUniques = ImmutableList.builder().addAll(AGGS).add((Object)new HyperUniquesAggregatorFactory("uniques", "uniques")).build();
        HashFunction hashFn = Hashing.murmur3_128();
        GroupByQuery.Builder builder = new GroupByQuery.Builder().setDataSource(DATA_SOURCE).setQuerySegmentSpec((QuerySegmentSpec)SEG_SPEC).setDimFilter(DIM_FILTER).setGranularity(GRANULARITY).setDimensions(Arrays.asList(new DefaultDimensionSpec("a", "a"))).setAggregatorSpecs((List)aggsWithUniques).setPostAggregatorSpecs(POST_AGGS).setContext(CONTEXT);
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        collector.add(hashFn.hashString((CharSequence)"abc123", Charsets.UTF_8).asBytes());
        collector.add(hashFn.hashString((CharSequence)"123abc", Charsets.UTF_8).asBytes());
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)builder.build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeGroupByResults(DateTimes.of((String)"2011-01-01"), ImmutableMap.of((Object)"a", (Object)"a", (Object)"rows", (Object)1, (Object)"imps", (Object)1, (Object)"impers", (Object)1, (Object)"uniques", (Object)collector)), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeGroupByResults(DateTimes.of((String)"2011-01-02"), ImmutableMap.of((Object)"a", (Object)"b", (Object)"rows", (Object)2, (Object)"imps", (Object)2, (Object)"impers", (Object)2, (Object)"uniques", (Object)collector)), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeGroupByResults(DateTimes.of((String)"2011-01-05"), ImmutableMap.of((Object)"a", (Object)"c", (Object)"rows", (Object)3, (Object)"imps", (Object)3, (Object)"impers", (Object)3, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-06"), ImmutableMap.of((Object)"a", (Object)"d", (Object)"rows", (Object)4, (Object)"imps", (Object)4, (Object)"impers", (Object)4, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-07"), ImmutableMap.of((Object)"a", (Object)"e", (Object)"rows", (Object)5, (Object)"imps", (Object)5, (Object)"impers", (Object)5, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-08"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)6, (Object)"imps", (Object)6, (Object)"impers", (Object)6, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-09"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)7, (Object)"imps", (Object)7, (Object)"impers", (Object)7, (Object)"uniques", (Object)collector)), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeGroupByResults(DateTimes.of((String)"2011-01-05T01"), ImmutableMap.of((Object)"a", (Object)"c", (Object)"rows", (Object)3, (Object)"imps", (Object)3, (Object)"impers", (Object)3, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-06T01"), ImmutableMap.of((Object)"a", (Object)"d", (Object)"rows", (Object)4, (Object)"imps", (Object)4, (Object)"impers", (Object)4, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-07T01"), ImmutableMap.of((Object)"a", (Object)"e", (Object)"rows", (Object)5, (Object)"imps", (Object)5, (Object)"impers", (Object)5, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-08T01"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)6, (Object)"imps", (Object)6, (Object)"impers", (Object)6, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-09T01"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)7, (Object)"imps", (Object)7, (Object)"impers", (Object)7, (Object)"uniques", (Object)collector)));
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), GroupByQueryRunnerTest.makeQueryRunnerFactory(new GroupByQueryConfig()).getToolchest());
        HashMap context = new HashMap();
        TestHelper.assertExpectedObjects(this.makeGroupByResults(DateTimes.of((String)"2011-01-05T"), ImmutableMap.of((Object)"a", (Object)"c", (Object)"rows", (Object)3, (Object)"imps", (Object)3, (Object)"impers", (Object)3, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-05T01"), ImmutableMap.of((Object)"a", (Object)"c", (Object)"rows", (Object)3, (Object)"imps", (Object)3, (Object)"impers", (Object)3, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-06T"), ImmutableMap.of((Object)"a", (Object)"d", (Object)"rows", (Object)4, (Object)"imps", (Object)4, (Object)"impers", (Object)4, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-06T01"), ImmutableMap.of((Object)"a", (Object)"d", (Object)"rows", (Object)4, (Object)"imps", (Object)4, (Object)"impers", (Object)4, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-07T"), ImmutableMap.of((Object)"a", (Object)"e", (Object)"rows", (Object)5, (Object)"imps", (Object)5, (Object)"impers", (Object)5, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-07T01"), ImmutableMap.of((Object)"a", (Object)"e", (Object)"rows", (Object)5, (Object)"imps", (Object)5, (Object)"impers", (Object)5, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-08T"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)6, (Object)"imps", (Object)6, (Object)"impers", (Object)6, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-08T01"), ImmutableMap.of((Object)"a", (Object)"f", (Object)"rows", (Object)6, (Object)"imps", (Object)6, (Object)"impers", (Object)6, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-09T"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)7, (Object)"imps", (Object)7, (Object)"impers", (Object)7, (Object)"uniques", (Object)collector), DateTimes.of((String)"2011-01-09T01"), ImmutableMap.of((Object)"a", (Object)"g", (Object)"rows", (Object)7, (Object)"imps", (Object)7, (Object)"impers", (Object)7, (Object)"uniques", (Object)collector)), runner.run(QueryPlus.wrap((Query)builder.setInterval("2011-01-05/2011-01-10").build()), context), "");
    }

    @Test
    public void testTimeBoundaryCaching() throws Exception {
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-01"), DateTimes.of((String)"2011-01-01"), DateTimes.of((String)"2011-01-02")), Intervals.of((String)"2011-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-02"), DateTimes.of((String)"2011-01-02"), DateTimes.of((String)"2011-01-03")), Intervals.of((String)"2011-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-05"), DateTimes.of((String)"2011-01-05"), DateTimes.of((String)"2011-01-10")), Intervals.of((String)"2011-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-05T01"), DateTimes.of((String)"2011-01-05T01"), DateTimes.of((String)"2011-01-10")));
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).bound("maxTime").build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-01"), null, DateTimes.of((String)"2011-01-02")), Intervals.of((String)"2011-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-02"), null, DateTimes.of((String)"2011-01-03")), Intervals.of((String)"2011-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-05"), null, DateTimes.of((String)"2011-01-10")), Intervals.of((String)"2011-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-05T01"), null, DateTimes.of((String)"2011-01-10")));
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).bound("minTime").build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-01"), DateTimes.of((String)"2011-01-01"), null), Intervals.of((String)"2011-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-02"), DateTimes.of((String)"2011-01-02"), null), Intervals.of((String)"2011-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-05"), DateTimes.of((String)"2011-01-05"), null), Intervals.of((String)"2011-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-05T01"), DateTimes.of((String)"2011-01-05T01"), null));
    }

    @Test
    public void testTimeSeriesWithFilter() throws Exception {
        AndDimFilter filter = new AndDimFilter(new DimFilter[]{new OrDimFilter(new DimFilter[]{new SelectorDimFilter("dim0", "1", null), new BoundDimFilter("dim0", "222", "333", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)}), new AndDimFilter(new DimFilter[]{new InDimFilter("dim1", Arrays.asList("0", "1", "2", "3", "4"), null), new BoundDimFilter("dim1", "0", "3", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), new BoundDimFilter("dim1", "1", "9999", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)})});
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters((DimFilter)filter).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        List<Iterable<Result<TimeseriesResultValue>>> expectedResult = Arrays.asList(this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000, DateTimes.of((String)"2011-01-02"), 10, 1252, DateTimes.of((String)"2011-01-03"), 20, 6213, DateTimes.of((String)"2011-01-04"), 30, 743), this.makeTimeResults(DateTimes.of((String)"2011-01-07"), 60, 6020, DateTimes.of((String)"2011-01-08"), 70, 250));
        this.testQueryCachingWithFilter((QueryRunner)runner, 3, (Query)builder.build(), expectedResult, Intervals.of((String)"2011-01-01/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000), Intervals.of((String)"2011-01-01/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-02"), 10, 1252), Intervals.of((String)"2011-01-01/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-03"), 20, 6213), Intervals.of((String)"2011-01-01/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-04"), 30, 743), Intervals.of((String)"2011-01-01/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-05"), 40, 6000), Intervals.of((String)"2011-01-06/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-06"), 50, 425), Intervals.of((String)"2011-01-06/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-07"), 60, 6020), Intervals.of((String)"2011-01-06/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-08"), 70, 250), Intervals.of((String)"2011-01-06/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-09"), 23, 85312), Intervals.of((String)"2011-01-06/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-10"), 100, 512));
    }

    @Test
    public void testSingleDimensionPruning() throws Exception {
        AndDimFilter filter = new AndDimFilter(new DimFilter[]{new OrDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "a", null), new BoundDimFilter("dim1", "from", "to", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)}), new AndDimFilter(new DimFilter[]{new InDimFilter("dim2", Arrays.asList("a", "c", "e", "g"), null), new BoundDimFilter("dim2", "aaa", "hi", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), new BoundDimFilter("dim2", "e", "zzz", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)})});
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).filters((DimFilter)filter).granularity(GRANULARITY).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).intervals("2011-01-05/2011-01-10").aggregators(RENAMED_AGGS).postAggregators(RENAMED_POST_AGGS);
        TimeseriesQuery query = builder.build();
        HashMap context = new HashMap();
        Interval interval1 = Intervals.of((String)"2011-01-06/2011-01-07");
        Interval interval2 = Intervals.of((String)"2011-01-07/2011-01-08");
        Interval interval3 = Intervals.of((String)"2011-01-08/2011-01-09");
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()));
        DruidServer lastServer = this.servers[this.random.nextInt(this.servers.length)];
        ServerSelector selector1 = this.makeMockSingleDimensionSelector(lastServer, "dim1", null, "b", 1);
        ServerSelector selector2 = this.makeMockSingleDimensionSelector(lastServer, "dim1", "e", "f", 2);
        ServerSelector selector3 = this.makeMockSingleDimensionSelector(lastServer, "dim1", "hi", "zzz", 3);
        ServerSelector selector4 = this.makeMockSingleDimensionSelector(lastServer, "dim2", "a", "e", 4);
        ServerSelector selector5 = this.makeMockSingleDimensionSelector(lastServer, "dim2", null, null, 5);
        ServerSelector selector6 = this.makeMockSingleDimensionSelector(lastServer, "other", "b", null, 6);
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new StringPartitionChunk(null, "a", 1, (Object)selector1));
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new StringPartitionChunk("a", "b", 2, (Object)selector2));
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new StringPartitionChunk("b", null, 3, (Object)selector3));
        this.timeline.add(interval2, (Object)"v", (PartitionChunk)new StringPartitionChunk(null, "d", 4, (Object)selector4));
        this.timeline.add(interval2, (Object)"v", (PartitionChunk)new StringPartitionChunk("d", null, 5, (Object)selector5));
        this.timeline.add(interval3, (Object)"v", (PartitionChunk)new StringPartitionChunk(null, null, 6, (Object)selector6));
        Capture capture = Capture.newInstance();
        Capture contextCap = Capture.newInstance();
        QueryRunner mockRunner = (QueryRunner)EasyMock.createNiceMock(QueryRunner.class);
        EasyMock.expect((Object)mockRunner.run((QueryPlus)EasyMock.capture((Capture)capture), (Map)EasyMock.capture((Capture)contextCap))).andReturn((Object)Sequences.empty()).anyTimes();
        EasyMock.expect((Object)this.serverView.getQueryRunner(lastServer)).andReturn((Object)mockRunner).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverView});
        EasyMock.replay((Object[])new Object[]{mockRunner});
        ArrayList<SegmentDescriptor> descriptors = new ArrayList<SegmentDescriptor>();
        descriptors.add(new SegmentDescriptor(interval1, "v", 1));
        descriptors.add(new SegmentDescriptor(interval1, "v", 3));
        descriptors.add(new SegmentDescriptor(interval2, "v", 5));
        descriptors.add(new SegmentDescriptor(interval3, "v", 6));
        MultipleSpecificSegmentSpec expected = new MultipleSpecificSegmentSpec(descriptors);
        Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        Assert.assertEquals((Object)expected, (Object)((TimeseriesQuery)((QueryPlus)capture.getValue()).getQuery()).getQuerySegmentSpec());
    }

    private ServerSelector makeMockSingleDimensionSelector(DruidServer server, String dimension, String start, String end, int partitionNum) {
        DataSegment segment = (DataSegment)EasyMock.createNiceMock(DataSegment.class);
        EasyMock.expect((Object)segment.getIdentifier()).andReturn((Object)DATA_SOURCE).anyTimes();
        EasyMock.expect((Object)segment.getShardSpec()).andReturn((Object)new SingleDimensionShardSpec(dimension, start, end, partitionNum)).anyTimes();
        EasyMock.replay((Object[])new Object[]{segment});
        ServerSelector selector = new ServerSelector(segment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
        selector.addServerAndUpdateSegment(new QueryableDruidServer(server, null), segment);
        return selector;
    }

    private Iterable<Result<TimeBoundaryResultValue>> makeTimeBoundaryResult(DateTime timestamp, DateTime minTime, DateTime maxTime) {
        ImmutableMap value = minTime != null && maxTime != null ? ImmutableMap.of((Object)"minTime", (Object)minTime.toString(), (Object)"maxTime", (Object)maxTime.toString()) : (maxTime != null ? ImmutableMap.of((Object)"maxTime", (Object)maxTime.toString()) : ImmutableMap.of((Object)"minTime", (Object)minTime.toString()));
        return ImmutableList.of((Object)new Result(timestamp, (Object)new TimeBoundaryResultValue((Object)value)));
    }

    public void parseResults(List<Interval> queryIntervals, List<List<Iterable<Result<Object>>>> expectedResults, Object ... args) {
        if (args.length % 2 != 0) {
            throw new ISE("args.length must be divisible by two, was %d", new Object[]{args.length});
        }
        for (int i = 0; i < args.length; i += 2) {
            Interval interval = (Interval)args[i];
            Iterable results = (Iterable)args[i + 1];
            if (queryIntervals.size() > 0 && interval.equals((Object)queryIntervals.get(queryIntervals.size() - 1))) {
                expectedResults.get(expectedResults.size() - 1).add(results);
                continue;
            }
            queryIntervals.add(interval);
            expectedResults.add(Lists.newArrayList((Object[])new Iterable[]{results}));
        }
    }

    public void testQueryCachingWithFilter(final QueryRunner runner, final int numTimesToQuery, final Query query, List<Iterable<Result<TimeseriesResultValue>>> filteredExpected, Object ... args) {
        final ArrayList queryIntervals = Lists.newArrayListWithCapacity((int)(args.length / 2));
        ArrayList expectedResults = Lists.newArrayListWithCapacity((int)queryIntervals.size());
        this.parseResults(queryIntervals, expectedResults, args);
        for (int i = 0; i < queryIntervals.size(); ++i) {
            ArrayList mocks = Lists.newArrayList();
            mocks.add(this.serverView);
            final Interval actualQueryInterval = new Interval((ReadableInstant)((Interval)queryIntervals.get(0)).getStart(), (ReadableInstant)((Interval)queryIntervals.get(i)).getEnd());
            List<Map<DruidServer, ServerExpectations>> serverExpectationList = this.populateTimeline(queryIntervals, expectedResults, i, mocks);
            Map<DruidServer, ServerExpectations> finalExpectation = serverExpectationList.get(serverExpectationList.size() - 1);
            for (Map.Entry<DruidServer, ServerExpectations> entry : finalExpectation.entrySet()) {
                DruidServer server = entry.getKey();
                ServerExpectations expectations = entry.getValue();
                EasyMock.expect((Object)this.serverView.getQueryRunner(server)).andReturn((Object)expectations.getQueryRunner()).times(0, 1);
                final Capture capture = new Capture();
                Capture context = new Capture();
                QueryRunner queryable = expectations.getQueryRunner();
                if (query instanceof TimeseriesQuery) {
                    final ArrayList segmentIds = Lists.newArrayList();
                    final ArrayList results = Lists.newArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (Map)EasyMock.capture((Capture)context))).andAnswer((IAnswer)new IAnswer<Sequence>(){

                        public Sequence answer() throws Throwable {
                            return CachingClusteredClientTest.this.toFilteredQueryableTimeseriesResults((TimeseriesQuery)((QueryPlus)capture.getValue()).getQuery(), segmentIds, queryIntervals, results);
                        }
                    }).times(0, 1);
                    continue;
                }
                throw new ISE("Unknown query type[%s]", new Object[]{query.getClass()});
            }
            final ArrayList expected = new ArrayList();
            for (int intervalNo = 0; intervalNo < i + 1; ++intervalNo) {
                Iterables.addAll((Collection)expected, filteredExpected.get(intervalNo));
            }
            this.runWithMocks(new Runnable(){

                @Override
                public void run() {
                    HashMap context = new HashMap();
                    for (int i = 0; i < numTimesToQuery; ++i) {
                        TestHelper.assertExpectedResults(expected, runner.run(QueryPlus.wrap((Query)query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)actualQueryInterval)))), context));
                        if (CachingClusteredClientTest.this.queryCompletedCallback == null) continue;
                        CachingClusteredClientTest.this.queryCompletedCallback.run();
                    }
                }
            }, mocks.toArray());
        }
    }

    private Sequence<Result<TimeseriesResultValue>> toFilteredQueryableTimeseriesResults(TimeseriesQuery query, List<String> segmentIds, List<Interval> queryIntervals, List<Iterable<Result<TimeseriesResultValue>>> results) {
        MultipleSpecificSegmentSpec spec = (MultipleSpecificSegmentSpec)query.getQuerySegmentSpec();
        ArrayList ret = Lists.newArrayList();
        for (SegmentDescriptor descriptor : spec.getDescriptors()) {
            String id = StringUtils.format((String)"%s_%s", (Object[])new Object[]{queryIntervals.indexOf(descriptor.getInterval()), descriptor.getPartitionNumber()});
            int index = segmentIds.indexOf(id);
            if (index != -1) {
                ret.add(new Result(results.get(index).iterator().next().getTimestamp(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results.get(index)), id, descriptor.getInterval())));
                continue;
            }
            throw new ISE("Descriptor %s not found in server", new Object[]{id});
        }
        return Sequences.simple((Iterable)ret);
    }

    public void testQueryCaching(QueryRunner runner, Query query, Object ... args) {
        this.testQueryCaching(runner, 3, true, query, args);
    }

    public void testQueryCaching(final QueryRunner runner, final int numTimesToQuery, boolean expectBySegment, final Query query, Object ... args) {
        ArrayList queryIntervals = Lists.newArrayListWithCapacity((int)(args.length / 2));
        ArrayList expectedResults = Lists.newArrayListWithCapacity((int)queryIntervals.size());
        this.parseResults(queryIntervals, expectedResults, args);
        for (int i = 0; i < queryIntervals.size(); ++i) {
            int expectedResultsRangeEnd;
            int expectedResultsRangeStart;
            ArrayList mocks = Lists.newArrayList();
            mocks.add(this.serverView);
            final Interval actualQueryInterval = new Interval((ReadableInstant)((Interval)queryIntervals.get(0)).getStart(), (ReadableInstant)((Interval)queryIntervals.get(i)).getEnd());
            final List<Map<DruidServer, ServerExpectations>> serverExpectationList = this.populateTimeline(queryIntervals, expectedResults, i, mocks);
            ArrayList queryCaptures = Lists.newArrayList();
            Map<DruidServer, ServerExpectations> finalExpectation = serverExpectationList.get(serverExpectationList.size() - 1);
            for (Map.Entry<DruidServer, ServerExpectations> entry : finalExpectation.entrySet()) {
                ArrayList results;
                ArrayList intervals;
                ArrayList segmentIds;
                DruidServer server = entry.getKey();
                ServerExpectations expectations = entry.getValue();
                EasyMock.expect((Object)this.serverView.getQueryRunner(server)).andReturn((Object)expectations.getQueryRunner()).once();
                Capture capture = new Capture();
                Capture context = new Capture();
                queryCaptures.add(capture);
                QueryRunner queryable = expectations.getQueryRunner();
                if (query instanceof TimeseriesQuery) {
                    segmentIds = Lists.newArrayList();
                    intervals = Lists.newArrayList();
                    results = Lists.newArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        intervals.add(expectation.getInterval());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (Map)EasyMock.capture((Capture)context))).andReturn(this.toQueryableTimeseriesResults(expectBySegment, segmentIds, intervals, results)).once();
                    continue;
                }
                if (query instanceof TopNQuery) {
                    segmentIds = Lists.newArrayList();
                    intervals = Lists.newArrayList();
                    results = Lists.newArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        intervals.add(expectation.getInterval());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (Map)EasyMock.capture((Capture)context))).andReturn(this.toQueryableTopNResults(segmentIds, intervals, results)).once();
                    continue;
                }
                if (query instanceof SearchQuery) {
                    segmentIds = Lists.newArrayList();
                    intervals = Lists.newArrayList();
                    results = Lists.newArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        intervals.add(expectation.getInterval());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (Map)EasyMock.capture((Capture)context))).andReturn(this.toQueryableSearchResults(segmentIds, intervals, results)).once();
                    continue;
                }
                if (query instanceof SelectQuery) {
                    segmentIds = Lists.newArrayList();
                    intervals = Lists.newArrayList();
                    results = Lists.newArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        intervals.add(expectation.getInterval());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (Map)EasyMock.capture((Capture)context))).andReturn(this.toQueryableSelectResults(segmentIds, intervals, results)).once();
                    continue;
                }
                if (query instanceof GroupByQuery) {
                    segmentIds = Lists.newArrayList();
                    intervals = Lists.newArrayList();
                    results = Lists.newArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        intervals.add(expectation.getInterval());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (Map)EasyMock.capture((Capture)context))).andReturn(this.toQueryableGroupByResults(segmentIds, intervals, results)).once();
                    continue;
                }
                if (query instanceof TimeBoundaryQuery) {
                    segmentIds = Lists.newArrayList();
                    intervals = Lists.newArrayList();
                    results = Lists.newArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        intervals.add(expectation.getInterval());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (Map)EasyMock.capture((Capture)context))).andReturn(this.toQueryableTimeBoundaryResults(segmentIds, intervals, results)).once();
                    continue;
                }
                throw new ISE("Unknown query type[%s]", new Object[]{query.getClass()});
            }
            if (query instanceof TimeBoundaryQuery) {
                expectedResultsRangeStart = i;
                expectedResultsRangeEnd = i + 1;
            } else {
                expectedResultsRangeStart = 0;
                expectedResultsRangeEnd = i + 1;
            }
            this.runWithMocks(new Runnable(){

                @Override
                public void run() {
                    HashMap context = new HashMap();
                    for (int i = 0; i < numTimesToQuery; ++i) {
                        TestHelper.assertExpectedResults(new MergeIterable((Comparator)Comparators.naturalNullsFirst(), (Iterable)FunctionalIterable.create((Iterable)new RangeIterable(expectedResultsRangeStart, expectedResultsRangeEnd)).transformCat((Function)new Function<Integer, Iterable<Iterable<Result<Object>>>>(){

                            public Iterable<Iterable<Result<Object>>> apply(@Nullable Integer input) {
                                ArrayList retVal = Lists.newArrayList();
                                Map exps = (Map)serverExpectationList.get(input);
                                for (ServerExpectations expectations : exps.values()) {
                                    for (ServerExpectation expectation : expectations) {
                                        retVal.add(expectation.getResults());
                                    }
                                }
                                return retVal;
                            }
                        })), runner.run(QueryPlus.wrap((Query)query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)actualQueryInterval)))), context));
                        if (CachingClusteredClientTest.this.queryCompletedCallback == null) continue;
                        CachingClusteredClientTest.this.queryCompletedCallback.run();
                    }
                }
            }, mocks.toArray());
            for (Capture queryCapture : queryCaptures) {
                QueryPlus capturedQueryPlus = (QueryPlus)queryCapture.getValue();
                Query capturedQuery = capturedQueryPlus.getQuery();
                if (expectBySegment) {
                    Assert.assertEquals((Object)true, (Object)capturedQuery.getContextValue("bySegment"));
                    continue;
                }
                Assert.assertTrue((capturedQuery.getContextValue("bySegment") == null || capturedQuery.getContextValue("bySegment").equals(false) ? 1 : 0) != 0);
            }
        }
    }

    private List<Map<DruidServer, ServerExpectations>> populateTimeline(List<Interval> queryIntervals, List<List<Iterable<Result<Object>>>> expectedResults, int numQueryIntervals, List<Object> mocks) {
        this.timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        ArrayList serverExpectationList = Lists.newArrayList();
        for (int k = 0; k < numQueryIntervals + 1; ++k) {
            int numChunks = expectedResults.get(k).size();
            TreeMap serverExpectations = Maps.newTreeMap();
            serverExpectationList.add(serverExpectations);
            for (int j = 0; j < numChunks; ++j) {
                SingleDimensionShardSpec shardSpec;
                DruidServer lastServer = this.servers[this.random.nextInt(this.servers.length)];
                if (!serverExpectations.containsKey(lastServer)) {
                    serverExpectations.put(lastServer, new ServerExpectations(lastServer, this.makeMock(mocks, QueryRunner.class)));
                }
                DataSegment mockSegment = this.makeMock(mocks, DataSegment.class);
                ServerExpectation expectation = new ServerExpectation(StringUtils.format((String)"%s_%s", (Object[])new Object[]{k, j}), queryIntervals.get(k), mockSegment, expectedResults.get(k).get(j));
                ((ServerExpectations)serverExpectations.get(lastServer)).addExpectation(expectation);
                ServerSelector selector = new ServerSelector(expectation.getSegment(), (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
                selector.addServerAndUpdateSegment(new QueryableDruidServer(lastServer, null), selector.getSegment());
                if (numChunks == 1) {
                    shardSpec = new SingleDimensionShardSpec("dimAll", null, null, 0);
                } else {
                    String start = null;
                    String end = null;
                    if (j > 0) {
                        start = String.valueOf(j);
                    }
                    if (j + 1 < numChunks) {
                        end = String.valueOf(j + 1);
                    }
                    shardSpec = new SingleDimensionShardSpec("dim" + k, start, end, j);
                }
                EasyMock.expect((Object)mockSegment.getShardSpec()).andReturn((Object)shardSpec).anyTimes();
                this.timeline.add(queryIntervals.get(k), (Object)String.valueOf(k), shardSpec.createChunk((Object)selector));
            }
        }
        return serverExpectationList;
    }

    private Sequence<Result<TimeseriesResultValue>> toQueryableTimeseriesResults(boolean bySegment, Iterable<String> segmentIds, Iterable<Interval> intervals, Iterable<Iterable<Result<TimeseriesResultValue>>> results) {
        if (bySegment) {
            return Sequences.simple((Iterable)FunctionalIterable.create(segmentIds).trinaryTransform(intervals, results, (TrinaryFn)new TrinaryFn<String, Interval, Iterable<Result<TimeseriesResultValue>>, Result<TimeseriesResultValue>>(){

                public Result<TimeseriesResultValue> apply(String segmentId, Interval interval, Iterable<Result<TimeseriesResultValue>> results) {
                    return new Result(results.iterator().next().getTimestamp(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results), segmentId, interval));
                }
            }));
        }
        return Sequences.simple((Iterable)Iterables.concat(results));
    }

    private Sequence<Result<TopNResultValue>> toQueryableTopNResults(Iterable<String> segmentIds, Iterable<Interval> intervals, Iterable<Iterable<Result<TopNResultValue>>> results) {
        return Sequences.simple((Iterable)FunctionalIterable.create(segmentIds).trinaryTransform(intervals, results, (TrinaryFn)new TrinaryFn<String, Interval, Iterable<Result<TopNResultValue>>, Result<TopNResultValue>>(){

            public Result<TopNResultValue> apply(String segmentId, Interval interval, Iterable<Result<TopNResultValue>> results) {
                return new Result(interval.getStart(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results), segmentId, interval));
            }
        }));
    }

    private Sequence<Result<SearchResultValue>> toQueryableSearchResults(Iterable<String> segmentIds, Iterable<Interval> intervals, Iterable<Iterable<Result<SearchResultValue>>> results) {
        return Sequences.simple((Iterable)FunctionalIterable.create(segmentIds).trinaryTransform(intervals, results, (TrinaryFn)new TrinaryFn<String, Interval, Iterable<Result<SearchResultValue>>, Result<SearchResultValue>>(){

            public Result<SearchResultValue> apply(String segmentId, Interval interval, Iterable<Result<SearchResultValue>> results) {
                return new Result(results.iterator().next().getTimestamp(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results), segmentId, interval));
            }
        }));
    }

    private Sequence<Result<SelectResultValue>> toQueryableSelectResults(Iterable<String> segmentIds, Iterable<Interval> intervals, Iterable<Iterable<Result<SelectResultValue>>> results) {
        return Sequences.simple((Iterable)FunctionalIterable.create(segmentIds).trinaryTransform(intervals, results, (TrinaryFn)new TrinaryFn<String, Interval, Iterable<Result<SelectResultValue>>, Result<SelectResultValue>>(){

            public Result<SelectResultValue> apply(String segmentId, Interval interval, Iterable<Result<SelectResultValue>> results) {
                return new Result(results.iterator().next().getTimestamp(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results), segmentId, interval));
            }
        }));
    }

    private Sequence<Result> toQueryableGroupByResults(Iterable<String> segmentIds, Iterable<Interval> intervals, Iterable<Iterable<Row>> results) {
        return Sequences.simple((Iterable)FunctionalIterable.create(segmentIds).trinaryTransform(intervals, results, (TrinaryFn)new TrinaryFn<String, Interval, Iterable<Row>, Result>(){

            public Result apply(String segmentId, Interval interval, Iterable<Row> results) {
                return new Result(results.iterator().next().getTimestamp(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results), segmentId, interval));
            }
        }));
    }

    private Sequence<Result<TimeBoundaryResultValue>> toQueryableTimeBoundaryResults(Iterable<String> segmentIds, Iterable<Interval> intervals, Iterable<Iterable<Result<TimeBoundaryResultValue>>> results) {
        return Sequences.simple((Iterable)FunctionalIterable.create(segmentIds).trinaryTransform(intervals, results, (TrinaryFn)new TrinaryFn<String, Interval, Iterable<Result<TimeBoundaryResultValue>>, Result<TimeBoundaryResultValue>>(){

            public Result<TimeBoundaryResultValue> apply(String segmentId, Interval interval, Iterable<Result<TimeBoundaryResultValue>> results) {
                return new Result(results.iterator().next().getTimestamp(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results), segmentId, interval));
            }
        }));
    }

    private Iterable<Result<TimeseriesResultValue>> makeTimeResults(Object ... objects) {
        if (objects.length % 3 != 0) {
            throw new ISE("makeTimeResults must be passed arguments in groups of 3, got[%d]", new Object[]{objects.length});
        }
        ArrayList retVal = Lists.newArrayListWithCapacity((int)(objects.length / 3));
        for (int i = 0; i < objects.length; i += 3) {
            double avg_impr = ((Number)objects[i + 2]).doubleValue() / ((Number)objects[i + 1]).doubleValue();
            retVal.add(new Result((DateTime)objects[i], (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", objects[i + 1]).put((Object)"imps", objects[i + 2]).put((Object)"impers", objects[i + 2]).put((Object)"avg_imps_per_row", (Object)avg_impr).put((Object)"avg_imps_per_row_half", (Object)(avg_impr / 2.0)).put((Object)"avg_imps_per_row_double", (Object)(avg_impr * 2.0)).build())));
        }
        return retVal;
    }

    private Iterable<BySegmentResultValueClass<TimeseriesResultValue>> makeBySegmentTimeResults(Object ... objects) {
        if (objects.length % 5 != 0) {
            throw new ISE("makeTimeResults must be passed arguments in groups of 5, got[%d]", new Object[]{objects.length});
        }
        ArrayList retVal = Lists.newArrayListWithCapacity((int)(objects.length / 5));
        for (int i = 0; i < objects.length; i += 5) {
            retVal.add(new BySegmentResultValueClass((List)Lists.newArrayList((Object[])new TimeseriesResultValue[]{new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)objects[i + 1], (Object)"imps", (Object)objects[i + 2], (Object)"impers", (Object)objects[i + 2], (Object)"avg_imps_per_row", (Object)(((Number)objects[i + 2]).doubleValue() / ((Number)objects[i + 1]).doubleValue())))}), (String)objects[i + 3], (Interval)objects[i + 4]));
        }
        return retVal;
    }

    private Iterable<Result<TimeseriesResultValue>> makeRenamedTimeResults(Object ... objects) {
        if (objects.length % 3 != 0) {
            throw new ISE("makeTimeResults must be passed arguments in groups of 3, got[%d]", new Object[]{objects.length});
        }
        ArrayList retVal = Lists.newArrayListWithCapacity((int)(objects.length / 3));
        for (int i = 0; i < objects.length; i += 3) {
            retVal.add(new Result((DateTime)objects[i], (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)objects[i + 1], (Object)"imps", (Object)objects[i + 2], (Object)"impers2", (Object)objects[i + 2]))));
        }
        return retVal;
    }

    private Iterable<Result<TopNResultValue>> makeTopNResultsWithoutRename(Object ... objects) {
        return this.makeTopNResults(Lists.newArrayList((Object[])new String[]{TOP_DIM, "rows", "imps", "impers", "avg_imps_per_row", "avg_imps_per_row_double", "avg_imps_per_row_half"}), objects);
    }

    private Iterable<Result<TopNResultValue>> makeTopNResults(List<String> names, Object ... objects) {
        Preconditions.checkArgument((names.size() == 7 ? 1 : 0) != 0);
        ArrayList retVal = Lists.newArrayList();
        int index = 0;
        while (index < objects.length) {
            DateTime timestamp = (DateTime)objects[index++];
            ArrayList values = Lists.newArrayList();
            while (index < objects.length && !(objects[index] instanceof DateTime)) {
                if (objects.length - index < 3) {
                    throw new ISE("expect 3 values for each entry in the top list, had %d values left.", new Object[]{objects.length - index});
                }
                double imps = ((Number)objects[index + 2]).doubleValue();
                double rows = ((Number)objects[index + 1]).doubleValue();
                values.add(ImmutableMap.builder().put((Object)names.get(0), objects[index]).put((Object)names.get(1), (Object)rows).put((Object)names.get(2), (Object)imps).put((Object)names.get(3), (Object)imps).put((Object)names.get(4), (Object)(imps / rows)).put((Object)names.get(5), (Object)(imps * 2.0 / rows)).put((Object)names.get(6), (Object)(imps / (rows * 2.0))).build());
                index += 3;
            }
            retVal.add(new Result(timestamp, (Object)new TopNResultValue((List)values)));
        }
        return retVal;
    }

    private Iterable<Result<TopNResultValue>> makeRenamedTopNResults(Object ... objects) {
        return this.makeTopNResults(Lists.newArrayList((Object[])new String[]{TOP_DIM, "rows", "imps", "impers2", "avg_imps_per_row", "avg_imps_per_row_double", "avg_imps_per_row_half"}), objects);
    }

    private Iterable<Result<SearchResultValue>> makeSearchResults(String dim, Object ... objects) {
        ArrayList retVal = Lists.newArrayList();
        int index = 0;
        while (index < objects.length) {
            DateTime timestamp = (DateTime)objects[index++];
            ArrayList values = Lists.newArrayList();
            while (index < objects.length && !(objects[index] instanceof DateTime)) {
                values.add(new SearchHit(dim, objects[index++].toString(), (Integer)objects[index++]));
            }
            retVal.add(new Result(timestamp, (Object)new SearchResultValue((List)values)));
        }
        return retVal;
    }

    private Iterable<Result<SelectResultValue>> makeSelectResults(Set<String> dimensions, Set<String> metrics, Object ... objects) {
        ArrayList retVal = Lists.newArrayList();
        int index = 0;
        while (index < objects.length) {
            DateTime timestamp = (DateTime)objects[index++];
            ArrayList values = Lists.newArrayList();
            while (index < objects.length && !(objects[index] instanceof DateTime)) {
                values.add(new EventHolder(null, 0, (Map)objects[index++]));
            }
            retVal.add(new Result(timestamp, (Object)new SelectResultValue((Map)ImmutableMap.of((Object)timestamp.toString(), (Object)0), dimensions, metrics, (List)values)));
        }
        return retVal;
    }

    private Iterable<Row> makeGroupByResults(Object ... objects) {
        ArrayList retVal = Lists.newArrayList();
        int index = 0;
        while (index < objects.length) {
            DateTime timestamp = (DateTime)objects[index++];
            retVal.add(new MapBasedRow(timestamp, (Map)objects[index++]));
        }
        return retVal;
    }

    private <T> T makeMock(List<Object> mocks, Class<T> clazz) {
        Object obj = EasyMock.createMock(clazz);
        mocks.add(obj);
        return (T)obj;
    }

    private void runWithMocks(Runnable toRun, Object ... mocks) {
        EasyMock.replay((Object[])mocks);
        toRun.run();
        EasyMock.verify((Object[])mocks);
        EasyMock.reset((Object[])mocks);
    }

    protected CachingClusteredClient makeClient(ListeningExecutorService backgroundExecutorService) {
        return this.makeClient(backgroundExecutorService, this.cache, 10);
    }

    protected CachingClusteredClient makeClient(ListeningExecutorService backgroundExecutorService, Cache cache, final int mergeLimit) {
        return new CachingClusteredClient(WAREHOUSE, new TimelineServerView(){

            public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
            }

            public VersionedIntervalTimeline<String, ServerSelector> getTimeline(DataSource dataSource) {
                return CachingClusteredClientTest.this.timeline;
            }

            public <T> QueryRunner<T> getQueryRunner(DruidServer server) {
                return CachingClusteredClientTest.this.serverView.getQueryRunner(server);
            }

            public void registerTimelineCallback(Executor exec, TimelineServerView.TimelineCallback callback) {
                throw new UnsupportedOperationException();
            }

            public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
            }
        }, cache, (ObjectMapper)jsonMapper, (ExecutorService)backgroundExecutorService, new CacheConfig(){

            public boolean isPopulateCache() {
                return true;
            }

            public boolean isUseCache() {
                return true;
            }

            public boolean isQueryCacheable(Query query) {
                return true;
            }

            public int getCacheBulkMergeLimit() {
                return mergeLimit;
            }
        });
    }

    @Test
    public void testTimeBoundaryCachingWhenTimeIsInteger() throws Exception {
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).build(), Intervals.of((String)"1970-01-01/1970-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-01"), DateTimes.of((String)"1970-01-01"), DateTimes.of((String)"1970-01-02")), Intervals.of((String)"1970-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-02"), DateTimes.of((String)"1970-01-02"), DateTimes.of((String)"1970-01-03")), Intervals.of((String)"1970-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-05"), DateTimes.of((String)"1970-01-05"), DateTimes.of((String)"1970-01-10")), Intervals.of((String)"1970-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-05T01"), DateTimes.of((String)"1970-01-05T01"), DateTimes.of((String)"1970-01-10")));
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).bound("maxTime").build(), Intervals.of((String)"1970-01-01/2011-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-01"), null, DateTimes.of((String)"1970-01-02")), Intervals.of((String)"1970-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-02"), null, DateTimes.of((String)"1970-01-03")), Intervals.of((String)"1970-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-05"), null, DateTimes.of((String)"1970-01-10")), Intervals.of((String)"1970-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-05T01"), null, DateTimes.of((String)"1970-01-10")));
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).bound("minTime").build(), Intervals.of((String)"1970-01-01/2011-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-01"), DateTimes.of((String)"1970-01-01"), null), Intervals.of((String)"1970-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-02"), DateTimes.of((String)"1970-01-02"), null), Intervals.of((String)"1970-01-01/1970-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-05"), DateTimes.of((String)"1970-01-05"), null), Intervals.of((String)"1970-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-05T01"), DateTimes.of((String)"1970-01-05T01"), null));
    }

    @Test
    public void testGroupByCachingRenamedAggs() throws Exception {
        GroupByQuery.Builder builder = new GroupByQuery.Builder().setDataSource(DATA_SOURCE).setQuerySegmentSpec((QuerySegmentSpec)SEG_SPEC).setDimFilter(DIM_FILTER).setGranularity(GRANULARITY).setDimensions(Arrays.asList(new DefaultDimensionSpec("a", "output"))).setAggregatorSpecs(AGGS).setContext(CONTEXT);
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)builder.build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeGroupByResults(DateTimes.of((String)"2011-01-01"), ImmutableMap.of((Object)"output", (Object)"a", (Object)"rows", (Object)1, (Object)"imps", (Object)1, (Object)"impers", (Object)1)), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeGroupByResults(DateTimes.of((String)"2011-01-02"), ImmutableMap.of((Object)"output", (Object)"b", (Object)"rows", (Object)2, (Object)"imps", (Object)2, (Object)"impers", (Object)2)), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeGroupByResults(DateTimes.of((String)"2011-01-05"), ImmutableMap.of((Object)"output", (Object)"c", (Object)"rows", (Object)3, (Object)"imps", (Object)3, (Object)"impers", (Object)3), DateTimes.of((String)"2011-01-06"), ImmutableMap.of((Object)"output", (Object)"d", (Object)"rows", (Object)4, (Object)"imps", (Object)4, (Object)"impers", (Object)4), DateTimes.of((String)"2011-01-07"), ImmutableMap.of((Object)"output", (Object)"e", (Object)"rows", (Object)5, (Object)"imps", (Object)5, (Object)"impers", (Object)5), DateTimes.of((String)"2011-01-08"), ImmutableMap.of((Object)"output", (Object)"f", (Object)"rows", (Object)6, (Object)"imps", (Object)6, (Object)"impers", (Object)6), DateTimes.of((String)"2011-01-09"), ImmutableMap.of((Object)"output", (Object)"g", (Object)"rows", (Object)7, (Object)"imps", (Object)7, (Object)"impers", (Object)7)), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeGroupByResults(DateTimes.of((String)"2011-01-05T01"), ImmutableMap.of((Object)"output", (Object)"c", (Object)"rows", (Object)3, (Object)"imps", (Object)3, (Object)"impers", (Object)3), DateTimes.of((String)"2011-01-06T01"), ImmutableMap.of((Object)"output", (Object)"d", (Object)"rows", (Object)4, (Object)"imps", (Object)4, (Object)"impers", (Object)4), DateTimes.of((String)"2011-01-07T01"), ImmutableMap.of((Object)"output", (Object)"e", (Object)"rows", (Object)5, (Object)"imps", (Object)5, (Object)"impers", (Object)5), DateTimes.of((String)"2011-01-08T01"), ImmutableMap.of((Object)"output", (Object)"f", (Object)"rows", (Object)6, (Object)"imps", (Object)6, (Object)"impers", (Object)6), DateTimes.of((String)"2011-01-09T01"), ImmutableMap.of((Object)"output", (Object)"g", (Object)"rows", (Object)7, (Object)"imps", (Object)7, (Object)"impers", (Object)7)));
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), GroupByQueryRunnerTest.makeQueryRunnerFactory(new GroupByQueryConfig()).getToolchest());
        HashMap context = new HashMap();
        TestHelper.assertExpectedObjects(this.makeGroupByResults(DateTimes.of((String)"2011-01-05T"), ImmutableMap.of((Object)"output", (Object)"c", (Object)"rows", (Object)3, (Object)"imps", (Object)3, (Object)"impers", (Object)3), DateTimes.of((String)"2011-01-05T01"), ImmutableMap.of((Object)"output", (Object)"c", (Object)"rows", (Object)3, (Object)"imps", (Object)3, (Object)"impers", (Object)3), DateTimes.of((String)"2011-01-06T"), ImmutableMap.of((Object)"output", (Object)"d", (Object)"rows", (Object)4, (Object)"imps", (Object)4, (Object)"impers", (Object)4), DateTimes.of((String)"2011-01-06T01"), ImmutableMap.of((Object)"output", (Object)"d", (Object)"rows", (Object)4, (Object)"imps", (Object)4, (Object)"impers", (Object)4), DateTimes.of((String)"2011-01-07T"), ImmutableMap.of((Object)"output", (Object)"e", (Object)"rows", (Object)5, (Object)"imps", (Object)5, (Object)"impers", (Object)5), DateTimes.of((String)"2011-01-07T01"), ImmutableMap.of((Object)"output", (Object)"e", (Object)"rows", (Object)5, (Object)"imps", (Object)5, (Object)"impers", (Object)5), DateTimes.of((String)"2011-01-08T"), ImmutableMap.of((Object)"output", (Object)"f", (Object)"rows", (Object)6, (Object)"imps", (Object)6, (Object)"impers", (Object)6), DateTimes.of((String)"2011-01-08T01"), ImmutableMap.of((Object)"output", (Object)"f", (Object)"rows", (Object)6, (Object)"imps", (Object)6, (Object)"impers", (Object)6), DateTimes.of((String)"2011-01-09T"), ImmutableMap.of((Object)"output", (Object)"g", (Object)"rows", (Object)7, (Object)"imps", (Object)7, (Object)"impers", (Object)7), DateTimes.of((String)"2011-01-09T01"), ImmutableMap.of((Object)"output", (Object)"g", (Object)"rows", (Object)7, (Object)"imps", (Object)7, (Object)"impers", (Object)7)), runner.run(QueryPlus.wrap((Query)builder.setInterval("2011-01-05/2011-01-10").build()), context), "");
        GroupByQuery query = builder.setInterval("2011-01-05/2011-01-10").setDimensions(Collections.singletonList(new DefaultDimensionSpec("a", "output2"))).setAggregatorSpecs(RENAMED_AGGS).build();
        TestHelper.assertExpectedObjects(this.makeGroupByResults(DateTimes.of((String)"2011-01-05T"), ImmutableMap.of((Object)"output2", (Object)"c", (Object)"rows", (Object)3, (Object)"imps", (Object)3, (Object)"impers2", (Object)3), DateTimes.of((String)"2011-01-05T01"), ImmutableMap.of((Object)"output2", (Object)"c", (Object)"rows", (Object)3, (Object)"imps", (Object)3, (Object)"impers2", (Object)3), DateTimes.of((String)"2011-01-06T"), ImmutableMap.of((Object)"output2", (Object)"d", (Object)"rows", (Object)4, (Object)"imps", (Object)4, (Object)"impers2", (Object)4), DateTimes.of((String)"2011-01-06T01"), ImmutableMap.of((Object)"output2", (Object)"d", (Object)"rows", (Object)4, (Object)"imps", (Object)4, (Object)"impers2", (Object)4), DateTimes.of((String)"2011-01-07T"), ImmutableMap.of((Object)"output2", (Object)"e", (Object)"rows", (Object)5, (Object)"imps", (Object)5, (Object)"impers2", (Object)5), DateTimes.of((String)"2011-01-07T01"), ImmutableMap.of((Object)"output2", (Object)"e", (Object)"rows", (Object)5, (Object)"imps", (Object)5, (Object)"impers2", (Object)5), DateTimes.of((String)"2011-01-08T"), ImmutableMap.of((Object)"output2", (Object)"f", (Object)"rows", (Object)6, (Object)"imps", (Object)6, (Object)"impers2", (Object)6), DateTimes.of((String)"2011-01-08T01"), ImmutableMap.of((Object)"output2", (Object)"f", (Object)"rows", (Object)6, (Object)"imps", (Object)6, (Object)"impers2", (Object)6), DateTimes.of((String)"2011-01-09T"), ImmutableMap.of((Object)"output2", (Object)"g", (Object)"rows", (Object)7, (Object)"imps", (Object)7, (Object)"impers2", (Object)7), DateTimes.of((String)"2011-01-09T01"), ImmutableMap.of((Object)"output2", (Object)"g", (Object)"rows", (Object)7, (Object)"imps", (Object)7, (Object)"impers2", (Object)7)), runner.run(QueryPlus.wrap((Query)query), context), "renamed aggregators test");
    }

    @Test
    public void testIfNoneMatch() throws Exception {
        Interval interval = Intervals.of((String)"2016/2017");
        DataSegment dataSegment = new DataSegment("dataSource", interval, "ver", (Map)ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)"/tmp"), (List)ImmutableList.of((Object)"product"), (List)ImmutableList.of((Object)"visited_sum"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 12334L);
        ServerSelector selector = new ServerSelector(dataSegment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
        selector.addServerAndUpdateSegment(new QueryableDruidServer(this.servers[0], null), dataSegment);
        this.timeline.add(interval, (Object)"ver", (PartitionChunk)new SingleElementPartitionChunk((Object)selector));
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)interval))).context((Map)ImmutableMap.of((Object)"If-None-Match", (Object)"aVJV29CJY93rszVW/QBy0arWZo0=")).build();
        HashMap responseContext = new HashMap();
        this.getDefaultQueryRunner().run(QueryPlus.wrap((Query)query), responseContext);
        Assert.assertEquals((Object)"Z/eS4rQz5v477iq7Aashr6JPZa0=", responseContext.get("ETag"));
    }

    private QueryRunner getDefaultQueryRunner() {
        return new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, Map responseContext) {
                return CachingClusteredClientTest.this.client.getQueryRunnerForIntervals(queryPlus.getQuery(), (Iterable)queryPlus.getQuery().getIntervals()).run(queryPlus, responseContext);
            }
        };
    }

    static {
        jsonMapper.getFactory().setCodec((ObjectCodec)jsonMapper);
        AGGS = Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("imps", "imps"), new LongSumAggregatorFactory("impers", "imps"));
        POST_AGGS = Arrays.asList(new ArithmeticPostAggregator("avg_imps_per_row", "/", Arrays.asList(new FieldAccessPostAggregator("imps", "imps"), new FieldAccessPostAggregator("rows", "rows"))), new ArithmeticPostAggregator("avg_imps_per_row_double", "*", Arrays.asList(new FieldAccessPostAggregator("avg_imps_per_row", "avg_imps_per_row"), new ConstantPostAggregator("constant", (Number)2))), new ArithmeticPostAggregator("avg_imps_per_row_half", "/", Arrays.asList(new FieldAccessPostAggregator("avg_imps_per_row", "avg_imps_per_row"), new ConstantPostAggregator("constant", (Number)2))));
        RENAMED_AGGS = Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("imps", "imps"), new LongSumAggregatorFactory("impers2", "imps"));
        DIFF_ORDER_POST_AGGS = Arrays.asList(new ArithmeticPostAggregator("avg_imps_per_row", "/", Arrays.asList(new FieldAccessPostAggregator("imps", "imps"), new FieldAccessPostAggregator("rows", "rows"))), new ArithmeticPostAggregator("avg_imps_per_row_half", "/", Arrays.asList(new FieldAccessPostAggregator("avg_imps_per_row", "avg_imps_per_row"), new ConstantPostAggregator("constant", (Number)2))), new ArithmeticPostAggregator("avg_imps_per_row_double", "*", Arrays.asList(new FieldAccessPostAggregator("avg_imps_per_row", "avg_imps_per_row"), new ConstantPostAggregator("constant", (Number)2))));
        DIM_FILTER = null;
        RENAMED_POST_AGGS = ImmutableList.of();
        GRANULARITY = Granularities.DAY;
        TIMEZONE = DateTimeZone.forID((String)"America/Los_Angeles");
        PT1H_TZ_GRANULARITY = new PeriodGranularity(new Period((Object)"PT1H"), null, TIMEZONE);
        selectConfigSupplier = Suppliers.ofInstance((Object)new SelectQueryConfig(Boolean.valueOf(true)));
        WAREHOUSE = new MapQueryToolChestWarehouse((Map)ImmutableMap.builder().put(TimeseriesQuery.class, (Object)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator())).put(TopNQuery.class, (Object)new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator())).put(SearchQuery.class, (Object)new SearchQueryQueryToolChest(new SearchQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator())).put(SelectQuery.class, (Object)new SelectQueryQueryToolChest((ObjectMapper)jsonMapper, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator(), selectConfigSupplier)).put(GroupByQuery.class, (Object)GroupByQueryRunnerTest.makeQueryRunnerFactory(new GroupByQueryConfig()).getToolchest()).put(TimeBoundaryQuery.class, (Object)new TimeBoundaryQueryQueryToolChest()).build());
    }

    private static class ServerExpectations
    implements Iterable<ServerExpectation> {
        private final DruidServer server;
        private final QueryRunner queryRunner;
        private final List<ServerExpectation> expectations = Lists.newArrayList();

        public ServerExpectations(DruidServer server, QueryRunner queryRunner) {
            this.server = server;
            this.queryRunner = queryRunner;
        }

        public DruidServer getServer() {
            return this.server;
        }

        public QueryRunner getQueryRunner() {
            return this.queryRunner;
        }

        public List<ServerExpectation> getExpectations() {
            return this.expectations;
        }

        public void addExpectation(ServerExpectation expectation) {
            this.expectations.add(expectation);
        }

        @Override
        public Iterator<ServerExpectation> iterator() {
            return this.expectations.iterator();
        }
    }

    private static class ServerExpectation<T> {
        private final String segmentId;
        private final Interval interval;
        private final DataSegment segment;
        private final Iterable<Result<T>> results;

        public ServerExpectation(String segmentId, Interval interval, DataSegment segment, Iterable<Result<T>> results) {
            this.segmentId = segmentId;
            this.interval = interval;
            this.segment = segment;
            this.results = results;
        }

        public String getSegmentId() {
            return this.segmentId;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public DataSegment getSegment() {
            return new MyDataSegment();
        }

        public Iterable<Result<T>> getResults() {
            return this.results;
        }

        private class MyDataSegment
        extends DataSegment {
            private final DataSegment baseSegment;

            private MyDataSegment() {
                super("", Intervals.utc((long)0L, (long)1L), "", null, null, null, (ShardSpec)NoneShardSpec.instance(), null, -1L);
                this.baseSegment = ServerExpectation.this.segment;
            }

            @JsonProperty
            public String getDataSource() {
                return this.baseSegment.getDataSource();
            }

            @JsonProperty
            public Interval getInterval() {
                return this.baseSegment.getInterval();
            }

            @JsonProperty
            public Map<String, Object> getLoadSpec() {
                return this.baseSegment.getLoadSpec();
            }

            @JsonProperty
            public String getVersion() {
                return this.baseSegment.getVersion();
            }

            @JsonSerialize
            @JsonProperty
            public List<String> getDimensions() {
                return this.baseSegment.getDimensions();
            }

            @JsonSerialize
            @JsonProperty
            public List<String> getMetrics() {
                return this.baseSegment.getMetrics();
            }

            @JsonProperty
            public ShardSpec getShardSpec() {
                try {
                    return this.baseSegment.getShardSpec();
                }
                catch (IllegalStateException e) {
                    return NoneShardSpec.instance();
                }
            }

            @JsonProperty
            public long getSize() {
                return this.baseSegment.getSize();
            }

            public String getIdentifier() {
                return ServerExpectation.this.segmentId;
            }

            public SegmentDescriptor toDescriptor() {
                return this.baseSegment.toDescriptor();
            }

            public int compareTo(DataSegment dataSegment) {
                return this.baseSegment.compareTo(dataSegment);
            }

            public boolean equals(Object o) {
                return this.baseSegment.equals(o);
            }

            public int hashCode() {
                return this.baseSegment.hashCode();
            }

            public String toString() {
                return this.baseSegment.toString();
            }
        }
    }
}

