/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.guava;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.metamx.common.guava.MergeSequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.SequenceTestHelper;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.common.guava.TestSequence;
import org.junit.Test;

public class MergeSequenceTest {
    @Test
    public void testSanity() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(2, 8), TestSequence.create(4, 6, 8)});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testWorksWhenBeginningOutOfOrder() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(2, 8), TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(4, 6, 8)});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testMergeEmpties() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(new Integer[0]), TestSequence.create(2, 8), TestSequence.create(4, 6, 8)});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testMergeEmpties1() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(new Integer[0]), TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(2, 8), TestSequence.create(4, 6, 8)});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testMergeEmpties2() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(2, 8), TestSequence.create(new Integer[0]), TestSequence.create(4, 6, 8), TestSequence.create(new Integer[0])});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testScrewsUpOnOutOfOrder() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1, 3, 5, 4, 7, 9), TestSequence.create(2, 8), TestSequence.create(4, 6)});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 4, 6, 7, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testHierarchicalMerge() throws Exception {
        MergeSequence seq1 = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)Lists.newArrayList((Object[])new Sequence[]{TestSequence.create(1)})));
        MergeSequence finalMerged = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)Lists.newArrayList((Object[])new Sequence[]{seq1})));
        SequenceTestHelper.testAll((Sequence<Integer>)finalMerged, Arrays.asList(1));
    }

    @Test
    public void testMergeOne() throws Exception {
        MergeSequence mergeOne = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)Lists.newArrayList((Object[])new Sequence[]{TestSequence.create(1)})));
        SequenceTestHelper.testAll((Sequence<Integer>)mergeOne, Arrays.asList(1));
    }
}

