/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.guava;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.metamx.common.guava.ExecutorExecutingSequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.SequenceTestHelper;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.junit.Test;

public class ExecutorExecutingSequenceTest {
    @Test
    public void testSanity() throws Exception {
        TestExecutor exec = new TestExecutor();
        List<Integer> vals = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13);
        ExecutorExecutingSequence seq = new ExecutorExecutingSequence(Sequences.simple(vals), (ExecutorService)exec);
        SequenceTestHelper.testAccumulation("", (Sequence<Integer>)seq, vals);
        Assert.assertEquals((int)1, (int)exec.getTimesCalled());
        exec.reset();
        SequenceTestHelper.testYield("", 3, (Sequence<Integer>)seq, vals);
        Assert.assertEquals((int)5, (int)exec.getTimesCalled());
    }

    @Test
    public void testSanity2() throws Exception {
        TestExecutor exec = new TestExecutor();
        List<Integer> vals = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
        ExecutorExecutingSequence seq = new ExecutorExecutingSequence(Sequences.simple(vals), (ExecutorService)exec);
        SequenceTestHelper.testAccumulation("", (Sequence<Integer>)seq, vals);
        Assert.assertEquals((int)1, (int)exec.getTimesCalled());
        exec.reset();
        SequenceTestHelper.testYield("", 3, (Sequence<Integer>)seq, vals);
        Assert.assertEquals((int)6, (int)exec.getTimesCalled());
    }

    public static class TestExecutor
    implements ExecutorService {
        int timesCalled = 0;

        public int getTimesCalled() {
            return this.timesCalled;
        }

        public void reset() {
            this.timesCalled = 0;
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTerminated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            ++this.timesCalled;
            try {
                return Futures.immediateCheckedFuture(task.call());
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<?> submit(Runnable task) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable command) {
            throw new UnsupportedOperationException();
        }
    }
}

