/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.TestKeyedObjectPool;
import org.apache.commons.pool2.VisitTracker;
import org.apache.commons.pool2.VisitTrackerFactory;
import org.apache.commons.pool2.Waiter;
import org.apache.commons.pool2.WaiterFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGenericKeyedObjectPool
extends TestKeyedObjectPool {
    private GenericKeyedObjectPool<String, String> pool = null;
    private SimpleFactory<String> factory = null;
    private static final Integer KEY_ZERO = 0;
    private static final Integer KEY_ONE = 1;
    private static final Integer KEY_TWO = 2;
    private static final boolean DISPLAY_THREAD_DETAILS = Boolean.valueOf(System.getProperty("TestGenericKeyedObjectPool.display.thread.details", "false"));

    @Override
    protected KeyedObjectPool<Object, Object> makeEmptyPool(int mincapacity) {
        SimplePerKeyFactory perKeyFactory = new SimplePerKeyFactory();
        GenericKeyedObjectPool perKeyPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)perKeyFactory);
        perKeyPool.setMaxTotalPerKey(mincapacity);
        perKeyPool.setMaxIdlePerKey(mincapacity);
        return perKeyPool;
    }

    @Override
    protected KeyedObjectPool<Object, Object> makeEmptyPool(KeyedPooledObjectFactory<Object, Object> fac) {
        return new GenericKeyedObjectPool(fac);
    }

    @Override
    protected Object getNthObject(Object key, int n) {
        return String.valueOf(key) + String.valueOf(n);
    }

    @Override
    protected Object makeKey(int n) {
        return String.valueOf(n);
    }

    @Before
    public void setUp() throws Exception {
        this.factory = new SimpleFactory();
        this.pool = new GenericKeyedObjectPool(this.factory);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        String poolName = this.pool.getJmxName().toString();
        this.pool.clear();
        this.pool.close();
        this.pool = null;
        this.factory = null;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(new ObjectName("org.apache.commoms.pool2:type=GenericKeyedObjectPool,*"), null);
        int registeredPoolCount = result.size();
        StringBuilder msg = new StringBuilder("Current pool is: ");
        msg.append(poolName);
        msg.append("  Still open pools are: ");
        for (ObjectName name : result) {
            msg.append(name.toString());
            msg.append(" created via\n");
            msg.append(mbs.getAttribute(name, "CreationStackTrace"));
            msg.append('\n');
            mbs.unregisterMBean(name);
        }
        Assert.assertEquals((String)msg.toString(), (long)0L, (long)registeredPoolCount);
    }

    @Test(timeout=60000L)
    public void testNegativeMaxTotalPerKey() throws Exception {
        this.pool.setMaxTotalPerKey(-1);
        this.pool.setBlockWhenExhausted(false);
        String obj = (String)this.pool.borrowObject((Object)"");
        Assert.assertEquals((Object)"0", (Object)obj);
        this.pool.returnObject((Object)"", (Object)obj);
    }

    @Test(timeout=60000L)
    public void testNumActiveNumIdle2() throws Exception {
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive((Object)"A"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"A"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive((Object)"B"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"B"));
        String objA0 = (String)this.pool.borrowObject((Object)"A");
        String objB0 = (String)this.pool.borrowObject((Object)"B");
        Assert.assertEquals((long)2L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive((Object)"A"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"A"));
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive((Object)"B"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"B"));
        String objA1 = (String)this.pool.borrowObject((Object)"A");
        String objB1 = (String)this.pool.borrowObject((Object)"B");
        Assert.assertEquals((long)4L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        Assert.assertEquals((long)2L, (long)this.pool.getNumActive((Object)"A"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"A"));
        Assert.assertEquals((long)2L, (long)this.pool.getNumActive((Object)"B"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"B"));
        this.pool.returnObject((Object)"A", (Object)objA0);
        this.pool.returnObject((Object)"B", (Object)objB0);
        Assert.assertEquals((long)2L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)2L, (long)this.pool.getNumIdle());
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive((Object)"A"));
        Assert.assertEquals((long)1L, (long)this.pool.getNumIdle((Object)"A"));
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive((Object)"B"));
        Assert.assertEquals((long)1L, (long)this.pool.getNumIdle((Object)"B"));
        this.pool.returnObject((Object)"A", (Object)objA1);
        this.pool.returnObject((Object)"B", (Object)objB1);
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)4L, (long)this.pool.getNumIdle());
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive((Object)"A"));
        Assert.assertEquals((long)2L, (long)this.pool.getNumIdle((Object)"A"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive((Object)"B"));
        Assert.assertEquals((long)2L, (long)this.pool.getNumIdle((Object)"B"));
    }

    @Test(timeout=60000L)
    public void testMaxIdle() throws Exception {
        int i;
        this.pool.setMaxTotalPerKey(100);
        this.pool.setMaxIdlePerKey(8);
        String[] active = new String[100];
        for (i = 0; i < 100; ++i) {
            active[i] = (String)this.pool.borrowObject((Object)"");
        }
        Assert.assertEquals((long)100L, (long)this.pool.getNumActive((Object)""));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)""));
        for (i = 0; i < 100; ++i) {
            this.pool.returnObject((Object)"", (Object)active[i]);
            Assert.assertEquals((long)(99 - i), (long)this.pool.getNumActive((Object)""));
            Assert.assertEquals((long)(i < 8 ? i + 1 : 8), (long)this.pool.getNumIdle((Object)""));
        }
        for (i = 0; i < 100; ++i) {
            active[i] = (String)this.pool.borrowObject((Object)"a");
        }
        Assert.assertEquals((long)100L, (long)this.pool.getNumActive((Object)"a"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"a"));
        for (i = 0; i < 100; ++i) {
            this.pool.returnObject((Object)"a", (Object)active[i]);
            Assert.assertEquals((long)(99 - i), (long)this.pool.getNumActive((Object)"a"));
            Assert.assertEquals((long)(i < 8 ? i + 1 : 8), (long)this.pool.getNumIdle((Object)"a"));
        }
        Assert.assertEquals((long)16L, (long)this.pool.getNumIdle());
        Assert.assertEquals((long)8L, (long)this.pool.getNumIdle((Object)""));
        Assert.assertEquals((long)8L, (long)this.pool.getNumIdle((Object)"a"));
    }

    @Test(timeout=60000L)
    public void testMaxTotalPerKey() throws Exception {
        this.pool.setMaxTotalPerKey(3);
        this.pool.setBlockWhenExhausted(false);
        this.pool.borrowObject((Object)"");
        this.pool.borrowObject((Object)"");
        this.pool.borrowObject((Object)"");
        try {
            this.pool.borrowObject((Object)"");
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testMaxTotalPerKeyZero() throws Exception {
        this.pool.setMaxTotalPerKey(0);
        this.pool.setBlockWhenExhausted(false);
        try {
            this.pool.borrowObject((Object)"a");
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testMaxTotal() throws Exception {
        this.pool.setMaxTotalPerKey(2);
        this.pool.setMaxTotal(3);
        this.pool.setBlockWhenExhausted(false);
        String o1 = (String)this.pool.borrowObject((Object)"a");
        Assert.assertNotNull((Object)o1);
        String o2 = (String)this.pool.borrowObject((Object)"a");
        Assert.assertNotNull((Object)o2);
        String o3 = (String)this.pool.borrowObject((Object)"b");
        Assert.assertNotNull((Object)o3);
        try {
            this.pool.borrowObject((Object)"c");
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        this.pool.returnObject((Object)"b", (Object)o3);
        Assert.assertEquals((long)1L, (long)this.pool.getNumIdle());
        Assert.assertEquals((long)1L, (long)this.pool.getNumIdle((Object)"b"));
        Object o4 = this.pool.borrowObject((Object)"b");
        Assert.assertNotNull((Object)o4);
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"b"));
        this.pool.setMaxTotal(4);
        Object o5 = this.pool.borrowObject((Object)"b");
        Assert.assertNotNull((Object)o5);
        Assert.assertEquals((long)2L, (long)this.pool.getNumActive((Object)"a"));
        Assert.assertEquals((long)2L, (long)this.pool.getNumActive((Object)"b"));
        Assert.assertEquals((long)this.pool.getMaxTotal(), (long)(this.pool.getNumActive((Object)"b") + this.pool.getNumActive((Object)"b")));
        Assert.assertEquals((long)this.pool.getNumActive(), (long)this.pool.getMaxTotal());
    }

    @Test(timeout=60000L)
    public void testMaxTotalZero() throws Exception {
        this.pool.setMaxTotal(0);
        this.pool.setBlockWhenExhausted(false);
        try {
            this.pool.borrowObject((Object)"a");
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testMaxTotalLRU() throws Exception {
        this.pool.setMaxTotalPerKey(2);
        this.pool.setMaxTotal(3);
        String o1 = (String)this.pool.borrowObject((Object)"a");
        Assert.assertNotNull((Object)o1);
        this.pool.returnObject((Object)"a", (Object)o1);
        Thread.sleep(25L);
        String o2 = (String)this.pool.borrowObject((Object)"b");
        Assert.assertNotNull((Object)o2);
        this.pool.returnObject((Object)"b", (Object)o2);
        Thread.sleep(25L);
        String o3 = (String)this.pool.borrowObject((Object)"c");
        Assert.assertNotNull((Object)o3);
        this.pool.returnObject((Object)"c", (Object)o3);
        Thread.sleep(25L);
        String o4 = (String)this.pool.borrowObject((Object)"a");
        Assert.assertNotNull((Object)o4);
        this.pool.returnObject((Object)"a", (Object)o4);
        Thread.sleep(25L);
        Assert.assertSame((Object)o1, (Object)o4);
        String o5 = (String)this.pool.borrowObject((Object)"d");
        Assert.assertNotNull((Object)o5);
        this.pool.returnObject((Object)"d", (Object)o5);
        Thread.sleep(25L);
        String o6 = (String)this.pool.borrowObject((Object)"b");
        Assert.assertNotNull((Object)o6);
        this.pool.returnObject((Object)"b", (Object)o6);
        Assert.assertNotSame((Object)o1, (Object)o6);
        Assert.assertNotSame((Object)o2, (Object)o6);
        String o7 = (String)this.pool.borrowObject((Object)"a");
        Assert.assertNotNull((Object)o7);
        this.pool.returnObject((Object)"a", (Object)o7);
        Assert.assertSame((Object)o4, (Object)o7);
    }

    @Test(timeout=60000L)
    public void testSettersAndGetters() throws Exception {
        this.pool.setMaxTotalPerKey(123);
        Assert.assertEquals((long)123L, (long)this.pool.getMaxTotalPerKey());
        this.pool.setMaxIdlePerKey(12);
        Assert.assertEquals((long)12L, (long)this.pool.getMaxIdlePerKey());
        this.pool.setMaxWaitMillis(1234L);
        Assert.assertEquals((long)1234L, (long)this.pool.getMaxWaitMillis());
        this.pool.setMinEvictableIdleTimeMillis(12345L);
        Assert.assertEquals((long)12345L, (long)this.pool.getMinEvictableIdleTimeMillis());
        this.pool.setNumTestsPerEvictionRun(11);
        Assert.assertEquals((long)11L, (long)this.pool.getNumTestsPerEvictionRun());
        this.pool.setTestOnBorrow(true);
        Assert.assertTrue((boolean)this.pool.getTestOnBorrow());
        this.pool.setTestOnBorrow(false);
        Assert.assertTrue((!this.pool.getTestOnBorrow() ? 1 : 0) != 0);
        this.pool.setTestOnReturn(true);
        Assert.assertTrue((boolean)this.pool.getTestOnReturn());
        this.pool.setTestOnReturn(false);
        Assert.assertTrue((!this.pool.getTestOnReturn() ? 1 : 0) != 0);
        this.pool.setTestWhileIdle(true);
        Assert.assertTrue((boolean)this.pool.getTestWhileIdle());
        this.pool.setTestWhileIdle(false);
        Assert.assertTrue((!this.pool.getTestWhileIdle() ? 1 : 0) != 0);
        this.pool.setTimeBetweenEvictionRunsMillis(11235L);
        Assert.assertEquals((long)11235L, (long)this.pool.getTimeBetweenEvictionRunsMillis());
        this.pool.setBlockWhenExhausted(true);
        Assert.assertTrue((boolean)this.pool.getBlockWhenExhausted());
        this.pool.setBlockWhenExhausted(false);
        Assert.assertFalse((boolean)this.pool.getBlockWhenExhausted());
    }

    @Test(timeout=60000L)
    public void testEviction() throws Exception {
        int i;
        int i2;
        this.pool.setMaxIdlePerKey(500);
        this.pool.setMaxTotalPerKey(500);
        this.pool.setNumTestsPerEvictionRun(100);
        this.pool.setMinEvictableIdleTimeMillis(250L);
        this.pool.setTimeBetweenEvictionRunsMillis(500L);
        String[] active = new String[500];
        for (i2 = 0; i2 < 500; ++i2) {
            active[i2] = (String)this.pool.borrowObject((Object)"");
        }
        for (i2 = 0; i2 < 500; ++i2) {
            this.pool.returnObject((Object)"", (Object)active[i2]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 500 idle, found " + this.pool.getNumIdle((Object)"")), (this.pool.getNumIdle((Object)"") < 500 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 400 idle, found " + this.pool.getNumIdle((Object)"")), (this.pool.getNumIdle((Object)"") < 400 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 300 idle, found " + this.pool.getNumIdle((Object)"")), (this.pool.getNumIdle((Object)"") < 300 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 200 idle, found " + this.pool.getNumIdle((Object)"")), (this.pool.getNumIdle((Object)"") < 200 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 100 idle, found " + this.pool.getNumIdle((Object)"")), (this.pool.getNumIdle((Object)"") < 100 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((String)("Should be zero idle, found " + this.pool.getNumIdle((Object)"")), (long)0L, (long)this.pool.getNumIdle((Object)""));
        for (i = 0; i < 500; ++i) {
            active[i] = (String)this.pool.borrowObject((Object)"");
        }
        for (i = 0; i < 500; ++i) {
            this.pool.returnObject((Object)"", (Object)active[i]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 500 idle, found " + this.pool.getNumIdle((Object)"")), (this.pool.getNumIdle((Object)"") < 500 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 400 idle, found " + this.pool.getNumIdle((Object)"")), (this.pool.getNumIdle((Object)"") < 400 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 300 idle, found " + this.pool.getNumIdle((Object)"")), (this.pool.getNumIdle((Object)"") < 300 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 200 idle, found " + this.pool.getNumIdle((Object)"")), (this.pool.getNumIdle((Object)"") < 200 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 100 idle, found " + this.pool.getNumIdle((Object)"")), (this.pool.getNumIdle((Object)"") < 100 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)("Should be zero idle, found " + this.pool.getNumIdle((Object)"")), (long)0L, (long)this.pool.getNumIdle((Object)""));
    }

    @Test(timeout=60000L)
    public void testEviction2() throws Exception {
        int i;
        this.pool.setMaxIdlePerKey(500);
        this.pool.setMaxTotalPerKey(500);
        this.pool.setNumTestsPerEvictionRun(100);
        this.pool.setMinEvictableIdleTimeMillis(500L);
        this.pool.setTimeBetweenEvictionRunsMillis(500L);
        String[] active = new String[500];
        String[] active2 = new String[500];
        for (i = 0; i < 500; ++i) {
            active[i] = (String)this.pool.borrowObject((Object)"");
            active2[i] = (String)this.pool.borrowObject((Object)"2");
        }
        for (i = 0; i < 500; ++i) {
            this.pool.returnObject((Object)"", (Object)active[i]);
            this.pool.returnObject((Object)"2", (Object)active2[i]);
        }
        try {
            Thread.sleep(1100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 1000 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 1000 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 900 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 900 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 800 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 800 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 700 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 700 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 600 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 600 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 500 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 500 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 400 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 400 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 300 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 300 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 200 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 200 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 100 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() < 100 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)("Should be zero idle, found " + this.pool.getNumIdle()), (long)0L, (long)this.pool.getNumIdle());
    }

    public <T> void runTestThreads(int numThreads, int iterations, int delay, GenericKeyedObjectPool<String, T> gkopPool) {
        ArrayList<TestThread> threads = new ArrayList<TestThread>();
        for (int i = 0; i < numThreads; ++i) {
            TestThread testThread = new TestThread(gkopPool, iterations, delay);
            threads.add(testThread);
            Thread t = new Thread(testThread);
            t.start();
        }
        for (TestThread testThread : threads) {
            while (!testThread.complete()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            if (!testThread.failed()) continue;
            Assert.fail((String)("Thread failed: " + threads.indexOf(testThread) + "\n" + this.getExceptionTrace(testThread._exception)));
        }
    }

    @Test(timeout=60000L)
    public void testThreaded1() throws Exception {
        this.pool.setMaxTotalPerKey(15);
        this.pool.setMaxIdlePerKey(15);
        this.pool.setMaxWaitMillis(1000L);
        this.runTestThreads(20, 100, 50, this.pool);
    }

    @Test(timeout=60000L)
    public void testMaxTotalInvariant() throws Exception {
        int maxTotal = 15;
        this.factory.setEvenValid(false);
        this.factory.setDestroyLatency(100L);
        this.factory.setMaxTotalPerKey(maxTotal);
        this.factory.setValidationEnabled(true);
        this.pool.setMaxTotal(maxTotal);
        this.pool.setMaxIdlePerKey(-1);
        this.pool.setTestOnReturn(true);
        this.pool.setMaxWaitMillis(10000L);
        this.runTestThreads(5, 10, 50, this.pool);
    }

    @Test(timeout=60000L)
    public void testMinIdle() throws Exception {
        this.pool.setMaxIdlePerKey(500);
        this.pool.setMinIdlePerKey(5);
        this.pool.setMaxTotalPerKey(10);
        this.pool.setNumTestsPerEvictionRun(0);
        this.pool.setMinEvictableIdleTimeMillis(50L);
        this.pool.setTimeBetweenEvictionRunsMillis(100L);
        this.pool.setTestWhileIdle(true);
        String key = "A";
        this.pool.preparePool((Object)key);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        String[] active = new String[5];
        active[0] = (String)this.pool.borrowObject((Object)key);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 1; i < 5; ++i) {
            active[i] = (String)this.pool.borrowObject((Object)key);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 0; i < 5; ++i) {
            this.pool.returnObject((Object)key, (Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 10 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 10 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testMinIdleMaxTotalPerKey() throws Exception {
        this.pool.setMaxIdlePerKey(500);
        this.pool.setMinIdlePerKey(5);
        this.pool.setMaxTotalPerKey(10);
        this.pool.setNumTestsPerEvictionRun(0);
        this.pool.setMinEvictableIdleTimeMillis(50L);
        this.pool.setTimeBetweenEvictionRunsMillis(100L);
        this.pool.setTestWhileIdle(true);
        String key = "A";
        this.pool.preparePool((Object)key);
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        String[] active = new String[10];
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 0; i < 5; ++i) {
            active[i] = (String)this.pool.borrowObject((Object)key);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 0; i < 5; ++i) {
            this.pool.returnObject((Object)key, (Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 10 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 10 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            active[i] = (String)this.pool.borrowObject((Object)key);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 0 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 0 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            this.pool.returnObject((Object)key, (Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 10 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 10 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testMinIdleNoPreparePool() throws Exception {
        this.pool.setMaxIdlePerKey(500);
        this.pool.setMinIdlePerKey(5);
        this.pool.setMaxTotalPerKey(10);
        this.pool.setNumTestsPerEvictionRun(0);
        this.pool.setMinEvictableIdleTimeMillis(50L);
        this.pool.setTimeBetweenEvictionRunsMillis(100L);
        this.pool.setTestWhileIdle(true);
        String key = "A";
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 0 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 0 ? 1 : 0) != 0);
        Object active = this.pool.borrowObject((Object)key);
        Assert.assertNotNull((Object)active);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.pool.getNumIdle()), (this.pool.getNumIdle() == 5 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testFIFO() throws Exception {
        this.pool.setLifo(false);
        String key = "key";
        this.pool.addObject((Object)"key");
        this.pool.addObject((Object)"key");
        this.pool.addObject((Object)"key");
        Assert.assertEquals((String)"Oldest", (Object)"key0", (Object)this.pool.borrowObject((Object)"key"));
        Assert.assertEquals((String)"Middle", (Object)"key1", (Object)this.pool.borrowObject((Object)"key"));
        Assert.assertEquals((String)"Youngest", (Object)"key2", (Object)this.pool.borrowObject((Object)"key"));
        String s = (String)this.pool.borrowObject((Object)"key");
        Assert.assertEquals((String)"new-3", (Object)"key3", (Object)s);
        this.pool.returnObject((Object)"key", (Object)s);
        Assert.assertEquals((String)"returned", (Object)s, (Object)this.pool.borrowObject((Object)"key"));
        Assert.assertEquals((String)"new-4", (Object)"key4", (Object)this.pool.borrowObject((Object)"key"));
    }

    @Test(timeout=60000L)
    public void testLIFO() throws Exception {
        this.pool.setLifo(true);
        String key = "key";
        this.pool.addObject((Object)"key");
        this.pool.addObject((Object)"key");
        this.pool.addObject((Object)"key");
        Assert.assertEquals((String)"Youngest", (Object)"key2", (Object)this.pool.borrowObject((Object)"key"));
        Assert.assertEquals((String)"Middle", (Object)"key1", (Object)this.pool.borrowObject((Object)"key"));
        Assert.assertEquals((String)"Oldest", (Object)"key0", (Object)this.pool.borrowObject((Object)"key"));
        String s = (String)this.pool.borrowObject((Object)"key");
        Assert.assertEquals((String)"new-3", (Object)"key3", (Object)s);
        this.pool.returnObject((Object)"key", (Object)s);
        Assert.assertEquals((String)"returned", (Object)s, (Object)this.pool.borrowObject((Object)"key"));
        Assert.assertEquals((String)"new-4", (Object)"key4", (Object)this.pool.borrowObject((Object)"key"));
    }

    @Test(timeout=60000L)
    public void testEvictionOrder() throws Exception {
        this.checkEvictionOrder(false);
        this.checkEvictionOrder(true);
    }

    private void checkEvictionOrder(boolean lifo) throws Exception {
        SimpleFactory intFactory = new SimpleFactory();
        GenericKeyedObjectPool intPool = new GenericKeyedObjectPool(intFactory);
        intPool.setNumTestsPerEvictionRun(2);
        intPool.setMinEvictableIdleTimeMillis(100L);
        intPool.setLifo(lifo);
        for (int i = 0; i < 3; ++i) {
            Integer key = i;
            for (int j = 0; j < 5; ++j) {
                intPool.addObject((Object)key);
            }
        }
        Thread.sleep(200L);
        intPool.evict();
        Assert.assertEquals((long)3L, (long)intPool.getNumIdle((Object)KEY_ZERO));
        String objZeroA = (String)intPool.borrowObject((Object)KEY_ZERO);
        Assert.assertTrue((boolean)(lifo ? objZeroA.equals("04") : objZeroA.equals("02")));
        Assert.assertEquals((long)2L, (long)intPool.getNumIdle((Object)KEY_ZERO));
        String objZeroB = (String)intPool.borrowObject((Object)KEY_ZERO);
        Assert.assertTrue((boolean)objZeroB.equals("03"));
        Assert.assertEquals((long)1L, (long)intPool.getNumIdle((Object)KEY_ZERO));
        intPool.evict();
        Assert.assertEquals((long)0L, (long)intPool.getNumIdle((Object)KEY_ZERO));
        Assert.assertEquals((long)4L, (long)intPool.getNumIdle((Object)KEY_ONE));
        String objOneA = (String)intPool.borrowObject((Object)KEY_ONE);
        Assert.assertTrue((boolean)(lifo ? objOneA.equals("19") : objOneA.equals("16")));
        Assert.assertEquals((long)3L, (long)intPool.getNumIdle((Object)KEY_ONE));
        String objOneB = (String)intPool.borrowObject((Object)KEY_ONE);
        Assert.assertTrue((boolean)(lifo ? objOneB.equals("18") : objOneB.equals("17")));
        Assert.assertEquals((long)2L, (long)intPool.getNumIdle((Object)KEY_ONE));
        intPool.evict();
        Assert.assertEquals((long)0L, (long)intPool.getNumIdle((Object)KEY_ONE));
        intPool.evict();
        Assert.assertEquals((long)3L, (long)intPool.getNumIdle((Object)KEY_TWO));
        String objTwoA = (String)intPool.borrowObject((Object)KEY_TWO);
        Assert.assertTrue((boolean)(lifo ? objTwoA.equals("214") : objTwoA.equals("212")));
        Assert.assertEquals((long)2L, (long)intPool.getNumIdle((Object)KEY_TWO));
        intPool.evict();
        Assert.assertEquals((long)0L, (long)intPool.getNumIdle((Object)KEY_TWO));
        intPool.evict();
        intPool.returnObject((Object)KEY_ZERO, (Object)objZeroA);
        intPool.returnObject((Object)KEY_ZERO, (Object)objZeroB);
        intPool.returnObject((Object)KEY_ONE, (Object)objOneA);
        intPool.returnObject((Object)KEY_ONE, (Object)objOneB);
        intPool.returnObject((Object)KEY_TWO, (Object)objTwoA);
        intPool.clear();
        intPool.setMinEvictableIdleTimeMillis(500L);
        intFactory.counter = 0;
        for (int i = 0; i < 3; ++i) {
            Integer key = i;
            for (int j = 0; j < 5; ++j) {
                intPool.addObject((Object)key);
            }
            Thread.sleep(200L);
        }
        intPool.evict();
        Assert.assertEquals((long)3L, (long)intPool.getNumIdle((Object)KEY_ZERO));
        intPool.evict();
        Assert.assertEquals((long)1L, (long)intPool.getNumIdle((Object)KEY_ZERO));
        intPool.evict();
        Assert.assertEquals((long)0L, (long)intPool.getNumIdle((Object)KEY_ZERO));
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_ONE));
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_TWO));
        intPool.evict();
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_ONE));
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_TWO));
        intPool.evict();
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_ONE));
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_TWO));
        intPool.evict();
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_ONE));
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_TWO));
        intPool.evict();
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_ONE));
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_TWO));
        intPool.evict();
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_ONE));
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_TWO));
        Thread.sleep(200L);
        intPool.evict();
        Assert.assertEquals((long)3L, (long)intPool.getNumIdle((Object)KEY_ONE));
        Assert.assertEquals((long)5L, (long)intPool.getNumIdle((Object)KEY_TWO));
        String obj = (String)intPool.borrowObject((Object)KEY_ONE);
        if (lifo) {
            Assert.assertEquals((Object)"19", (Object)obj);
        } else {
            Assert.assertEquals((Object)"15", (Object)obj);
        }
        intPool.close();
    }

    @Test(timeout=60000L)
    public void testEvictorVisiting() throws Exception {
        this.checkEvictorVisiting(true);
        this.checkEvictorVisiting(false);
    }

    private void checkEvictorVisiting(boolean lifo) throws Exception {
        int i;
        VisitTrackerFactory trackerFactory = new VisitTrackerFactory();
        GenericKeyedObjectPool intPool = new GenericKeyedObjectPool(trackerFactory);
        intPool.setNumTestsPerEvictionRun(2);
        intPool.setMinEvictableIdleTimeMillis(-1L);
        intPool.setTestWhileIdle(true);
        intPool.setLifo(lifo);
        intPool.setTestOnReturn(false);
        intPool.setTestOnBorrow(false);
        for (int i2 = 0; i2 < 3; ++i2) {
            trackerFactory.resetId();
            Integer key = i2;
            for (int j = 0; j < 8; ++j) {
                intPool.addObject((Object)key);
            }
        }
        intPool.evict();
        VisitTracker obj = (VisitTracker)intPool.borrowObject((Object)KEY_ZERO);
        intPool.returnObject((Object)KEY_ZERO, (Object)obj);
        obj = (VisitTracker)intPool.borrowObject((Object)KEY_ZERO);
        intPool.returnObject((Object)KEY_ZERO, (Object)obj);
        intPool.evict();
        for (i = 0; i < 8; ++i) {
            VisitTracker tracker = (VisitTracker)intPool.borrowObject((Object)KEY_ZERO);
            if (tracker.getId() >= 4) {
                Assert.assertEquals((String)("Unexpected instance visited " + tracker.getId()), (long)0L, (long)tracker.getValidateCount());
                continue;
            }
            Assert.assertEquals((String)("Instance " + tracker.getId() + " visited wrong number of times."), (long)1L, (long)tracker.getValidateCount());
        }
        intPool.setNumTestsPerEvictionRun(3);
        intPool.evict();
        intPool.evict();
        obj = (VisitTracker)intPool.borrowObject((Object)KEY_ONE);
        intPool.returnObject((Object)KEY_ONE, (Object)obj);
        obj = (VisitTracker)intPool.borrowObject((Object)KEY_ONE);
        intPool.returnObject((Object)KEY_ONE, (Object)obj);
        obj = (VisitTracker)intPool.borrowObject((Object)KEY_ONE);
        intPool.returnObject((Object)KEY_ONE, (Object)obj);
        intPool.evict();
        intPool.evict();
        intPool.evict();
        intPool.evict();
        for (i = 0; i < 8; ++i) {
            VisitTracker tracker = (VisitTracker)intPool.borrowObject((Object)KEY_ONE);
            if (lifo && tracker.getId() > 1 || !lifo && tracker.getId() > 2) {
                Assert.assertEquals((String)("Instance " + tracker.getId() + " visited wrong number of times."), (long)1L, (long)tracker.getValidateCount());
                continue;
            }
            Assert.assertEquals((String)("Instance " + tracker.getId() + " visited wrong number of times."), (long)2L, (long)tracker.getValidateCount());
        }
        intPool.close();
        int[] smallPrimes = new int[]{2, 3, 5, 7};
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        for (int i3 = 0; i3 < smallPrimes.length; ++i3) {
            for (int j = 0; j < 5; ++j) {
                int k;
                trackerFactory = new VisitTrackerFactory();
                intPool = new GenericKeyedObjectPool(trackerFactory);
                intPool.setMaxIdlePerKey(-1);
                intPool.setMaxTotalPerKey(-1);
                intPool.setNumTestsPerEvictionRun(smallPrimes[i3]);
                intPool.setMinEvictableIdleTimeMillis(-1L);
                intPool.setTestWhileIdle(true);
                intPool.setLifo(lifo);
                intPool.setTestOnReturn(false);
                intPool.setTestOnBorrow(false);
                int zeroLength = 10 + random.nextInt(20);
                for (int k2 = 0; k2 < zeroLength; ++k2) {
                    intPool.addObject((Object)KEY_ZERO);
                }
                int oneLength = 10 + random.nextInt(20);
                for (int k3 = 0; k3 < oneLength; ++k3) {
                    intPool.addObject((Object)KEY_ONE);
                }
                int twoLength = 10 + random.nextInt(20);
                for (int k4 = 0; k4 < twoLength; ++k4) {
                    intPool.addObject((Object)KEY_TWO);
                }
                int runs = 10 + random.nextInt(50);
                for (int k5 = 0; k5 < runs; ++k5) {
                    intPool.evict();
                }
                int totalInstances = zeroLength + oneLength + twoLength;
                int cycleCount = runs * intPool.getNumTestsPerEvictionRun() / totalInstances;
                VisitTracker tracker = null;
                int visitCount = 0;
                for (k = 0; k < zeroLength; ++k) {
                    tracker = (VisitTracker)intPool.borrowObject((Object)KEY_ZERO);
                    visitCount = tracker.getValidateCount();
                    if (visitCount >= cycleCount && visitCount <= cycleCount + 1) continue;
                    Assert.fail((String)this.formatSettings("ZERO", "runs", runs, "lifo", lifo, "i", i3, "j", j, "k", k, "visitCount", visitCount, "cycleCount", cycleCount, "totalInstances", totalInstances, zeroLength, oneLength, twoLength));
                }
                for (k = 0; k < oneLength; ++k) {
                    tracker = (VisitTracker)intPool.borrowObject((Object)KEY_ONE);
                    visitCount = tracker.getValidateCount();
                    if (visitCount >= cycleCount && visitCount <= cycleCount + 1) continue;
                    Assert.fail((String)this.formatSettings("ONE", "runs", runs, "lifo", lifo, "i", i3, "j", j, "k", k, "visitCount", visitCount, "cycleCount", cycleCount, "totalInstances", totalInstances, zeroLength, oneLength, twoLength));
                }
                int[] visits = new int[twoLength];
                for (int k6 = 0; k6 < twoLength; ++k6) {
                    tracker = (VisitTracker)intPool.borrowObject((Object)KEY_TWO);
                    visits[k6] = visitCount = tracker.getValidateCount();
                    if (visitCount >= cycleCount && visitCount <= cycleCount + 1) continue;
                    StringBuilder sb = new StringBuilder("Visits:");
                    for (int l = 0; l <= k6; ++l) {
                        sb.append(visits[l]).append(' ');
                    }
                    Assert.fail((String)this.formatSettings("TWO " + sb.toString(), "runs", runs, "lifo", lifo, "i", i3, "j", j, "k", k6, "visitCount", visitCount, "cycleCount", cycleCount, "totalInstances", totalInstances, zeroLength, oneLength, twoLength));
                }
                intPool.close();
            }
        }
    }

    @Test(timeout=60000L)
    public void testConstructors() throws Exception {
        int maxTotalPerKey = 1;
        int minIdle = 2;
        long maxWait = 3L;
        int maxIdle = 4;
        int maxTotal = 5;
        long minEvictableIdleTimeMillis = 6L;
        int numTestsPerEvictionRun = 7;
        boolean testOnBorrow = true;
        boolean testOnReturn = true;
        boolean testWhileIdle = true;
        long timeBetweenEvictionRunsMillis = 8L;
        boolean blockWhenExhausted = false;
        boolean lifo = false;
        DummyFactory dummyFactory = new DummyFactory();
        GenericKeyedObjectPool objPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)dummyFactory);
        Assert.assertEquals((long)8L, (long)objPool.getMaxTotalPerKey());
        Assert.assertEquals((long)8L, (long)objPool.getMaxIdlePerKey());
        Assert.assertEquals((long)-1L, (long)objPool.getMaxWaitMillis());
        Assert.assertEquals((long)0L, (long)objPool.getMinIdlePerKey());
        Assert.assertEquals((long)-1L, (long)objPool.getMaxTotal());
        Assert.assertEquals((long)1800000L, (long)objPool.getMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)3L, (long)objPool.getNumTestsPerEvictionRun());
        Assert.assertEquals((Object)false, (Object)objPool.getTestOnBorrow());
        Assert.assertEquals((Object)false, (Object)objPool.getTestOnReturn());
        Assert.assertEquals((Object)false, (Object)objPool.getTestWhileIdle());
        Assert.assertEquals((long)-1L, (long)objPool.getTimeBetweenEvictionRunsMillis());
        Assert.assertEquals((Object)true, (Object)objPool.getBlockWhenExhausted());
        Assert.assertEquals((Object)true, (Object)objPool.getLifo());
        objPool.close();
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setLifo(lifo);
        config.setMaxTotalPerKey(maxTotalPerKey);
        config.setMaxIdlePerKey(maxIdle);
        config.setMinIdlePerKey(minIdle);
        config.setMaxTotal(maxTotal);
        config.setMaxWaitMillis(maxWait);
        config.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        config.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        config.setTestOnBorrow(testOnBorrow);
        config.setTestOnReturn(testOnReturn);
        config.setTestWhileIdle(testWhileIdle);
        config.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        config.setBlockWhenExhausted(blockWhenExhausted);
        objPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)dummyFactory, config);
        Assert.assertEquals((long)maxTotalPerKey, (long)objPool.getMaxTotalPerKey());
        Assert.assertEquals((long)maxIdle, (long)objPool.getMaxIdlePerKey());
        Assert.assertEquals((long)maxWait, (long)objPool.getMaxWaitMillis());
        Assert.assertEquals((long)minIdle, (long)objPool.getMinIdlePerKey());
        Assert.assertEquals((long)maxTotal, (long)objPool.getMaxTotal());
        Assert.assertEquals((long)minEvictableIdleTimeMillis, (long)objPool.getMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)numTestsPerEvictionRun, (long)objPool.getNumTestsPerEvictionRun());
        Assert.assertEquals((Object)testOnBorrow, (Object)objPool.getTestOnBorrow());
        Assert.assertEquals((Object)testOnReturn, (Object)objPool.getTestOnReturn());
        Assert.assertEquals((Object)testWhileIdle, (Object)objPool.getTestWhileIdle());
        Assert.assertEquals((long)timeBetweenEvictionRunsMillis, (long)objPool.getTimeBetweenEvictionRunsMillis());
        Assert.assertEquals((Object)blockWhenExhausted, (Object)objPool.getBlockWhenExhausted());
        Assert.assertEquals((Object)lifo, (Object)objPool.getLifo());
        objPool.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorNullFactory() {
        Assert.assertNotNull((Object)new GenericKeyedObjectPool(null));
    }

    @Test(timeout=60000L)
    public void testExceptionOnPassivateDuringReturn() throws Exception {
        String obj = (String)this.pool.borrowObject((Object)"one");
        this.factory.setThrowExceptionOnPassivate(true);
        this.pool.returnObject((Object)"one", (Object)obj);
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        this.pool.close();
    }

    @Test(timeout=60000L)
    public void testExceptionOnDestroyDuringBorrow() throws Exception {
        this.factory.setThrowExceptionOnDestroy(true);
        this.factory.setValidationEnabled(true);
        this.pool.setTestOnBorrow(true);
        this.pool.borrowObject((Object)"one");
        this.factory.setValid(false);
        try {
            this.pool.borrowObject((Object)"one");
            Assert.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive((Object)"one"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"one"));
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testExceptionOnDestroyDuringReturn() throws Exception {
        this.factory.setThrowExceptionOnDestroy(true);
        this.factory.setValidationEnabled(true);
        this.pool.setTestOnReturn(true);
        String obj1 = (String)this.pool.borrowObject((Object)"one");
        this.pool.borrowObject((Object)"one");
        this.factory.setValid(false);
        this.pool.returnObject((Object)"one", (Object)obj1);
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive((Object)"one"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"one"));
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testExceptionOnActivateDuringBorrow() throws Exception {
        String obj1 = (String)this.pool.borrowObject((Object)"one");
        String obj2 = (String)this.pool.borrowObject((Object)"one");
        this.pool.returnObject((Object)"one", (Object)obj1);
        this.pool.returnObject((Object)"one", (Object)obj2);
        this.factory.setThrowExceptionOnActivate(true);
        this.factory.setEvenValid(false);
        String obj = (String)this.pool.borrowObject((Object)"one");
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive((Object)"one"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"one"));
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        this.pool.returnObject((Object)"one", (Object)obj);
        this.factory.setValid(false);
        try {
            this.pool.borrowObject((Object)"one");
            Assert.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive((Object)"one"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"one"));
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testBlockedKeyDoesNotBlockPool() throws Exception {
        this.pool.setBlockWhenExhausted(true);
        this.pool.setMaxWaitMillis(5000L);
        this.pool.setMaxTotalPerKey(1);
        this.pool.setMaxTotal(-1);
        this.pool.borrowObject((Object)"one");
        long start = System.currentTimeMillis();
        SimpleTestThread<String> simple = new SimpleTestThread<String>((KeyedObjectPool<String, String>)this.pool, "one");
        new Thread(simple).start();
        Thread.sleep(1000L);
        this.pool.borrowObject((Object)"two");
        long end = System.currentTimeMillis();
        Assert.assertTrue((String)("Elapsed time: " + (end - start) + " should be less than 4000"), (end - start < 4000L ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testMaxWaitMultiThreaded() throws Exception {
        int i;
        long maxWait = 500L;
        long holdTime = 2000L;
        int keyCount = 4;
        int threadsPerKey = 5;
        this.pool.setBlockWhenExhausted(true);
        this.pool.setMaxWaitMillis(500L);
        this.pool.setMaxTotalPerKey(5);
        WaitingTestThread[] wtt = new WaitingTestThread[40];
        for (int i2 = 0; i2 < wtt.length; ++i2) {
            wtt[i2] = new WaitingTestThread((KeyedObjectPool<String, String>)this.pool, Integer.toString(i2 % 4), 2000L);
        }
        long origin = System.currentTimeMillis() - 1000L;
        for (int i3 = 0; i3 < wtt.length; ++i3) {
            wtt[i3].start();
        }
        int failed = 0;
        for (i = 0; i < wtt.length; ++i) {
            wtt[i].join();
            if (wtt[i]._thrown == null) continue;
            ++failed;
        }
        if (DISPLAY_THREAD_DETAILS || wtt.length / 2 != failed) {
            System.out.println("MaxWait: 500 HoldTime: 2000 KeyCount: 4 MaxActive: 5 Threads: " + wtt.length + " Failed: " + failed);
            for (i = 0; i < wtt.length; ++i) {
                WaitingTestThread wt = wtt[i];
                System.out.println("Preborrow: " + (wt.preborrow - origin) + " Postborrow: " + (wt.postborrow != 0L ? wt.postborrow - origin : -1L) + " BorrowTime: " + (wt.postborrow != 0L ? wt.postborrow - wt.preborrow : -1L) + " PostReturn: " + (wt.postreturn != 0L ? wt.postreturn - origin : -1L) + " Ended: " + (wt.ended - origin) + " Key: " + wt._key + " ObjId: " + wt.objectId);
            }
        }
        Assert.assertEquals((String)"Expected half the threads to fail", (long)(wtt.length / 2), (long)failed);
    }

    @Test(timeout=200000L)
    public void testMaxActivePerKeyExceeded() throws Exception {
        WaiterFactory waiterFactory = new WaiterFactory(0L, 20L, 0L, 0L, 0L, 0L, 8L, 5L, 0.0);
        GenericKeyedObjectPool waiterPool = new GenericKeyedObjectPool(waiterFactory);
        waiterPool.setMaxTotalPerKey(5);
        waiterPool.setMaxTotal(8);
        waiterPool.setTestOnBorrow(true);
        waiterPool.setMaxIdlePerKey(5);
        waiterPool.setMaxWaitMillis(-1L);
        this.runTestThreads(20, 300, 250, waiterPool);
        waiterPool.close();
    }

    @Test(timeout=60000L)
    public void testClearOldest() throws Exception {
        WaiterFactory waiterFactory = new WaiterFactory(0L, 20L, 0L, 0L, 0L, 0L, 50L, 5L, 0.0);
        GenericKeyedObjectPool waiterPool = new GenericKeyedObjectPool(waiterFactory);
        waiterPool.setMaxTotalPerKey(5);
        waiterPool.setMaxTotal(50);
        waiterPool.setLifo(false);
        for (int i = 0; i < 10; ++i) {
            String key = Integer.valueOf(i).toString();
            for (int j = 0; j < 5; ++j) {
                waiterPool.addObject((Object)key);
            }
            Thread.sleep(20L);
        }
        SimpleTestThread t2 = new SimpleTestThread(waiterPool, "51");
        Thread thread2 = new Thread(t2);
        thread2.start();
        Thread.sleep(50L);
        Waiter waiter = (Waiter)waiterPool.borrowObject((Object)"1");
        Thread.sleep(200L);
        waiterPool.returnObject((Object)"1", (Object)waiter);
        waiterPool.close();
    }

    @Test(timeout=60000L)
    public void testLivenessPerKey() throws Exception {
        this.pool.setMaxIdlePerKey(3);
        this.pool.setMaxTotal(3);
        this.pool.setMaxTotalPerKey(3);
        this.pool.setMaxWaitMillis(3000L);
        WaitingTestThread t1 = new WaitingTestThread((KeyedObjectPool<String, String>)this.pool, "1", 100L);
        WaitingTestThread t2 = new WaitingTestThread((KeyedObjectPool<String, String>)this.pool, "1", 100L);
        WaitingTestThread t3 = new WaitingTestThread((KeyedObjectPool<String, String>)this.pool, "1", 100L);
        t1.start();
        t2.start();
        t3.start();
        this.pool.borrowObject((Object)"2");
    }

    @Test(timeout=60000L)
    public void testClear() throws Exception {
        this.pool.setMaxTotal(2);
        this.pool.setMaxTotalPerKey(2);
        this.pool.setBlockWhenExhausted(false);
        this.pool.addObject((Object)"one");
        this.pool.addObject((Object)"one");
        Assert.assertEquals((long)2L, (long)this.pool.getNumIdle());
        this.pool.clear((Object)"one");
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"one"));
        String obj1 = (String)this.pool.borrowObject((Object)"one");
        String obj2 = (String)this.pool.borrowObject((Object)"one");
        this.pool.returnObject((Object)"one", (Object)obj1);
        this.pool.returnObject((Object)"one", (Object)obj2);
        this.pool.clear();
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle((Object)"one"));
        this.pool.borrowObject((Object)"one");
        this.pool.borrowObject((Object)"one");
        this.pool.close();
    }

    @Test(timeout=60000L)
    public void testWhenExhaustedBlockClosePool() throws Exception {
        this.pool.setMaxTotalPerKey(1);
        this.pool.setBlockWhenExhausted(true);
        this.pool.setMaxWaitMillis(-1L);
        String obj1 = (String)this.pool.borrowObject((Object)"a");
        Assert.assertNotNull((Object)obj1);
        WaitingTestThread wtt = new WaitingTestThread((KeyedObjectPool<String, String>)this.pool, "a", 200L);
        wtt.start();
        Thread.sleep(200L);
        this.pool.close();
        Thread.sleep(200L);
        Assert.assertTrue((boolean)(wtt._thrown instanceof InterruptedException));
    }

    @Test
    public void testConcurrentInvalidate() throws Exception {
        int i;
        int nObjects = 1000;
        String key = "one";
        this.pool.setMaxTotal(1000);
        this.pool.setMaxTotalPerKey(1000);
        this.pool.setMaxIdlePerKey(1000);
        String[] obj = new String[1000];
        for (i = 0; i < 1000; ++i) {
            obj[i] = (String)this.pool.borrowObject((Object)"one");
        }
        for (i = 0; i < 1000; ++i) {
            if (i % 2 != 0) continue;
            this.pool.returnObject((Object)"one", (Object)obj[i]);
        }
        int nThreads = 20;
        int nIterations = 60;
        InvalidateThread[] threads = new InvalidateThread[20];
        ArrayList<Integer> targets = new ArrayList<Integer>();
        Random random = new Random();
        for (int j = 0; j < 60; ++j) {
            int i2;
            Integer targ = random.nextInt(1000);
            while (targets.contains(targ)) {
                targ = random.nextInt(1000);
            }
            targets.add(targ);
            for (i2 = 0; i2 < 20; ++i2) {
                threads[i2] = new InvalidateThread((KeyedObjectPool<String, String>)this.pool, "one", obj[targ]);
            }
            for (i2 = 0; i2 < 20; ++i2) {
                new Thread(threads[i2]).start();
            }
            boolean done = false;
            while (!done) {
                done = true;
                for (int i3 = 0; i3 < 20; ++i3) {
                    done = done && threads[i3].complete();
                }
                Thread.sleep(100L);
            }
        }
        Assert.assertEquals((long)60L, (long)this.pool.getDestroyedCount());
    }

    @Override
    protected boolean isLifo() {
        return true;
    }

    @Override
    protected boolean isFifo() {
        return false;
    }

    private String getExceptionTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private String formatSettings(String title, String s, int i, String s0, boolean b0, String s1, int i1, String s2, int i2, String s3, int i3, String s4, int i4, String s5, int i5, String s6, int i6, int zeroLength, int oneLength, int twoLength) {
        StringBuilder sb = new StringBuilder(80);
        sb.append(title).append(' ');
        sb.append(s).append('=').append(i).append(' ');
        sb.append(s0).append('=').append(b0).append(' ');
        sb.append(s1).append('=').append(i1).append(' ');
        sb.append(s2).append('=').append(i2).append(' ');
        sb.append(s3).append('=').append(i3).append(' ');
        sb.append(s4).append('=').append(i4).append(' ');
        sb.append(s5).append('=').append(i5).append(' ');
        sb.append(s6).append('=').append(i6).append(' ');
        sb.append("Lengths=").append(zeroLength).append(',').append(oneLength).append(',').append(twoLength).append(' ');
        return sb.toString();
    }

    @Test(timeout=60000L)
    public void testJmxRegistration() {
        ObjectName oname = this.pool.getJmxName();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(oname, null);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testInvalidateWaiting() throws Exception {
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMaxTotal(2);
        config.setBlockWhenExhausted(true);
        config.setMinIdlePerKey(0);
        config.setMaxWaitMillis(-1L);
        config.setNumTestsPerEvictionRun(Integer.MAX_VALUE);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(false);
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRunsMillis(-1L);
        final GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new ObjectFactory(), config);
        pool.borrowObject((Object)1);
        Object object2 = pool.borrowObject((Object)1);
        ExecutorService executorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
        final Semaphore signal = new Semaphore(0);
        Future<Exception> result = executorService.submit(new Callable<Exception>(){

            @Override
            public Exception call() {
                try {
                    signal.release();
                    Object object3 = pool.borrowObject((Object)1);
                    pool.returnObject((Object)1, object3);
                    signal.release();
                }
                catch (Exception e) {
                    return e;
                }
                catch (Throwable e) {
                    return new Exception(e);
                }
                return null;
            }
        });
        Assert.assertTrue((boolean)signal.tryAcquire(5L, TimeUnit.SECONDS));
        Thread.sleep(500L);
        pool.invalidateObject((Object)1, object2);
        Assert.assertTrue((String)"Call to invalidateObject did not unblock pool waiters.", (boolean)signal.tryAcquire(2L, TimeUnit.SECONDS));
        if (result.get() != null) {
            throw new AssertionError((Object)result.get());
        }
    }

    @Test
    public void testInvalidateFreesCapacity() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);
        pool.setMaxTotalPerKey(2);
        pool.setMaxWaitMillis(500L);
        WaitingTestThread thread1 = new WaitingTestThread((KeyedObjectPool<String, String>)pool, "one", 5000L);
        thread1.start();
        String obj = (String)pool.borrowObject((Object)"one");
        WaitingTestThread thread2 = new WaitingTestThread((KeyedObjectPool<String, String>)pool, "one", 100L);
        thread2.start();
        Thread.sleep(20L);
        pool.invalidateObject((Object)"one", (Object)obj);
        Thread.sleep(600L);
        if (thread2._thrown != null) {
            Assert.fail((String)thread2._thrown.toString());
        }
    }

    @Test
    public void testValidationFailureOnReturnFreesCapacity() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        factory.setValid(false);
        factory.setValidationEnabled(true);
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);
        pool.setMaxTotalPerKey(2);
        pool.setMaxWaitMillis(1500L);
        pool.setTestOnReturn(true);
        pool.setTestOnBorrow(false);
        WaitingTestThread thread1 = new WaitingTestThread((KeyedObjectPool<String, String>)pool, "one", 5000L);
        thread1.start();
        WaitingTestThread thread2 = new WaitingTestThread((KeyedObjectPool<String, String>)pool, "one", 500L);
        thread2.start();
        Thread.sleep(50L);
        String obj = (String)pool.borrowObject((Object)"one");
        pool.returnObject((Object)"one", (Object)obj);
    }

    @Test
    public void testMakeObjectException() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);
        pool.setMaxTotalPerKey(1);
        pool.setBlockWhenExhausted(false);
        factory.exceptionOnCreate = true;
        try {
            pool.borrowObject((Object)"One");
        }
        catch (Exception exception) {
            // empty catch block
        }
        factory.exceptionOnCreate = false;
        pool.borrowObject((Object)"One");
    }

    private static class ObjectFactory
    extends BaseKeyedPooledObjectFactory<Integer, Object> {
        private ObjectFactory() {
        }

        public Object create(Integer key) throws Exception {
            return new Object();
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }

    private static class SimplePerKeyFactory
    extends BaseKeyedPooledObjectFactory<Object, Object> {
        ConcurrentHashMap<Object, AtomicInteger> map = new ConcurrentHashMap();

        private SimplePerKeyFactory() {
        }

        public Object create(Object key) throws Exception {
            int counter = 0;
            AtomicInteger Counter2 = this.map.get(key);
            if (null != Counter2) {
                counter = Counter2.incrementAndGet();
            } else {
                this.map.put(key, new AtomicInteger(0));
                counter = 0;
            }
            return String.valueOf(key) + String.valueOf(counter);
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }

    private static class DummyFactory
    extends BaseKeyedPooledObjectFactory<Object, Object> {
        private DummyFactory() {
        }

        public Object create(Object key) throws Exception {
            return null;
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }

    static class SimpleFactory<K>
    implements KeyedPooledObjectFactory<K, String> {
        volatile int counter = 0;
        boolean valid;
        int activeCount = 0;
        int validateCounter = 0;
        boolean evenValid = true;
        boolean oddValid = true;
        boolean enableValidation = false;
        long destroyLatency = 0L;
        volatile int maxTotalPerKey = Integer.MAX_VALUE;
        boolean exceptionOnPassivate = false;
        boolean exceptionOnActivate = false;
        boolean exceptionOnDestroy = false;
        boolean exceptionOnCreate = false;

        public SimpleFactory() {
            this(true);
        }

        public SimpleFactory(boolean valid) {
            this.valid = valid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PooledObject<String> makeObject(K key) throws Exception {
            if (this.exceptionOnCreate) {
                throw new Exception();
            }
            String out = null;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                ++this.activeCount;
                if (this.activeCount > this.maxTotalPerKey) {
                    throw new IllegalStateException("Too many active instances: " + this.activeCount);
                }
                out = String.valueOf(key) + String.valueOf(this.counter++);
            }
            return new DefaultPooledObject((Object)out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(K key, PooledObject<String> obj) throws Exception {
            this.doWait(this.destroyLatency);
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                --this.activeCount;
            }
            if (this.exceptionOnDestroy) {
                throw new Exception();
            }
        }

        public boolean validateObject(K key, PooledObject<String> obj) {
            if (this.enableValidation) {
                return this.validateCounter++ % 2 == 0 ? this.evenValid : this.oddValid;
            }
            return this.valid;
        }

        public void activateObject(K key, PooledObject<String> obj) throws Exception {
            if (this.exceptionOnActivate && !(this.validateCounter++ % 2 != 0 ? this.oddValid : this.evenValid)) {
                throw new Exception();
            }
        }

        public void passivateObject(K key, PooledObject<String> obj) throws Exception {
            if (this.exceptionOnPassivate) {
                throw new Exception();
            }
        }

        public void setMaxTotalPerKey(int maxTotalPerKey) {
            this.maxTotalPerKey = maxTotalPerKey;
        }

        public void setDestroyLatency(long destroyLatency) {
            this.destroyLatency = destroyLatency;
        }

        public void setValidationEnabled(boolean b) {
            this.enableValidation = b;
        }

        void setEvenValid(boolean valid) {
            this.evenValid = valid;
        }

        void setValid(boolean valid) {
            this.evenValid = valid;
            this.oddValid = valid;
        }

        public void setThrowExceptionOnActivate(boolean b) {
            this.exceptionOnActivate = b;
        }

        public void setThrowExceptionOnDestroy(boolean b) {
            this.exceptionOnDestroy = b;
        }

        public void setThrowExceptionOnPassivate(boolean b) {
            this.exceptionOnPassivate = b;
        }

        private void doWait(long latency) {
            try {
                Thread.sleep(latency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class TestThread<T>
    implements Runnable {
        private final Random _random = new Random();
        private final KeyedObjectPool<String, T> _pool;
        private final int _iter;
        private final int _delay;
        private volatile boolean _complete = false;
        private volatile boolean _failed = false;
        private volatile Exception _exception;

        public TestThread(KeyedObjectPool<String, T> pool) {
            this(pool, 100, 50);
        }

        public TestThread(KeyedObjectPool<String, T> pool, int iter) {
            this(pool, iter, 50);
        }

        public TestThread(KeyedObjectPool<String, T> pool, int iter, int delay) {
            this._pool = pool;
            this._iter = iter;
            this._delay = delay;
        }

        public boolean complete() {
            return this._complete;
        }

        public boolean failed() {
            return this._failed;
        }

        @Override
        public void run() {
            for (int i = 0; i < this._iter; ++i) {
                String key = String.valueOf(this._random.nextInt(3));
                try {
                    Thread.sleep(this._random.nextInt(this._delay));
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                Object obj = null;
                try {
                    obj = this._pool.borrowObject((Object)key);
                }
                catch (Exception e) {
                    this._exception = e;
                    this._failed = true;
                    this._complete = true;
                    break;
                }
                try {
                    Thread.sleep(this._random.nextInt(this._delay));
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    this._pool.returnObject((Object)key, obj);
                    continue;
                }
                catch (Exception e) {
                    this._exception = e;
                    this._failed = true;
                    this._complete = true;
                    break;
                }
            }
            this._complete = true;
        }
    }

    static class WaitingTestThread
    extends Thread {
        private final KeyedObjectPool<String, String> _pool;
        private final String _key;
        private final long _pause;
        private Throwable _thrown;
        private long preborrow;
        private long postborrow;
        private long postreturn;
        private long ended;
        private String objectId;

        public WaitingTestThread(KeyedObjectPool<String, String> pool, String key, long pause) {
            this._pool = pool;
            this._key = key;
            this._pause = pause;
            this._thrown = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String obj;
                this.preborrow = System.currentTimeMillis();
                this.objectId = obj = (String)this._pool.borrowObject((Object)this._key);
                this.postborrow = System.currentTimeMillis();
                Thread.sleep(this._pause);
                this._pool.returnObject((Object)this._key, (Object)obj);
                this.postreturn = System.currentTimeMillis();
            }
            catch (Exception e) {
                this._thrown = e;
            }
            finally {
                this.ended = System.currentTimeMillis();
            }
        }
    }

    static class SimpleTestThread<T>
    implements Runnable {
        private final KeyedObjectPool<String, T> _pool;
        private final String _key;

        public SimpleTestThread(KeyedObjectPool<String, T> pool, String key) {
            this._pool = pool;
            this._key = key;
        }

        @Override
        public void run() {
            try {
                Object obj = this._pool.borrowObject((Object)this._key);
                this._pool.returnObject((Object)this._key, obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class InvalidateThread
    implements Runnable {
        private final String obj;
        private final KeyedObjectPool<String, String> pool;
        private final String key;
        private boolean done = false;

        public InvalidateThread(KeyedObjectPool<String, String> pool, String key, String obj) {
            this.obj = obj;
            this.pool = pool;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.pool.invalidateObject((Object)this.key, (Object)this.obj);
            }
            catch (IllegalStateException ex) {
            }
            catch (Exception ex) {
                Assert.fail((String)("Unexpected exception " + ex.toString()));
            }
            finally {
                this.done = true;
            }
        }

        public boolean complete() {
            return this.done;
        }
    }
}

