/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DateUtilsRoundingTest {
    DateFormat dateTimeParser;
    Date januaryOneDate;
    Date targetYearDate;
    Date targetDateDate;
    Date targetDayOfMonthDate;
    Date targetAmDate;
    Date targetPmDate;
    Date targetHourOfDayDate;
    Date targetHourDate;
    Date targetMinuteDate;
    Date targetSecondDate;
    Date targetMilliSecondDate;
    Calendar januaryOneCalendar;
    FastDateFormat fdf = DateFormatUtils.ISO_DATETIME_FORMAT;

    @BeforeEach
    public void setUp() throws Exception {
        this.dateTimeParser = new SimpleDateFormat("MMM dd, yyyy H:mm:ss.SSS", Locale.ENGLISH);
        this.targetYearDate = this.dateTimeParser.parse("January 1, 2007 0:00:00.000");
        this.targetDateDate = this.targetDayOfMonthDate = this.dateTimeParser.parse("June 1, 2008 0:00:00.000");
        this.targetAmDate = this.dateTimeParser.parse("June 1, 2008 0:00:00.000");
        this.targetPmDate = this.dateTimeParser.parse("June 1, 2008 12:00:00.000");
        this.targetHourDate = this.dateTimeParser.parse("June 1, 2008 8:00:00.000");
        this.targetHourOfDayDate = this.dateTimeParser.parse("June 1, 2008 8:00:00.000");
        this.targetMinuteDate = this.dateTimeParser.parse("June 1, 2008 8:15:00.000");
        this.targetSecondDate = this.dateTimeParser.parse("June 1, 2008 8:15:14.000");
        this.targetMilliSecondDate = this.dateTimeParser.parse("June 1, 2008 8:15:14.231");
        this.januaryOneDate = this.dateTimeParser.parse("January 1, 2008 0:00:00.000");
        this.januaryOneCalendar = Calendar.getInstance();
        this.januaryOneCalendar.setTime(this.januaryOneDate);
    }

    @Test
    public void testRoundYear() throws Exception {
        boolean calendarField = true;
        Date roundedUpDate = this.dateTimeParser.parse("January 1, 2008 0:00:00.000");
        Date roundedDownDate = this.targetYearDate;
        Date lastRoundedDownDate = this.dateTimeParser.parse("June 30, 2007 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 1);
    }

    @Test
    public void testRoundMonth() throws Exception {
        int calendarField = 2;
        Date roundedUpDate = this.dateTimeParser.parse("March 1, 2007 0:00:00.000");
        Date roundedDownDate = this.dateTimeParser.parse("February 1, 2007 0:00:00.000");
        Date lastRoundedDownDate = this.dateTimeParser.parse("February 14, 2007 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 2);
        roundedUpDate = this.dateTimeParser.parse("March 1, 2008 0:00:00.000");
        roundedDownDate = this.dateTimeParser.parse("February 1, 2008 0:00:00.000");
        lastRoundedDownDate = this.dateTimeParser.parse("February 15, 2008 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 2);
        roundedUpDate = this.dateTimeParser.parse("May 1, 2008 0:00:00.000");
        roundedDownDate = this.dateTimeParser.parse("April 1, 2008 0:00:00.000");
        lastRoundedDownDate = this.dateTimeParser.parse("April 15, 2008 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 2);
        roundedUpDate = this.dateTimeParser.parse("June 1, 2008 0:00:00.000");
        roundedDownDate = this.dateTimeParser.parse("May 1, 2008 0:00:00.000");
        lastRoundedDownDate = this.dateTimeParser.parse("May 16, 2008 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 2);
        Date minDate = this.dateTimeParser.parse("December 17, 2007 00:00:00.000");
        Date maxDate = this.dateTimeParser.parse("January 16, 2008 23:59:59.999");
        this.roundToJanuaryFirst(minDate, maxDate, 2);
    }

    @Test
    public void testRoundSemiMonth() throws Exception {
        int calendarField = 1001;
        Date roundedUpDate = this.dateTimeParser.parse("February 16, 2007 0:00:00.000");
        Date roundedDownDate = this.dateTimeParser.parse("February 1, 2007 0:00:00.000");
        Date lastRoundedDownDate = this.dateTimeParser.parse("February 8, 2007 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 1001);
        roundedUpDate = this.dateTimeParser.parse("March 1, 2007 0:00:00.000");
        roundedDownDate = this.dateTimeParser.parse("February 16, 2007 0:00:00.000");
        lastRoundedDownDate = this.dateTimeParser.parse("February 23, 2007 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 1001);
        roundedUpDate = this.dateTimeParser.parse("February 16, 2008 0:00:00.000");
        roundedDownDate = this.dateTimeParser.parse("February 1, 2008 0:00:00.000");
        lastRoundedDownDate = this.dateTimeParser.parse("February 8, 2008 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 1001);
        roundedUpDate = this.dateTimeParser.parse("March 1, 2008 0:00:00.000");
        roundedDownDate = this.dateTimeParser.parse("February 16, 2008 0:00:00.000");
        lastRoundedDownDate = this.dateTimeParser.parse("February 23, 2008 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 1001);
        roundedUpDate = this.dateTimeParser.parse("April 16, 2008 0:00:00.000");
        roundedDownDate = this.dateTimeParser.parse("April 1, 2008 0:00:00.000");
        lastRoundedDownDate = this.dateTimeParser.parse("April 8, 2008 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 1001);
        roundedUpDate = this.dateTimeParser.parse("May 1, 2008 0:00:00.000");
        roundedDownDate = this.dateTimeParser.parse("April 16, 2008 0:00:00.000");
        lastRoundedDownDate = this.dateTimeParser.parse("April 23, 2008 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 1001);
        roundedUpDate = this.dateTimeParser.parse("May 16, 2008 0:00:00.000");
        roundedDownDate = this.dateTimeParser.parse("May 1, 2008 0:00:00.000");
        lastRoundedDownDate = this.dateTimeParser.parse("May 8, 2008 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 1001);
        roundedUpDate = this.dateTimeParser.parse("June 1, 2008 0:00:00.000");
        roundedDownDate = this.dateTimeParser.parse("May 16, 2008 0:00:00.000");
        lastRoundedDownDate = this.dateTimeParser.parse("May 23, 2008 23:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 1001);
        Date minDate = this.dateTimeParser.parse("December 24, 2007 00:00:00.000");
        Date maxDate = this.dateTimeParser.parse("January 8, 2008 23:59:59.999");
        this.roundToJanuaryFirst(minDate, maxDate, 1001);
    }

    @Test
    public void testRoundDate() throws Exception {
        int calendarField = 5;
        Date roundedUpDate = this.dateTimeParser.parse("June 2, 2008 0:00:00.000");
        Date roundedDownDate = this.targetDateDate;
        Date lastRoundedDownDate = this.dateTimeParser.parse("June 1, 2008 11:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 5);
        Date minDate = this.dateTimeParser.parse("December 31, 2007 12:00:00.000");
        Date maxDate = this.dateTimeParser.parse("January 1, 2008 11:59:59.999");
        this.roundToJanuaryFirst(minDate, maxDate, 5);
    }

    @Test
    public void testRoundDayOfMonth() throws Exception {
        int calendarField = 5;
        Date roundedUpDate = this.dateTimeParser.parse("June 2, 2008 0:00:00.000");
        Date roundedDownDate = this.targetDayOfMonthDate;
        Date lastRoundedDownDate = this.dateTimeParser.parse("June 1, 2008 11:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 5);
        Date minDate = this.dateTimeParser.parse("December 31, 2007 12:00:00.000");
        Date maxDate = this.dateTimeParser.parse("January 1, 2008 11:59:59.999");
        this.roundToJanuaryFirst(minDate, maxDate, 5);
    }

    @Test
    public void testRoundAmPm() throws Exception {
        int calendarField = 9;
        Date roundedUpDate = this.dateTimeParser.parse("June 1, 2008 12:00:00.000");
        Date roundedDownDate = this.targetAmDate;
        Date lastRoundedDownDate = this.dateTimeParser.parse("June 1, 2008 5:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 9);
        roundedUpDate = this.dateTimeParser.parse("June 2, 2008 0:00:00.000");
        roundedDownDate = this.targetPmDate;
        lastRoundedDownDate = this.dateTimeParser.parse("June 1, 2008 17:59:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 9);
        Date minDate = this.dateTimeParser.parse("December 31, 2007 18:00:00.000");
        Date maxDate = this.dateTimeParser.parse("January 1, 2008 5:59:59.999");
        this.roundToJanuaryFirst(minDate, maxDate, 9);
    }

    @Test
    public void testRoundHourOfDay() throws Exception {
        int calendarField = 11;
        Date roundedUpDate = this.dateTimeParser.parse("June 1, 2008 9:00:00.000");
        Date roundedDownDate = this.targetHourOfDayDate;
        Date lastRoundedDownDate = this.dateTimeParser.parse("June 1, 2008 8:29:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 11);
        Date minDate = this.dateTimeParser.parse("December 31, 2007 23:30:00.000");
        Date maxDate = this.dateTimeParser.parse("January 1, 2008 0:29:59.999");
        this.roundToJanuaryFirst(minDate, maxDate, 11);
    }

    @Test
    public void testRoundHour() throws Exception {
        int calendarField = 10;
        Date roundedUpDate = this.dateTimeParser.parse("June 1, 2008 9:00:00.000");
        Date roundedDownDate = this.targetHourDate;
        Date lastRoundedDownDate = this.dateTimeParser.parse("June 1, 2008 8:29:59.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 10);
        Date minDate = this.dateTimeParser.parse("December 31, 2007 23:30:00.000");
        Date maxDate = this.dateTimeParser.parse("January 1, 2008 0:29:59.999");
        this.roundToJanuaryFirst(minDate, maxDate, 10);
    }

    @Test
    public void testRoundMinute() throws Exception {
        int calendarField = 12;
        Date roundedUpDate = this.dateTimeParser.parse("June 1, 2008 8:16:00.000");
        Date roundedDownDate = this.targetMinuteDate;
        Date lastRoundedDownDate = this.dateTimeParser.parse("June 1, 2008 8:15:29.999");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 12);
        Date minDate = this.dateTimeParser.parse("December 31, 2007 23:59:30.000");
        Date maxDate = this.dateTimeParser.parse("January 1, 2008 0:00:29.999");
        this.roundToJanuaryFirst(minDate, maxDate, 12);
    }

    @Test
    public void testRoundSecond() throws Exception {
        int calendarField = 13;
        Date roundedUpDate = this.dateTimeParser.parse("June 1, 2008 8:15:15.000");
        Date roundedDownDate = this.targetSecondDate;
        Date lastRoundedDownDate = this.dateTimeParser.parse("June 1, 2008 8:15:14.499");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 13);
        Date minDate = this.dateTimeParser.parse("December 31, 2007 23:59:59.500");
        Date maxDate = this.dateTimeParser.parse("January 1, 2008 0:00:00.499");
        this.roundToJanuaryFirst(minDate, maxDate, 13);
    }

    @Test
    public void testRoundMilliSecond() throws Exception {
        Date maxDate;
        Date lastRoundedDownDate;
        int calendarField = 14;
        Date roundedDownDate = lastRoundedDownDate = this.targetMilliSecondDate;
        Date roundedUpDate = this.dateTimeParser.parse("June 1, 2008 8:15:14.232");
        this.baseRoundTest(roundedUpDate, roundedDownDate, lastRoundedDownDate, 14);
        Date minDate = maxDate = this.januaryOneDate;
        this.roundToJanuaryFirst(minDate, maxDate, 14);
    }

    @Test
    public void testTruncateYear() throws Exception {
        boolean calendarField = true;
        Date lastTruncateDate = this.dateTimeParser.parse("December 31, 2007 23:59:59.999");
        this.baseTruncateTest(this.targetYearDate, lastTruncateDate, 1);
    }

    @Test
    public void testTruncateMonth() throws Exception {
        int calendarField = 2;
        Date truncatedDate = this.dateTimeParser.parse("March 1, 2008 0:00:00.000");
        Date lastTruncateDate = this.dateTimeParser.parse("March 31, 2008 23:59:59.999");
        this.baseTruncateTest(truncatedDate, lastTruncateDate, 2);
    }

    @Test
    public void testTruncateSemiMonth() throws Exception {
        int calendarField = 1001;
        Date truncatedDate = this.dateTimeParser.parse("February 1, 2007 0:00:00.000");
        Date lastTruncateDate = this.dateTimeParser.parse("February 15, 2007 23:59:59.999");
        this.baseTruncateTest(truncatedDate, lastTruncateDate, 1001);
        truncatedDate = this.dateTimeParser.parse("February 16, 2007 0:00:00.000");
        lastTruncateDate = this.dateTimeParser.parse("February 28, 2007 23:59:59.999");
        this.baseTruncateTest(truncatedDate, lastTruncateDate, 1001);
        truncatedDate = this.dateTimeParser.parse("February 1, 2008 0:00:00.000");
        lastTruncateDate = this.dateTimeParser.parse("February 15, 2008 23:59:59.999");
        this.baseTruncateTest(truncatedDate, lastTruncateDate, 1001);
        truncatedDate = this.dateTimeParser.parse("February 16, 2008 0:00:00.000");
        lastTruncateDate = this.dateTimeParser.parse("February 29, 2008 23:59:59.999");
        this.baseTruncateTest(truncatedDate, lastTruncateDate, 1001);
        truncatedDate = this.dateTimeParser.parse("April 1, 2008 0:00:00.000");
        lastTruncateDate = this.dateTimeParser.parse("April 15, 2008 23:59:59.999");
        this.baseTruncateTest(truncatedDate, lastTruncateDate, 1001);
        truncatedDate = this.dateTimeParser.parse("April 16, 2008 0:00:00.000");
        lastTruncateDate = this.dateTimeParser.parse("April 30, 2008 23:59:59.999");
        this.baseTruncateTest(truncatedDate, lastTruncateDate, 1001);
        truncatedDate = this.dateTimeParser.parse("March 1, 2008 0:00:00.000");
        lastTruncateDate = this.dateTimeParser.parse("March 15, 2008 23:59:59.999");
        this.baseTruncateTest(truncatedDate, lastTruncateDate, 1001);
        truncatedDate = this.dateTimeParser.parse("March 16, 2008 0:00:00.000");
        lastTruncateDate = this.dateTimeParser.parse("March 31, 2008 23:59:59.999");
        this.baseTruncateTest(truncatedDate, lastTruncateDate, 1001);
    }

    @Test
    public void testTruncateDate() throws Exception {
        int calendarField = 5;
        Date lastTruncateDate = this.dateTimeParser.parse("June 1, 2008 23:59:59.999");
        this.baseTruncateTest(this.targetDateDate, lastTruncateDate, 5);
    }

    @Test
    public void testTruncateDayOfMonth() throws Exception {
        int calendarField = 5;
        Date lastTruncateDate = this.dateTimeParser.parse("June 1, 2008 23:59:59.999");
        this.baseTruncateTest(this.targetDayOfMonthDate, lastTruncateDate, 5);
    }

    @Test
    public void testTruncateAmPm() throws Exception {
        int calendarField = 9;
        Date lastTruncateDate = this.dateTimeParser.parse("June 1, 2008 11:59:59.999");
        this.baseTruncateTest(this.targetAmDate, lastTruncateDate, 9);
        lastTruncateDate = this.dateTimeParser.parse("June 1, 2008 23:59:59.999");
        this.baseTruncateTest(this.targetPmDate, lastTruncateDate, 9);
    }

    @Test
    public void testTruncateHour() throws Exception {
        int calendarField = 10;
        Date lastTruncateDate = this.dateTimeParser.parse("June 1, 2008 8:59:59.999");
        this.baseTruncateTest(this.targetHourDate, lastTruncateDate, 10);
    }

    @Test
    public void testTruncateHourOfDay() throws Exception {
        int calendarField = 11;
        Date lastTruncateDate = this.dateTimeParser.parse("June 1, 2008 8:59:59.999");
        this.baseTruncateTest(this.targetHourOfDayDate, lastTruncateDate, 11);
    }

    @Test
    public void testTruncateMinute() throws Exception {
        int calendarField = 12;
        Date lastTruncateDate = this.dateTimeParser.parse("June 1, 2008 8:15:59.999");
        this.baseTruncateTest(this.targetMinuteDate, lastTruncateDate, 12);
    }

    @Test
    public void testTruncateSecond() throws Exception {
        int calendarField = 13;
        Date lastTruncateDate = this.dateTimeParser.parse("June 1, 2008 8:15:14.999");
        this.baseTruncateTest(this.targetSecondDate, lastTruncateDate, 13);
    }

    @Test
    public void testTruncateMilliSecond() {
        int calendarField = 14;
        this.baseTruncateTest(this.targetMilliSecondDate, this.targetMilliSecondDate, 14);
    }

    protected void baseRoundTest(Date roundedUpDate, Date roundedDownDate, Date lastRoundDownDate, int calendarField) {
        Date firstRoundUpDate = DateUtils.addMilliseconds((Date)lastRoundDownDate, (int)1);
        Assertions.assertEquals((Object)roundedDownDate, (Object)DateUtils.round((Date)roundedDownDate, (int)calendarField));
        Assertions.assertEquals((Object)roundedUpDate, (Object)DateUtils.round((Date)roundedUpDate, (int)calendarField));
        Assertions.assertEquals((Object)roundedDownDate, (Object)DateUtils.round((Date)lastRoundDownDate, (int)calendarField));
        Assertions.assertEquals((Object)roundedUpDate, (Object)DateUtils.round((Date)firstRoundUpDate, (int)calendarField));
        Calendar roundedDownCalendar = Calendar.getInstance();
        Calendar roundedUpCalendar = Calendar.getInstance();
        Calendar lastRoundDownCalendar = Calendar.getInstance();
        Calendar firstRoundUpCalendar = Calendar.getInstance();
        roundedDownCalendar.setTime(roundedDownDate);
        roundedUpCalendar.setTime(roundedUpDate);
        lastRoundDownCalendar.setTime(lastRoundDownDate);
        firstRoundUpCalendar.setTime(firstRoundUpDate);
        Assertions.assertEquals((Object)roundedDownCalendar, (Object)DateUtils.round((Calendar)roundedDownCalendar, (int)calendarField));
        Assertions.assertEquals((Object)roundedUpCalendar, (Object)DateUtils.round((Calendar)roundedUpCalendar, (int)calendarField));
        Assertions.assertEquals((Object)roundedDownCalendar, (Object)DateUtils.round((Calendar)lastRoundDownCalendar, (int)calendarField));
        Assertions.assertEquals((Object)roundedUpCalendar, (Object)DateUtils.round((Calendar)firstRoundUpCalendar, (int)calendarField));
        Assertions.assertEquals((Object)roundedDownDate, (Object)DateUtils.round((Object)roundedDownDate, (int)calendarField));
        Assertions.assertEquals((Object)roundedUpDate, (Object)DateUtils.round((Object)roundedUpDate, (int)calendarField));
        Assertions.assertEquals((Object)roundedDownDate, (Object)DateUtils.round((Object)lastRoundDownDate, (int)calendarField));
        Assertions.assertEquals((Object)roundedUpDate, (Object)DateUtils.round((Object)firstRoundUpDate, (int)calendarField));
        Assertions.assertEquals((Object)roundedDownDate, (Object)DateUtils.round((Object)roundedDownCalendar, (int)calendarField));
        Assertions.assertEquals((Object)roundedUpDate, (Object)DateUtils.round((Object)roundedUpCalendar, (int)calendarField));
        Assertions.assertEquals((Object)roundedDownDate, (Object)DateUtils.round((Object)lastRoundDownDate, (int)calendarField));
        Assertions.assertEquals((Object)roundedUpDate, (Object)DateUtils.round((Object)firstRoundUpDate, (int)calendarField));
    }

    protected void baseTruncateTest(Date truncatedDate, Date lastTruncateDate, int calendarField) {
        Date nextTruncateDate = DateUtils.addMilliseconds((Date)lastTruncateDate, (int)1);
        Assertions.assertEquals((Object)truncatedDate, (Object)DateUtils.truncate((Date)truncatedDate, (int)calendarField), (String)("Truncating " + this.fdf.format(truncatedDate) + " as Date with CalendarField-value " + calendarField + " must return itself"));
        Assertions.assertEquals((Object)truncatedDate, (Object)DateUtils.truncate((Date)lastTruncateDate, (int)calendarField));
        Assertions.assertNotEquals((Object)truncatedDate, (Object)DateUtils.truncate((Date)nextTruncateDate, (int)calendarField), (String)(this.fdf.format(lastTruncateDate) + " is not an extreme when truncating as Date with CalendarField-value " + calendarField));
        Calendar truncatedCalendar = Calendar.getInstance();
        Calendar lastTruncateCalendar = Calendar.getInstance();
        Calendar nextTruncateCalendar = Calendar.getInstance();
        truncatedCalendar.setTime(truncatedDate);
        lastTruncateCalendar.setTime(lastTruncateDate);
        nextTruncateCalendar.setTime(nextTruncateDate);
        Assertions.assertEquals((Object)truncatedCalendar, (Object)DateUtils.truncate((Calendar)truncatedCalendar, (int)calendarField), (String)("Truncating " + this.fdf.format(truncatedCalendar) + " as Calendar with CalendarField-value " + calendarField + " must return itself"));
        Assertions.assertEquals((Object)truncatedCalendar, (Object)DateUtils.truncate((Calendar)lastTruncateCalendar, (int)calendarField));
        Assertions.assertNotEquals((Object)truncatedCalendar, (Object)DateUtils.truncate((Calendar)nextTruncateCalendar, (int)calendarField), (String)(this.fdf.format(lastTruncateCalendar) + " is not an extreme when truncating as Calendar with CalendarField-value " + calendarField));
        Assertions.assertEquals((Object)truncatedDate, (Object)DateUtils.truncate((Object)truncatedDate, (int)calendarField), (String)("Truncating " + this.fdf.format(truncatedDate) + " as Date cast to Object with CalendarField-value " + calendarField + " must return itself as Date"));
        Assertions.assertEquals((Object)truncatedDate, (Object)DateUtils.truncate((Object)lastTruncateDate, (int)calendarField));
        Assertions.assertNotEquals((Object)truncatedDate, (Object)DateUtils.truncate((Object)nextTruncateDate, (int)calendarField), (String)(this.fdf.format(lastTruncateDate) + " is not an extreme when truncating as Date cast to Object with CalendarField-value " + calendarField));
        Assertions.assertEquals((Object)truncatedDate, (Object)DateUtils.truncate((Object)truncatedCalendar, (int)calendarField), (String)("Truncating " + this.fdf.format(truncatedCalendar) + " as Calendar cast to Object with CalendarField-value " + calendarField + " must return itself as Date"));
        Assertions.assertEquals((Object)truncatedDate, (Object)DateUtils.truncate((Object)lastTruncateCalendar, (int)calendarField));
        Assertions.assertNotEquals((Object)truncatedDate, (Object)DateUtils.truncate((Object)nextTruncateCalendar, (int)calendarField), (String)(this.fdf.format(lastTruncateCalendar) + " is not an extreme when truncating as Calendar cast to Object with CalendarField-value " + calendarField));
    }

    protected void roundToJanuaryFirst(Date minDate, Date maxDate, int calendarField) {
        Assertions.assertEquals((Object)this.januaryOneDate, (Object)DateUtils.round((Date)this.januaryOneDate, (int)calendarField), (String)("Rounding " + this.fdf.format(this.januaryOneDate) + " as Date with CalendarField-value " + calendarField + " must return itself"));
        Assertions.assertEquals((Object)this.januaryOneDate, (Object)DateUtils.round((Date)minDate, (int)calendarField));
        Assertions.assertEquals((Object)this.januaryOneDate, (Object)DateUtils.round((Date)maxDate, (int)calendarField));
        Calendar minCalendar = Calendar.getInstance();
        minCalendar.setTime(minDate);
        Calendar maxCalendar = Calendar.getInstance();
        maxCalendar.setTime(maxDate);
        Assertions.assertEquals((Object)this.januaryOneCalendar, (Object)DateUtils.round((Calendar)this.januaryOneCalendar, (int)calendarField), (String)("Rounding " + this.fdf.format(this.januaryOneCalendar) + " as Date with CalendarField-value " + calendarField + " must return itself"));
        Assertions.assertEquals((Object)this.januaryOneCalendar, (Object)DateUtils.round((Calendar)minCalendar, (int)calendarField));
        Assertions.assertEquals((Object)this.januaryOneCalendar, (Object)DateUtils.round((Calendar)maxCalendar, (int)calendarField));
        Date toPrevRoundDate = DateUtils.addMilliseconds((Date)minDate, (int)-1);
        Date toNextRoundDate = DateUtils.addMilliseconds((Date)maxDate, (int)1);
        Assertions.assertNotEquals((Object)this.januaryOneDate, (Object)DateUtils.round((Date)toPrevRoundDate, (int)calendarField), (String)(this.fdf.format(minDate) + " is not an lower-extreme when rounding as Date with CalendarField-value " + calendarField));
        Assertions.assertNotEquals((Object)this.januaryOneDate, (Object)DateUtils.round((Date)toNextRoundDate, (int)calendarField), (String)(this.fdf.format(maxDate) + " is not an upper-extreme when rounding as Date with CalendarField-value " + calendarField));
        Calendar toPrevRoundCalendar = Calendar.getInstance();
        toPrevRoundCalendar.setTime(toPrevRoundDate);
        Calendar toNextRoundCalendar = Calendar.getInstance();
        toNextRoundCalendar.setTime(toNextRoundDate);
        Assertions.assertNotEquals((Object)this.januaryOneDate, (Object)DateUtils.round((Date)toPrevRoundDate, (int)calendarField), (String)(this.fdf.format(minCalendar) + " is not an lower-extreme when rounding as Date with CalendarField-value " + calendarField));
        Assertions.assertNotEquals((Object)this.januaryOneDate, (Object)DateUtils.round((Date)toNextRoundDate, (int)calendarField), (String)(this.fdf.format(maxCalendar) + " is not an upper-extreme when rounding as Date with CalendarField-value " + calendarField));
    }
}

