/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BackgroundInitializerTest {
    private void checkInitialize(BackgroundInitializerTestImpl init) throws ConcurrentException {
        Integer result = (Integer)init.get();
        Assertions.assertEquals((int)1, (int)result, (String)"Wrong result");
        Assertions.assertEquals((int)1, (int)init.initializeCalls, (String)"Wrong number of invocations");
        Assertions.assertNotNull((Object)init.getFuture(), (String)"No future");
    }

    @Test
    public void testInitialize() throws ConcurrentException {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        this.checkInitialize(init);
    }

    @Test
    public void testGetActiveExecutorBeforeStart() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        Assertions.assertNull((Object)init.getActiveExecutor(), (String)"Got an executor");
    }

    @Test
    public void testGetActiveExecutorExternal() throws InterruptedException, ConcurrentException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl(exec);
            init.start();
            Assertions.assertSame((Object)exec, (Object)init.getActiveExecutor(), (String)"Wrong executor");
            this.checkInitialize(init);
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testGetActiveExecutorTemp() throws ConcurrentException {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        Assertions.assertNotNull((Object)init.getActiveExecutor(), (String)"No active executor");
        this.checkInitialize(init);
    }

    @Test
    public void testInitializeTempExecutor() throws ConcurrentException {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        Assertions.assertTrue((boolean)init.start(), (String)"Wrong result of start()");
        this.checkInitialize(init);
        Assertions.assertTrue((boolean)init.getActiveExecutor().isShutdown(), (String)"Executor not shutdown");
    }

    @Test
    public void testSetExternalExecutor() throws ConcurrentException {
        ExecutorService exec = Executors.newCachedThreadPool();
        try {
            BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
            init.setExternalExecutor(exec);
            Assertions.assertEquals((Object)exec, (Object)init.getExternalExecutor(), (String)"Wrong executor service");
            Assertions.assertTrue((boolean)init.start(), (String)"Wrong result of start()");
            Assertions.assertSame((Object)exec, (Object)init.getActiveExecutor(), (String)"Wrong active executor");
            this.checkInitialize(init);
            Assertions.assertFalse((boolean)exec.isShutdown(), (String)"Executor was shutdown");
        }
        finally {
            exec.shutdown();
        }
    }

    @Test
    public void testSetExternalExecutorAfterStart() throws ConcurrentException, InterruptedException {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            Assertions.assertThrows(IllegalStateException.class, () -> init.setExternalExecutor(exec));
            init.get();
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testStartMultipleTimes() throws ConcurrentException {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        Assertions.assertTrue((boolean)init.start(), (String)"Wrong result for start()");
        for (int i = 0; i < 10; ++i) {
            Assertions.assertFalse((boolean)init.start(), (String)"Could start again");
        }
        this.checkInitialize(init);
    }

    @Test
    public void testGetBeforeStart() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        Assertions.assertThrows(IllegalStateException.class, () -> ((BackgroundInitializerTestImpl)init).get());
    }

    @Test
    public void testGetRuntimeException() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        RuntimeException rex = new RuntimeException();
        init.ex = rex;
        init.start();
        Exception ex = (Exception)Assertions.assertThrows(Exception.class, () -> ((BackgroundInitializerTestImpl)init).get());
        Assertions.assertEquals((Object)rex, (Object)ex, (String)"Runtime exception not thrown");
    }

    @Test
    public void testGetCheckedException() {
        Exception ex;
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.ex = ex = new Exception();
        init.start();
        ConcurrentException cex = (ConcurrentException)Assertions.assertThrows(ConcurrentException.class, () -> ((BackgroundInitializerTestImpl)init).get());
        Assertions.assertEquals((Object)ex, (Object)cex.getCause(), (String)"Exception not thrown");
    }

    @Test
    public void testGetInterruptedException() throws InterruptedException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl(exec);
        final CountDownLatch latch1 = new CountDownLatch(1);
        init.shouldSleep = true;
        init.start();
        final AtomicReference iex = new AtomicReference();
        Thread getThread = new Thread(){

            @Override
            public void run() {
                try {
                    init.get();
                }
                catch (ConcurrentException cex) {
                    if (cex.getCause() instanceof InterruptedException) {
                        iex.set((InterruptedException)cex.getCause());
                    }
                }
                finally {
                    Assertions.assertTrue((boolean)this.isInterrupted(), (String)"Thread not interrupted");
                    latch1.countDown();
                }
            }
        };
        getThread.start();
        getThread.interrupt();
        latch1.await();
        exec.shutdownNow();
        exec.awaitTermination(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull(iex.get(), (String)"No interrupted exception");
    }

    @Test
    public void testIsStartedFalse() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        Assertions.assertFalse((boolean)init.isStarted(), (String)"Already started");
    }

    @Test
    public void testIsStartedTrue() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        Assertions.assertTrue((boolean)init.isStarted(), (String)"Not started");
    }

    @Test
    public void testIsStartedAfterGet() throws ConcurrentException {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        this.checkInitialize(init);
        Assertions.assertTrue((boolean)init.isStarted(), (String)"Not started");
    }

    private static class BackgroundInitializerTestImpl
    extends BackgroundInitializer<Integer> {
        Exception ex;
        boolean shouldSleep;
        volatile int initializeCalls;

        BackgroundInitializerTestImpl() {
        }

        BackgroundInitializerTestImpl(ExecutorService exec) {
            super(exec);
        }

        protected Integer initialize() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
            if (this.shouldSleep) {
                Thread.sleep(60000L);
            }
            return ++this.initializeCalls;
        }
    }
}

