/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.ConnectionPoolDataSourceProxy;
import org.apache.commons.dbcp2.datasources.KeyedCPDSConnectionFactory;
import org.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp2.datasources.PooledConnectionProxy;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.commons.dbcp2.datasources.UserPassKey;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;

public class TestKeyedCPDSConnectionFactory
extends TestCase {
    protected ConnectionPoolDataSourceProxy cpds = null;

    public TestKeyedCPDSConnectionFactory(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.cpds = new ConnectionPoolDataSourceProxy((ConnectionPoolDataSource)new DriverAdapterCPDS());
        DriverAdapterCPDS delegate = (DriverAdapterCPDS)this.cpds.getDelegate();
        delegate.setDriver("org.apache.commons.dbcp2.TesterDriver");
        delegate.setUrl("jdbc:apache:commons:testdriver");
        delegate.setUser("username");
        delegate.setPassword("password");
    }

    public void testSharedPoolDSDestroyOnReturn() throws Exception {
        SharedPoolDataSource ds = new SharedPoolDataSource();
        ds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.cpds);
        ds.setMaxTotal(10);
        ds.setDefaultMaxWaitMillis(50L);
        ds.setDefaultMaxIdle(2);
        Connection conn1 = ds.getConnection("username", "password");
        Connection conn2 = ds.getConnection("username", "password");
        Connection conn3 = ds.getConnection("username", "password");
        TestKeyedCPDSConnectionFactory.assertEquals((int)3, (int)ds.getNumActive());
        conn1.close();
        TestKeyedCPDSConnectionFactory.assertEquals((int)1, (int)ds.getNumIdle());
        conn2.close();
        TestKeyedCPDSConnectionFactory.assertEquals((int)2, (int)ds.getNumIdle());
        conn3.close();
        TestKeyedCPDSConnectionFactory.assertEquals((int)2, (int)ds.getNumIdle());
    }

    public void testConnectionErrorCleanup() throws Exception {
        UserPassKey key = new UserPassKey("username", "password");
        KeyedCPDSConnectionFactory factory = new KeyedCPDSConnectionFactory((ConnectionPoolDataSource)this.cpds, null, -1, false);
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)factory);
        factory.setPool((KeyedObjectPool)pool);
        PooledConnection pcon1 = ((PooledConnectionAndInfo)pool.borrowObject((Object)key)).getPooledConnection();
        Connection con1 = pcon1.getConnection();
        PooledConnection pcon2 = ((PooledConnectionAndInfo)pool.borrowObject((Object)key)).getPooledConnection();
        TestKeyedCPDSConnectionFactory.assertEquals((int)2, (int)pool.getNumActive((Object)key));
        TestKeyedCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumIdle((Object)key));
        PooledConnectionProxy pc = (PooledConnectionProxy)pcon1;
        TestKeyedCPDSConnectionFactory.assertTrue((boolean)pc.getListeners().contains(factory));
        pc.throwConnectionError();
        TestKeyedCPDSConnectionFactory.assertEquals((int)1, (int)pool.getNumActive((Object)key));
        TestKeyedCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumIdle((Object)key));
        pc.throwConnectionError();
        TestKeyedCPDSConnectionFactory.assertEquals((int)1, (int)pool.getNumActive((Object)key));
        TestKeyedCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumIdle((Object)key));
        PooledConnection pcon3 = ((PooledConnectionAndInfo)pool.borrowObject((Object)key)).getPooledConnection();
        TestKeyedCPDSConnectionFactory.assertTrue((!pcon3.equals(pcon1) ? 1 : 0) != 0);
        TestKeyedCPDSConnectionFactory.assertTrue((!pc.getListeners().contains(factory) ? 1 : 0) != 0);
        TestKeyedCPDSConnectionFactory.assertEquals((int)2, (int)pool.getNumActive((Object)key));
        TestKeyedCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumIdle((Object)key));
        pcon2.getConnection().close();
        pcon3.getConnection().close();
        TestKeyedCPDSConnectionFactory.assertEquals((int)2, (int)pool.getNumIdle((Object)key));
        TestKeyedCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumActive((Object)key));
        try {
            pc.getConnection();
            TestKeyedCPDSConnectionFactory.fail((String)"Expecting SQLException using closed PooledConnection");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        con1.close();
        TestKeyedCPDSConnectionFactory.assertEquals((int)2, (int)pool.getNumIdle((Object)key));
        TestKeyedCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumActive((Object)key));
        factory.getPool().clear();
        TestKeyedCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumIdle((Object)key));
    }
}

