/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class BlockLZ4CompressorInputStreamTest
extends AbstractTestCase {
    @Test
    public void readBlaLz4() throws IOException {
        try (BlockLZ4CompressorInputStream a = new BlockLZ4CompressorInputStream(Files.newInputStream(BlockLZ4CompressorInputStreamTest.getFile("bla.tar.block_lz4").toPath(), new OpenOption[0]));
             InputStream e = Files.newInputStream(BlockLZ4CompressorInputStreamTest.getFile("bla.tar").toPath(), new OpenOption[0]);){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = BlockLZ4CompressorInputStreamTest.getFile("bla.tar.block_lz4");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            BlockLZ4CompressorInputStream in = new BlockLZ4CompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = BlockLZ4CompressorInputStreamTest.getFile("bla.tar.block_lz4");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            BlockLZ4CompressorInputStream in = new BlockLZ4CompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }
}

