/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorOutputStream;
import org.apache.commons.compress.compressors.pack200.Pack200Strategy;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class Pack200TestCase
extends AbstractTestCase {
    @Test
    public void testJarUnarchiveAllInMemory() throws Exception {
        this.jarUnarchiveAll(false, Pack200Strategy.IN_MEMORY);
    }

    @Test
    public void testJarUnarchiveAllFileArgInMemory() throws Exception {
        this.jarUnarchiveAll(true, Pack200Strategy.IN_MEMORY);
    }

    @Test
    public void testJarUnarchiveAllTempFile() throws Exception {
        this.jarUnarchiveAll(false, Pack200Strategy.TEMP_FILE);
    }

    @Test
    public void testJarUnarchiveAllFileTempFile() throws Exception {
        this.jarUnarchiveAll(true, Pack200Strategy.TEMP_FILE);
    }

    private void jarUnarchiveAll(boolean useFile, Pack200Strategy mode) throws Exception {
        File input = Pack200TestCase.getFile("bla.pack");
        try (Pack200CompressorInputStream is = useFile ? new Pack200CompressorInputStream(input, mode) : new Pack200CompressorInputStream(Files.newInputStream(input.toPath(), new OpenOption[0]), mode);){
            ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", (InputStream)is);
            ArchiveEntry entry = in.getNextEntry();
            while (entry != null) {
                File archiveEntry = new File(this.dir, entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    entry = in.getNextEntry();
                    continue;
                }
                OutputStream out = Files.newOutputStream(archiveEntry.toPath(), new OpenOption[0]);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.close();
                entry = in.getNextEntry();
            }
            in.close();
        }
    }

    @Test
    public void testJarArchiveCreationInMemory() throws Exception {
        this.jarArchiveCreation(Pack200Strategy.IN_MEMORY);
    }

    @Test
    public void testJarArchiveCreationTempFile() throws Exception {
        this.jarArchiveCreation(Pack200Strategy.TEMP_FILE);
    }

    private void jarArchiveCreation(Pack200Strategy mode) throws Exception {
        File output = new File(this.dir, "bla.pack");
        File file1 = Pack200TestCase.getFile("test1.xml");
        File file2 = Pack200TestCase.getFile("test2.xml");
        try (Pack200CompressorOutputStream out = new Pack200CompressorOutputStream(Files.newOutputStream(output.toPath(), new OpenOption[0]), mode);){
            ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("jar", (OutputStream)out);
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test1.xml"));
            IOUtils.copy((InputStream)Files.newInputStream(file1.toPath(), new OpenOption[0]), (OutputStream)os);
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test2.xml"));
            IOUtils.copy((InputStream)Files.newInputStream(file2.toPath(), new OpenOption[0]), (OutputStream)os);
            os.closeArchiveEntry();
            os.close();
        }
        var6_6 = null;
        try (Pack200CompressorInputStream is = new Pack200CompressorInputStream(output);){
            ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", (InputStream)is);
            ArrayList<String> files = new ArrayList<String>();
            files.add("testdata/test1.xml");
            files.add("testdata/test2.xml");
            this.checkArchiveContent(in, files);
            in.close();
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testGoodSignature() throws Exception {
        try (InputStream is = Files.newInputStream(Pack200TestCase.getFile("bla.pack").toPath(), new OpenOption[0]);){
            byte[] sig = new byte[4];
            is.read(sig);
            Assert.assertTrue((boolean)Pack200CompressorInputStream.matches((byte[])sig, (int)4));
        }
    }

    @Test
    public void testBadSignature() throws Exception {
        try (InputStream is = Files.newInputStream(Pack200TestCase.getFile("bla.jar").toPath(), new OpenOption[0]);){
            byte[] sig = new byte[4];
            is.read(sig);
            Assert.assertFalse((boolean)Pack200CompressorInputStream.matches((byte[])sig, (int)4));
        }
    }

    @Test
    public void testShortSignature() throws Exception {
        try (InputStream is = Files.newInputStream(Pack200TestCase.getFile("bla.pack").toPath(), new OpenOption[0]);){
            byte[] sig = new byte[2];
            is.read(sig);
            Assert.assertFalse((boolean)Pack200CompressorInputStream.matches((byte[])sig, (int)2));
        }
    }

    @Test
    public void testInputStreamMethods() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("foo", "bar");
        try (Pack200CompressorInputStream is = new Pack200CompressorInputStream(Files.newInputStream(Pack200TestCase.getFile("bla.jar").toPath(), new OpenOption[0]), m);){
            Assert.assertTrue((boolean)is.markSupported());
            is.mark(5);
            Assert.assertEquals((long)80L, (long)is.read());
            byte[] rest = new byte[3];
            Assert.assertEquals((long)3L, (long)is.read(rest));
            Assert.assertEquals((long)75L, (long)rest[0]);
            Assert.assertEquals((long)3L, (long)rest[1]);
            Assert.assertEquals((long)4L, (long)rest[2]);
            Assert.assertEquals((long)1L, (long)is.skip(1L));
            is.reset();
            Assert.assertEquals((long)80L, (long)is.read());
            Assert.assertTrue((is.available() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOutputStreamMethods() throws Exception {
        File output = new File(this.dir, "bla.pack");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("foo", "bar");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            Pack200CompressorOutputStream os = new Pack200CompressorOutputStream(out, m);
            os.write(1);
            os.write(new byte[]{2, 3});
            os.close();
        }
    }

    @Test
    public void singleByteReadFromMemoryConsistentlyReturnsMinusOneAtEof() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(Pack200Strategy.IN_MEMORY);
    }

    @Test
    public void singleByteReadFromTempFileConsistentlyReturnsMinusOneAtEof() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(Pack200Strategy.TEMP_FILE);
    }

    private void singleByteReadConsistentlyReturnsMinusOneAtEof(Pack200Strategy s) throws Exception {
        File input = Pack200TestCase.getFile("bla.pack");
        try (Pack200CompressorInputStream in = new Pack200CompressorInputStream(input, s);){
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadFromMemoryConsistentlyReturnsMinusOneAtEof() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(Pack200Strategy.IN_MEMORY);
    }

    @Test
    public void multiByteReadFromTempFileConsistentlyReturnsMinusOneAtEof() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(Pack200Strategy.TEMP_FILE);
    }

    private void multiByteReadConsistentlyReturnsMinusOneAtEof(Pack200Strategy s) throws Exception {
        File input = Pack200TestCase.getFile("bla.pack");
        byte[] buf = new byte[2];
        try (Pack200CompressorInputStream in = new Pack200CompressorInputStream(input, s);){
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }
}

