/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.linq4j.tree;

import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Types;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Visitor;

public class IndexExpression
extends Expression {
    public final Expression array;
    public final List<Expression> indexExpressions;

    public IndexExpression(Expression array, List<Expression> indexExpressions) {
        super(ExpressionType.ArrayIndex, Types.getComponentType(array.getType()));
        assert (array != null) : "array should not be null";
        assert (indexExpressions != null) : "indexExpressions should not be null";
        assert (!indexExpressions.isEmpty()) : "indexExpressions should not be empty";
        this.array = array;
        this.indexExpressions = indexExpressions;
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression array = this.array.accept(shuttle);
        List<Expression> indexExpressions = Expressions.acceptExpressions(this.indexExpressions, shuttle);
        return shuttle.visit(this, array, indexExpressions);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        this.array.accept(writer, lprec, this.nodeType.lprec);
        writer.list("[", ", ", "]", this.indexExpressions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexExpression that = (IndexExpression)o;
        if (!this.array.equals(that.array)) {
            return false;
        }
        return this.indexExpressions.equals(that.indexExpressions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.array, this.indexExpressions});
    }
}

