/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;

public class DirectOperatorConversion
implements DruidSqlOperatorConverter {
    private final SqlOperator operator;
    private final String druidFunctionName;

    public DirectOperatorConversion(SqlOperator operator, String druidFunctionName) {
        this.operator = operator;
        this.druidFunctionName = druidFunctionName;
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        RexCall call = (RexCall)rexNode;
        List<String> druidExpressions = DruidExpressions.toDruidExpressions(druidQuery, rowType, call.getOperands());
        if (druidExpressions == null) {
            return null;
        }
        return DruidExpressions.functionCall(this.druidFunctionName, druidExpressions);
    }
}

