/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorUtil;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregator;
import org.apache.hive.druid.io.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.column.Column;

public abstract class SimpleDoubleAggregatorFactory
extends AggregatorFactory {
    protected final String name;
    protected final String fieldName;
    protected final String expression;
    protected final ExprMacroTable macroTable;
    protected final boolean storeDoubleAsFloat;

    public SimpleDoubleAggregatorFactory(ExprMacroTable macroTable, String fieldName, String name, String expression) {
        this.macroTable = macroTable;
        this.fieldName = fieldName;
        this.name = name;
        this.expression = expression;
        this.storeDoubleAsFloat = Column.storeDoubleAsFloat();
        Preconditions.checkNotNull(name, "Must have a valid, non-null aggregator name");
        Preconditions.checkArgument(fieldName == null ^ expression == null, "Must have a valid, non-null fieldName or expression");
    }

    protected BaseDoubleColumnValueSelector getDoubleColumnSelector(ColumnSelectorFactory metricFactory, double nullValue) {
        return AggregatorUtil.makeColumnValueSelectorWithDoubleDefault(metricFactory, this.macroTable, this.fieldName, this.expression, nullValue);
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return object;
    }

    @Override
    public String getTypeName() {
        if (this.storeDoubleAsFloat) {
            return "float";
        }
        return "double";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.expression, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDoubleAggregatorFactory that = (SimpleDoubleAggregatorFactory)o;
        if (!Objects.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        if (!Objects.equals(this.expression, that.expression)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    @Override
    public Comparator getComparator() {
        return DoubleSumAggregator.COMPARATOR;
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public List<String> requiredFields() {
        return this.fieldName != null ? Collections.singletonList(this.fieldName) : Parser.findRequiredBindings(Parser.parse(this.expression, this.macroTable));
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }
}

