/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.math.expr;

import java.util.List;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.math.expr.BinEqExpr;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.ExprType;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

interface Function {
    public String name();

    public ExprEval apply(List<Expr> var1, Expr.ObjectBinding var2);

    public static class UpperFunc
    implements Function {
        @Override
        public String name() {
            return "upper";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() != 1) {
                throw new IAE("Function[%s] needs 1 argument", this.name());
            }
            String arg = args.get(0).eval(bindings).asString();
            return ExprEval.of(StringUtils.toUpperCase(Strings.nullToEmpty(arg)));
        }
    }

    public static class LowerFunc
    implements Function {
        @Override
        public String name() {
            return "lower";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() != 1) {
                throw new IAE("Function[%s] needs 1 argument", this.name());
            }
            String arg = args.get(0).eval(bindings).asString();
            return ExprEval.of(StringUtils.toLowerCase(Strings.nullToEmpty(arg)));
        }
    }

    public static class ReplaceFunc
    implements Function {
        @Override
        public String name() {
            return "replace";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() != 3) {
                throw new IAE("Function[%s] needs 3 arguments", this.name());
            }
            String arg = args.get(0).eval(bindings).asString();
            String pattern = args.get(1).eval(bindings).asString();
            String replacement = args.get(2).eval(bindings).asString();
            return ExprEval.of(Strings.nullToEmpty(arg).replace(Strings.nullToEmpty(pattern), Strings.nullToEmpty(replacement)));
        }
    }

    public static class SubstringFunc
    implements Function {
        @Override
        public String name() {
            return "substring";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() != 3) {
                throw new IAE("Function[%s] needs 3 arguments", this.name());
            }
            String arg = args.get(0).eval(bindings).asString();
            if (arg == null) {
                return ExprEval.of(null);
            }
            int index = args.get(1).eval(bindings).asInt();
            int length = args.get(2).eval(bindings).asInt();
            if (index < arg.length()) {
                if (length >= 0) {
                    return ExprEval.of(arg.substring(index, Math.min(index + length, arg.length())));
                }
                return ExprEval.of(arg.substring(index));
            }
            return ExprEval.of(null);
        }
    }

    public static class StrposFunc
    implements Function {
        @Override
        public String name() {
            return "strpos";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() != 2) {
                throw new IAE("Function[%s] needs 2 arguments", this.name());
            }
            String haystack = Strings.nullToEmpty(args.get(0).eval(bindings).asString());
            String needle = Strings.nullToEmpty(args.get(1).eval(bindings).asString());
            return ExprEval.of(haystack.indexOf(needle));
        }
    }

    public static class StrlenFunc
    implements Function {
        @Override
        public String name() {
            return "strlen";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() != 1) {
                throw new IAE("Function[%s] needs 1 argument", this.name());
            }
            String arg = args.get(0).eval(bindings).asString();
            return arg == null ? ExprEval.of(0L) : ExprEval.of(arg.length());
        }
    }

    public static class ConcatFunc
    implements Function {
        @Override
        public String name() {
            return "concat";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() == 0) {
                return ExprEval.of(null);
            }
            StringBuilder builder = new StringBuilder(Strings.nullToEmpty(args.get(0).eval(bindings).asString()));
            for (int i = 1; i < args.size(); ++i) {
                String s = args.get(i).eval(bindings).asString();
                if (s == null) continue;
                builder.append(s);
            }
            return ExprEval.of(builder.toString());
        }
    }

    public static class NvlFunc
    implements Function {
        @Override
        public String name() {
            return "nvl";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() != 2) {
                throw new IAE("Function[%s] needs 2 arguments", this.name());
            }
            ExprEval eval = args.get(0).eval(bindings);
            return eval.isNull() ? args.get(1).eval(bindings) : eval;
        }
    }

    public static class UnixTimestampFunc
    extends TimestampFromEpochFunc {
        @Override
        public String name() {
            return "unix_timestamp";
        }

        @Override
        protected final ExprEval toValue(DateTime date) {
            return ExprEval.of(date.getMillis() / 1000L);
        }
    }

    public static class TimestampFromEpochFunc
    implements Function {
        @Override
        public String name() {
            return "timestamp";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            DateTime date;
            if (args.size() != 1 && args.size() != 2) {
                throw new IAE("Function[%s] needs 1 or 2 arguments", this.name());
            }
            ExprEval value = args.get(0).eval(bindings);
            if (value.type() != ExprType.STRING) {
                throw new IAE("first argument should be string type but got %s type", new Object[]{value.type()});
            }
            DateTimes.UtcFormatter formatter = DateTimes.ISO_DATE_OPTIONAL_TIME;
            if (args.size() > 1) {
                ExprEval format = args.get(1).eval(bindings);
                if (format.type() != ExprType.STRING) {
                    throw new IAE("second argument should be string type but got %s type", new Object[]{format.type()});
                }
                formatter = DateTimes.wrapFormatter(DateTimeFormat.forPattern((String)format.asString()));
            }
            try {
                date = formatter.parse(value.asString());
            }
            catch (IllegalArgumentException e) {
                throw new IAE(e, "invalid value %s", value.asString());
            }
            return this.toValue(date);
        }

        protected ExprEval toValue(DateTime date) {
            return ExprEval.of(date.getMillis());
        }
    }

    public static class CastFunc
    extends DoubleParam {
        @Override
        public String name() {
            return "cast";
        }

        @Override
        protected ExprEval eval(ExprEval x, ExprEval y) {
            ExprType castTo;
            try {
                castTo = ExprType.valueOf(StringUtils.toUpperCase(y.asString()));
            }
            catch (IllegalArgumentException e) {
                throw new IAE("invalid type '%s'", y.asString());
            }
            return x.castTo(castTo);
        }
    }

    public static class CaseSimpleFunc
    implements Function {
        @Override
        public String name() {
            return "case_simple";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() < 3) {
                throw new IAE("Function[%s] must have at least 3 arguments", this.name());
            }
            for (int i = 1; i < args.size(); i += 2) {
                if (i == args.size() - 1) {
                    return args.get(i).eval(bindings);
                }
                if (!new BinEqExpr("==", args.get(0), args.get(i)).eval(bindings).asBoolean()) continue;
                return args.get(i + 1).eval(bindings);
            }
            return ExprEval.of(null);
        }
    }

    public static class CaseSearchedFunc
    implements Function {
        @Override
        public String name() {
            return "case_searched";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() < 2) {
                throw new IAE("Function[%s] must have at least 2 arguments", this.name());
            }
            for (int i = 0; i < args.size(); i += 2) {
                if (i == args.size() - 1) {
                    return args.get(i).eval(bindings);
                }
                if (!args.get(i).eval(bindings).asBoolean()) continue;
                return args.get(i + 1).eval(bindings);
            }
            return ExprEval.of(null);
        }
    }

    public static class ConditionFunc
    implements Function {
        @Override
        public String name() {
            return "if";
        }

        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() != 3) {
                throw new IAE("Function[%s] needs 3 arguments", this.name());
            }
            ExprEval x = args.get(0).eval(bindings);
            return x.asBoolean() ? args.get(1).eval(bindings) : args.get(2).eval(bindings);
        }
    }

    public static class Scalb
    extends DoubleParam {
        @Override
        public String name() {
            return "scalb";
        }

        @Override
        protected ExprEval eval(ExprEval x, ExprEval y) {
            return ExprEval.of(Math.scalb(x.asDouble(), y.asInt()));
        }
    }

    public static class Pow
    extends DoubleParamMath {
        @Override
        public String name() {
            return "pow";
        }

        @Override
        protected ExprEval eval(double x, double y) {
            return ExprEval.of(Math.pow(x, y));
        }
    }

    public static class NextAfter
    extends DoubleParamMath {
        @Override
        public String name() {
            return "nextAfter";
        }

        @Override
        protected ExprEval eval(double x, double y) {
            return ExprEval.of(Math.nextAfter(x, y));
        }
    }

    public static class Min
    extends DoubleParamMath {
        @Override
        public String name() {
            return "min";
        }

        @Override
        protected ExprEval eval(long x, long y) {
            return ExprEval.of(Math.min(x, y));
        }

        @Override
        protected ExprEval eval(double x, double y) {
            return ExprEval.of(Math.min(x, y));
        }
    }

    public static class Max
    extends DoubleParamMath {
        @Override
        public String name() {
            return "max";
        }

        @Override
        protected ExprEval eval(long x, long y) {
            return ExprEval.of(Math.max(x, y));
        }

        @Override
        protected ExprEval eval(double x, double y) {
            return ExprEval.of(Math.max(x, y));
        }
    }

    public static class Remainder
    extends DoubleParamMath {
        @Override
        public String name() {
            return "remainder";
        }

        @Override
        protected ExprEval eval(double x, double y) {
            return ExprEval.of(Math.IEEEremainder(x, y));
        }
    }

    public static class Hypot
    extends DoubleParamMath {
        @Override
        public String name() {
            return "hypot";
        }

        @Override
        protected ExprEval eval(double x, double y) {
            return ExprEval.of(Math.hypot(x, y));
        }
    }

    public static class CopySign
    extends DoubleParamMath {
        @Override
        public String name() {
            return "copySign";
        }

        @Override
        protected ExprEval eval(double x, double y) {
            return ExprEval.of(Math.copySign(x, y));
        }
    }

    public static class Atan2
    extends DoubleParamMath {
        @Override
        public String name() {
            return "atan2";
        }

        @Override
        protected ExprEval eval(double y, double x) {
            return ExprEval.of(Math.atan2(y, x));
        }
    }

    public static class Ulp
    extends SingleParamMath {
        @Override
        public String name() {
            return "ulp";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.ulp(param));
        }
    }

    public static class ToRadians
    extends SingleParamMath {
        @Override
        public String name() {
            return "toRadians";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.toRadians(param));
        }
    }

    public static class ToDegrees
    extends SingleParamMath {
        @Override
        public String name() {
            return "toDegrees";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.toDegrees(param));
        }
    }

    public static class Tanh
    extends SingleParamMath {
        @Override
        public String name() {
            return "tanh";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.tanh(param));
        }
    }

    public static class Tan
    extends SingleParamMath {
        @Override
        public String name() {
            return "tan";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.tan(param));
        }
    }

    public static class Sqrt
    extends SingleParamMath {
        @Override
        public String name() {
            return "sqrt";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.sqrt(param));
        }
    }

    public static class Sinh
    extends SingleParamMath {
        @Override
        public String name() {
            return "sinh";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.sinh(param));
        }
    }

    public static class Sin
    extends SingleParamMath {
        @Override
        public String name() {
            return "sin";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.sin(param));
        }
    }

    public static class Signum
    extends SingleParamMath {
        @Override
        public String name() {
            return "signum";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.signum(param));
        }
    }

    public static class Round
    extends SingleParamMath {
        @Override
        public String name() {
            return "round";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.round(param));
        }
    }

    public static class Rint
    extends SingleParamMath {
        @Override
        public String name() {
            return "rint";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.rint(param));
        }
    }

    public static class NextUp
    extends SingleParamMath {
        @Override
        public String name() {
            return "nextUp";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.nextUp(param));
        }
    }

    public static class Log1p
    extends SingleParamMath {
        @Override
        public String name() {
            return "log1p";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.log1p(param));
        }
    }

    public static class Log10
    extends SingleParamMath {
        @Override
        public String name() {
            return "log10";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.log10(param));
        }
    }

    public static class Log
    extends SingleParamMath {
        @Override
        public String name() {
            return "log";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.log(param));
        }
    }

    public static class GetExponent
    extends SingleParamMath {
        @Override
        public String name() {
            return "getExponent";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.getExponent(param));
        }
    }

    public static class Floor
    extends SingleParamMath {
        @Override
        public String name() {
            return "floor";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.floor(param));
        }
    }

    public static class Expm1
    extends SingleParamMath {
        @Override
        public String name() {
            return "expm1";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.expm1(param));
        }
    }

    public static class Exp
    extends SingleParamMath {
        @Override
        public String name() {
            return "exp";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.exp(param));
        }
    }

    public static class Div
    extends DoubleParamMath {
        @Override
        public String name() {
            return "div";
        }

        @Override
        protected ExprEval eval(long x, long y) {
            return ExprEval.of(x / y);
        }

        @Override
        protected ExprEval eval(double x, double y) {
            return ExprEval.of((long)(x / y));
        }
    }

    public static class Cosh
    extends SingleParamMath {
        @Override
        public String name() {
            return "cosh";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.cosh(param));
        }
    }

    public static class Cos
    extends SingleParamMath {
        @Override
        public String name() {
            return "cos";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.cos(param));
        }
    }

    public static class Ceil
    extends SingleParamMath {
        @Override
        public String name() {
            return "ceil";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.ceil(param));
        }
    }

    public static class Cbrt
    extends SingleParamMath {
        @Override
        public String name() {
            return "cbrt";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.cbrt(param));
        }
    }

    public static class Atan
    extends SingleParamMath {
        @Override
        public String name() {
            return "atan";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.atan(param));
        }
    }

    public static class Asin
    extends SingleParamMath {
        @Override
        public String name() {
            return "asin";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.asin(param));
        }
    }

    public static class Acos
    extends SingleParamMath {
        @Override
        public String name() {
            return "acos";
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.acos(param));
        }
    }

    public static class Abs
    extends SingleParamMath {
        @Override
        public String name() {
            return "abs";
        }

        @Override
        protected ExprEval eval(long param) {
            return ExprEval.of(Math.abs(param));
        }

        @Override
        protected ExprEval eval(double param) {
            return ExprEval.of(Math.abs(param));
        }
    }

    public static abstract class DoubleParamMath
    extends DoubleParam {
        @Override
        protected final ExprEval eval(ExprEval x, ExprEval y) {
            if (x.type() == ExprType.STRING || y.type() == ExprType.STRING) {
                return ExprEval.of(null);
            }
            if (x.type() == ExprType.LONG && y.type() == ExprType.LONG) {
                return this.eval(x.asLong(), y.asLong());
            }
            return this.eval(x.asDouble(), y.asDouble());
        }

        protected ExprEval eval(long x, long y) {
            return this.eval((double)x, (double)y);
        }

        protected ExprEval eval(double x, double y) {
            return this.eval((long)x, (long)y);
        }
    }

    public static abstract class SingleParamMath
    extends SingleParam {
        @Override
        protected final ExprEval eval(ExprEval param) {
            if (param.type() == ExprType.LONG) {
                return this.eval(param.asLong());
            }
            if (param.type() == ExprType.DOUBLE) {
                return this.eval(param.asDouble());
            }
            return ExprEval.of(null);
        }

        protected ExprEval eval(long param) {
            return this.eval((double)param);
        }

        protected ExprEval eval(double param) {
            return this.eval((long)param);
        }
    }

    public static abstract class DoubleParam
    implements Function {
        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() != 2) {
                throw new IAE("Function[%s] needs 2 arguments", this.name());
            }
            Expr expr1 = args.get(0);
            Expr expr2 = args.get(1);
            return this.eval(expr1.eval(bindings), expr2.eval(bindings));
        }

        protected abstract ExprEval eval(ExprEval var1, ExprEval var2);
    }

    public static abstract class SingleParam
    implements Function {
        @Override
        public ExprEval apply(List<Expr> args, Expr.ObjectBinding bindings) {
            if (args.size() != 1) {
                throw new IAE("Function[%s] needs 1 argument", this.name());
            }
            Expr expr = args.get(0);
            return this.eval(expr.eval(bindings));
        }

        protected abstract ExprEval eval(ExprEval var1);
    }
}

