/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.json;

import java.io.File;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Period;

public class KafkaTuningConfig
implements AppenderatorConfig {
    private static final int DEFAULT_MAX_ROWS_PER_SEGMENT = 5000000;
    private static final boolean DEFAULT_RESET_OFFSET_AUTOMATICALLY = false;
    private final int maxRowsInMemory;
    private final int maxRowsPerSegment;
    private final Period intermediatePersistPeriod;
    private final File basePersistDirectory;
    private final int maxPendingPersists;
    private final IndexSpec indexSpec;
    private final boolean reportParseExceptions;
    @Deprecated
    private final long handoffConditionTimeout;
    private final boolean resetOffsetAutomatically;

    @JsonCreator
    public KafkaTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxRowsPerSegment") Integer maxRowsPerSegment, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="resetOffsetAutomatically") Boolean resetOffsetAutomatically) {
        RealtimeTuningConfig defaults = RealtimeTuningConfig.makeDefaultTuningConfig(basePersistDirectory);
        this.maxRowsInMemory = maxRowsInMemory == null ? defaults.getMaxRowsInMemory() : maxRowsInMemory.intValue();
        this.maxRowsPerSegment = maxRowsPerSegment == null ? 5000000 : maxRowsPerSegment;
        this.intermediatePersistPeriod = intermediatePersistPeriod == null ? defaults.getIntermediatePersistPeriod() : intermediatePersistPeriod;
        this.basePersistDirectory = defaults.getBasePersistDirectory();
        this.maxPendingPersists = maxPendingPersists == null ? defaults.getMaxPendingPersists() : maxPendingPersists.intValue();
        this.indexSpec = indexSpec == null ? defaults.getIndexSpec() : indexSpec;
        this.reportParseExceptions = reportParseExceptions == null ? defaults.isReportParseExceptions() : reportParseExceptions.booleanValue();
        this.handoffConditionTimeout = handoffConditionTimeout == null ? defaults.getHandoffConditionTimeout() : handoffConditionTimeout.longValue();
        this.resetOffsetAutomatically = resetOffsetAutomatically == null ? false : resetOffsetAutomatically;
    }

    public static KafkaTuningConfig copyOf(KafkaTuningConfig config) {
        return new KafkaTuningConfig(config.maxRowsInMemory, config.maxRowsPerSegment, config.intermediatePersistPeriod, config.basePersistDirectory, config.maxPendingPersists, config.indexSpec, true, config.reportParseExceptions, config.handoffConditionTimeout, config.resetOffsetAutomatically);
    }

    @Override
    @JsonProperty
    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @JsonProperty
    public int getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @Override
    @JsonProperty
    public Period getIntermediatePersistPeriod() {
        return this.intermediatePersistPeriod;
    }

    @Override
    @JsonProperty
    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    @Override
    @Nullable
    public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
        return null;
    }

    @Override
    @JsonProperty
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @Override
    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @Deprecated
    @JsonProperty
    public boolean getBuildV9Directly() {
        return true;
    }

    @Override
    @JsonProperty
    public boolean isReportParseExceptions() {
        return this.reportParseExceptions;
    }

    @Deprecated
    @JsonProperty
    public long getHandoffConditionTimeout() {
        return this.handoffConditionTimeout;
    }

    @JsonProperty
    public boolean isResetOffsetAutomatically() {
        return this.resetOffsetAutomatically;
    }

    public KafkaTuningConfig withBasePersistDirectory(File dir) {
        return new KafkaTuningConfig(this.maxRowsInMemory, this.maxRowsPerSegment, this.intermediatePersistPeriod, dir, this.maxPendingPersists, this.indexSpec, true, this.reportParseExceptions, this.handoffConditionTimeout, this.resetOffsetAutomatically);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaTuningConfig that = (KafkaTuningConfig)o;
        if (this.maxRowsInMemory != that.maxRowsInMemory) {
            return false;
        }
        if (this.maxRowsPerSegment != that.maxRowsPerSegment) {
            return false;
        }
        if (this.maxPendingPersists != that.maxPendingPersists) {
            return false;
        }
        if (this.reportParseExceptions != that.reportParseExceptions) {
            return false;
        }
        if (this.handoffConditionTimeout != that.handoffConditionTimeout) {
            return false;
        }
        if (this.resetOffsetAutomatically != that.resetOffsetAutomatically) {
            return false;
        }
        if (this.intermediatePersistPeriod != null ? !this.intermediatePersistPeriod.equals((Object)that.intermediatePersistPeriod) : that.intermediatePersistPeriod != null) {
            return false;
        }
        if (this.basePersistDirectory != null ? !this.basePersistDirectory.equals(that.basePersistDirectory) : that.basePersistDirectory != null) {
            return false;
        }
        return this.indexSpec != null ? this.indexSpec.equals(that.indexSpec) : that.indexSpec == null;
    }

    public int hashCode() {
        int result = this.maxRowsInMemory;
        result = 31 * result + this.maxRowsPerSegment;
        result = 31 * result + (this.intermediatePersistPeriod != null ? this.intermediatePersistPeriod.hashCode() : 0);
        result = 31 * result + (this.basePersistDirectory != null ? this.basePersistDirectory.hashCode() : 0);
        result = 31 * result + this.maxPendingPersists;
        result = 31 * result + (this.indexSpec != null ? this.indexSpec.hashCode() : 0);
        result = 31 * result + (this.reportParseExceptions ? 1 : 0);
        result = 31 * result + (int)(this.handoffConditionTimeout ^ this.handoffConditionTimeout >>> 32);
        result = 31 * result + (this.resetOffsetAutomatically ? 1 : 0);
        return result;
    }

    public String toString() {
        return "KafkaTuningConfig{maxRowsInMemory=" + this.maxRowsInMemory + ", maxRowsPerSegment=" + this.maxRowsPerSegment + ", intermediatePersistPeriod=" + this.intermediatePersistPeriod + ", basePersistDirectory=" + this.basePersistDirectory + ", maxPendingPersists=" + this.maxPendingPersists + ", indexSpec=" + this.indexSpec + ", reportParseExceptions=" + this.reportParseExceptions + ", handoffConditionTimeout=" + this.handoffConditionTimeout + ", resetOffsetAutomatically=" + this.resetOffsetAutomatically + "}";
    }
}

