/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.CorrelationId;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rex.LogicVisitor;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexShuttle;
import org.apache.hive.druid.org.apache.calcite.rex.RexSubQuery;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.Pair;

public abstract class SubQueryRemoveRule
extends RelOptRule {
    public static final SubQueryRemoveRule PROJECT = new SubQueryRemoveRule(SubQueryRemoveRule.operand(Project.class, null, RexUtil.SubQueryFinder.PROJECT_PREDICATE, SubQueryRemoveRule.any()), RelFactories.LOGICAL_BUILDER, "SubQueryRemoveRule:Project"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            RelBuilder builder = call.builder();
            RexSubQuery e = RexUtil.SubQueryFinder.find(project.getProjects());
            assert (e != null);
            RelOptUtil.Logic logic = LogicVisitor.find(RelOptUtil.Logic.TRUE_FALSE_UNKNOWN, project.getProjects(), e);
            builder.push(project.getInput());
            int fieldCount = builder.peek().getRowType().getFieldCount();
            RexNode target = this.apply(e, ImmutableSet.of(), logic, builder, 1, fieldCount);
            ReplaceSubQueryShuttle shuttle = new ReplaceSubQueryShuttle(e, target);
            builder.project(shuttle.apply(project.getProjects()), project.getRowType().getFieldNames());
            call.transformTo(builder.build());
        }
    };
    public static final SubQueryRemoveRule FILTER = new SubQueryRemoveRule(SubQueryRemoveRule.operand(Filter.class, null, RexUtil.SubQueryFinder.FILTER_PREDICATE, SubQueryRemoveRule.any()), RelFactories.LOGICAL_BUILDER, "SubQueryRemoveRule:Filter"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            RelBuilder builder = call.builder();
            RexSubQuery e = RexUtil.SubQueryFinder.find(filter.getCondition());
            assert (e != null);
            RelOptUtil.Logic logic = LogicVisitor.find(RelOptUtil.Logic.TRUE, ImmutableList.of(filter.getCondition()), e);
            builder.push(filter.getInput());
            int fieldCount = builder.peek().getRowType().getFieldCount();
            RexNode target = this.apply(e, filter.getVariablesSet(), logic, builder, 1, fieldCount);
            ReplaceSubQueryShuttle shuttle = new ReplaceSubQueryShuttle(e, target);
            builder.filter(shuttle.apply(filter.getCondition()));
            builder.project(SubQueryRemoveRule.fields(builder, filter.getRowType().getFieldCount()));
            call.transformTo(builder.build());
        }
    };
    public static final SubQueryRemoveRule JOIN = new SubQueryRemoveRule(SubQueryRemoveRule.operand(Join.class, null, RexUtil.SubQueryFinder.JOIN_PREDICATE, SubQueryRemoveRule.any()), RelFactories.LOGICAL_BUILDER, "SubQueryRemoveRule:Join"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            RelBuilder builder = call.builder();
            RexSubQuery e = RexUtil.SubQueryFinder.find(join.getCondition());
            assert (e != null);
            RelOptUtil.Logic logic = LogicVisitor.find(RelOptUtil.Logic.TRUE, ImmutableList.of(join.getCondition()), e);
            builder.push(join.getLeft());
            builder.push(join.getRight());
            int fieldCount = join.getRowType().getFieldCount();
            RexNode target = this.apply(e, ImmutableSet.of(), logic, builder, 2, fieldCount);
            ReplaceSubQueryShuttle shuttle = new ReplaceSubQueryShuttle(e, target);
            builder.join(join.getJoinType(), shuttle.apply(join.getCondition()));
            builder.project(SubQueryRemoveRule.fields(builder, join.getRowType().getFieldCount()));
            call.transformTo(builder.build());
        }
    };

    private SubQueryRemoveRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    protected RexNode apply(RexSubQuery e, Set<CorrelationId> variablesSet, RelOptUtil.Logic logic, RelBuilder builder, int inputCount, int offset) {
        switch (e.getKind()) {
            case SCALAR_QUERY: {
                builder.push(e.rel);
                RelMetadataQuery mq = RelMetadataQuery.instance();
                Boolean unique = mq.areColumnsUnique(builder.peek(), ImmutableBitSet.of());
                if (unique == null || !unique.booleanValue()) {
                    builder.aggregate(builder.groupKey(), builder.aggregateCall(SqlStdOperatorTable.SINGLE_VALUE, false, null, null, builder.field(0)));
                }
                builder.join(JoinRelType.LEFT, builder.literal(true), variablesSet);
                return this.field(builder, inputCount, offset);
            }
            case IN: 
            case EXISTS: {
                builder.push(e.rel);
                ArrayList<RexNode> fields = new ArrayList<RexNode>();
                switch (e.getKind()) {
                    case IN: {
                        fields.addAll(builder.fields());
                    }
                }
                switch (logic) {
                    case TRUE_FALSE_UNKNOWN: 
                    case UNKNOWN_AS_TRUE: {
                        if (!variablesSet.isEmpty()) {
                            logic = RelOptUtil.Logic.TRUE_FALSE;
                            break;
                        }
                        builder.aggregate(builder.groupKey(), builder.count(false, "c", new RexNode[0]), builder.aggregateCall(SqlStdOperatorTable.COUNT, false, null, "ck", builder.fields()));
                        builder.as("ct");
                        builder.join(JoinRelType.INNER, builder.literal(true), variablesSet);
                        offset += 2;
                        builder.push(e.rel);
                    }
                }
                switch (logic) {
                    case TRUE: {
                        if (fields.isEmpty()) {
                            builder.project(builder.alias(builder.literal(true), "i"));
                            builder.aggregate(builder.groupKey(0), new RelBuilder.AggCall[0]);
                            break;
                        }
                        builder.aggregate(builder.groupKey(fields), new RelBuilder.AggCall[0]);
                        break;
                    }
                    default: {
                        fields.add(builder.alias(builder.literal(true), "i"));
                        builder.project(fields);
                        builder.distinct();
                    }
                }
                builder.as("dt");
                ArrayList<RexNode> conditions = new ArrayList<RexNode>();
                for (Pair<RexNode, RexNode> pair : Pair.zip(e.getOperands(), builder.fields())) {
                    conditions.add(builder.equals((RexNode)pair.left, RexUtil.shift((RexNode)pair.right, offset)));
                }
                switch (logic) {
                    case TRUE: {
                        builder.join(JoinRelType.INNER, builder.and(conditions), variablesSet);
                        return builder.literal(true);
                    }
                }
                builder.join(JoinRelType.LEFT, builder.and(conditions), variablesSet);
                ArrayList<RexNode> keyIsNulls = new ArrayList<RexNode>();
                for (RexNode operand : e.getOperands()) {
                    if (!operand.getType().isNullable()) continue;
                    keyIsNulls.add(builder.isNull(operand));
                }
                ImmutableList.Builder builder2 = ImmutableList.builder();
                switch (logic) {
                    case TRUE_FALSE_UNKNOWN: 
                    case UNKNOWN_AS_TRUE: {
                        builder2.add(new RexNode[]{builder.equals(builder.field("ct", "c"), builder.literal(0)), builder.literal(false)});
                    }
                }
                builder2.add(new RexNode[]{builder.isNotNull(builder.field("dt", "i")), builder.literal(true)});
                if (!keyIsNulls.isEmpty()) {
                    builder2.add(new RexNode[]{builder.or(keyIsNulls), builder.literal(null)});
                }
                Boolean b = true;
                switch (logic) {
                    case TRUE_FALSE_UNKNOWN: {
                        b = null;
                    }
                    case UNKNOWN_AS_TRUE: {
                        builder2.add(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.LESS_THAN, builder.field("ct", "ck"), builder.field("ct", "c")), builder.literal(b)});
                    }
                }
                builder2.add(builder.literal(false));
                return builder.call((SqlOperator)SqlStdOperatorTable.CASE, builder2.build());
            }
        }
        throw new AssertionError((Object)e.getKind());
    }

    private RexInputRef field(RelBuilder builder, int inputCount, int offset) {
        int inputOrdinal = 0;
        RelNode r;
        while (offset >= (r = builder.peek(inputCount, inputOrdinal)).getRowType().getFieldCount()) {
            ++inputOrdinal;
            offset -= r.getRowType().getFieldCount();
        }
        return builder.field(inputCount, inputOrdinal, offset);
    }

    private static List<RexNode> fields(RelBuilder builder, int fieldCount) {
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (int i = 0; i < fieldCount; ++i) {
            projects.add(builder.field(i));
        }
        return projects;
    }

    private static class ReplaceSubQueryShuttle
    extends RexShuttle {
        private final RexSubQuery subQuery;
        private final RexNode replacement;

        public ReplaceSubQueryShuttle(RexSubQuery subQuery, RexNode replacement) {
            this.subQuery = subQuery;
            this.replacement = replacement;
        }

        @Override
        public RexNode visitSubQuery(RexSubQuery subQuery) {
            return RexUtil.eq(subQuery, this.subQuery) ? this.replacement : subQuery;
        }
    }
}

