/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexOver;
import org.apache.hive.druid.org.apache.calcite.rex.RexProgram;
import org.apache.hive.druid.org.apache.calcite.rex.RexProgramBuilder;
import org.apache.hive.druid.org.apache.calcite.util.Pair;

public class ProjectCalcMergeRule
extends RelOptRule {
    public static final ProjectCalcMergeRule INSTANCE = new ProjectCalcMergeRule();

    private ProjectCalcMergeRule() {
        super(ProjectCalcMergeRule.operand(LogicalProject.class, ProjectCalcMergeRule.operand(LogicalCalc.class, ProjectCalcMergeRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        LogicalCalc calc = (LogicalCalc)call.rel(1);
        RelOptCluster cluster = project.getCluster();
        RexProgram program = RexProgram.create(calc.getRowType(), project.getProjects(), null, project.getRowType(), cluster.getRexBuilder());
        if (RexOver.containsOver(program)) {
            LogicalCalc projectAsCalc = LogicalCalc.create(calc, program);
            call.transformTo(projectAsCalc);
            return;
        }
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexProgramBuilder progBuilder = new RexProgramBuilder(calc.getRowType(), rexBuilder);
        for (Pair<RexNode, String> field : project.getNamedProjects()) {
            progBuilder.addProject((RexNode)field.left, (String)field.right);
        }
        RexProgram topProgram = progBuilder.getProgram();
        RexProgram bottomProgram = calc.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        LogicalCalc newCalc = LogicalCalc.create(calc.getInput(), mergedProgram);
        call.transformTo(newCalc);
    }
}

