/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.core;

import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCost;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.BiRel;
import org.apache.hive.druid.org.apache.calcite.rel.RelInput;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.RelWriter;
import org.apache.hive.druid.org.apache.calcite.rel.core.CorrelationId;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SemiJoinType;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.Litmus;

public abstract class Correlate
extends BiRel {
    protected final CorrelationId correlationId;
    protected final ImmutableBitSet requiredColumns;
    protected final SemiJoinType joinType;

    protected Correlate(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, SemiJoinType joinType) {
        super(cluster, traits, left, right);
        this.joinType = joinType;
        this.correlationId = correlationId;
        this.requiredColumns = requiredColumns;
    }

    public Correlate(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInputs().get(0), input.getInputs().get(1), new CorrelationId((Integer)input.get("correlationId")), input.getBitSet("requiredColumns"), input.getEnum("joinType", SemiJoinType.class));
    }

    @Override
    public boolean isValid(Litmus litmus) {
        return super.isValid(litmus) && RelOptUtil.notContainsCorrelation(this.left, this.correlationId, litmus);
    }

    @Override
    public Correlate copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return this.copy(traitSet, inputs.get(0), inputs.get(1), this.correlationId, this.requiredColumns, this.joinType);
    }

    public abstract Correlate copy(RelTraitSet var1, RelNode var2, RelNode var3, CorrelationId var4, ImmutableBitSet var5, SemiJoinType var6);

    public SemiJoinType getJoinType() {
        return this.joinType;
    }

    @Override
    protected RelDataType deriveRowType() {
        switch (this.joinType) {
            case LEFT: 
            case INNER: {
                LogicalJoin join = LogicalJoin.create(this.left, this.right, (RexNode)this.getCluster().getRexBuilder().makeLiteral(true), ImmutableSet.of(), this.joinType.toJoinType());
                return join.deriveRowType();
            }
            case ANTI: 
            case SEMI: {
                return this.left.getRowType();
            }
        }
        throw new IllegalStateException("Unknown join type " + (Object)((Object)this.joinType));
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("correlation", this.correlationId).item("joinType", (Object)this.joinType).item("requiredColumns", this.requiredColumns.toString());
    }

    public CorrelationId getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public String getCorrelVariable() {
        return this.correlationId.getName();
    }

    public ImmutableBitSet getRequiredColumns() {
        return this.requiredColumns;
    }

    @Override
    public Set<CorrelationId> getVariablesSet() {
        return ImmutableSet.of(this.correlationId);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        double rightRowCount = this.right.estimateRowCount(mq);
        double leftRowCount = this.left.estimateRowCount(mq);
        if (Double.isInfinite(leftRowCount) || Double.isInfinite(rightRowCount)) {
            return planner.getCostFactory().makeInfiniteCost();
        }
        Double restartCount = mq.getRowCount(this.getLeft());
        RelOptCost rightCost = planner.getCost(this.getRight(), mq);
        RelOptCost rescanCost = rightCost.multiplyBy(Math.max(1.0, restartCount - 1.0));
        return planner.getCostFactory().makeCost(rowCount + leftRowCount, 0.0, 0.0).plus(rescanCost);
    }
}

