/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hive.druid.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.hive.druid.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.hive.druid.org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.hive.druid.org.apache.calcite.avatica.ConnectionProperty;
import org.apache.hive.druid.org.apache.calcite.avatica.DriverVersion;
import org.apache.hive.druid.org.apache.calcite.avatica.Handler;
import org.apache.hive.druid.org.apache.calcite.avatica.HandlerImpl;
import org.apache.hive.druid.org.apache.calcite.avatica.Meta;
import org.apache.hive.druid.org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.hive.druid.org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteFactory;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteMetaImpl;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.hive.druid.org.apache.calcite.linq4j.function.Function0;
import org.apache.hive.druid.org.apache.calcite.model.JsonSchema;
import org.apache.hive.druid.org.apache.calcite.model.ModelHandler;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaFactory;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.hive.druid.org.apache.calcite.util.JsonBuilder;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:calcite:";
    final Function0<CalcitePrepare> prepareFactory = this.createPrepareFactory();

    protected Function0<CalcitePrepare> createPrepareFactory() {
        return CalcitePrepare.DEFAULT_FACTORY;
    }

    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: 
            case JDBC_40: {
                throw new IllegalArgumentException("JDBC version not supported: " + jdbcVersion);
            }
        }
        return "org.apache.hive.druid.org.apache.calcite.jdbc.CalciteJdbc41Factory";
    }

    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, (String)"org-apache-calcite-jdbc.properties", (String)"Calcite JDBC Driver", (String)"unknown version", (String)"Calcite", (String)"unknown version");
    }

    protected Handler createHandler() {
        return new HandlerImpl(){

            public void onConnectionInit(AvaticaConnection connection_) throws SQLException {
                CalciteConnectionImpl connection = (CalciteConnectionImpl)connection_;
                super.onConnectionInit((AvaticaConnection)connection);
                String model = this.model(connection);
                if (model != null) {
                    try {
                        new ModelHandler(connection, model);
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                }
                connection.init();
            }

            String model(CalciteConnectionImpl connection) {
                JsonSchema.Type schemaType;
                String model = connection.config().model();
                if (model != null) {
                    return model;
                }
                SchemaFactory schemaFactory = connection.config().schemaFactory(SchemaFactory.class, null);
                Properties info = connection.getProperties();
                String schemaName = Util.first(connection.config().schema(), "adhoc");
                if (schemaFactory == null && (schemaType = connection.config().schemaType()) != null) {
                    switch (schemaType) {
                        case JDBC: {
                            schemaFactory = JdbcSchema.Factory.INSTANCE;
                            break;
                        }
                        case MAP: {
                            schemaFactory = AbstractSchema.Factory.INSTANCE;
                        }
                    }
                }
                if (schemaFactory != null) {
                    JsonBuilder json = new JsonBuilder();
                    Map<String, Object> root = json.map();
                    root.put("version", "1.0");
                    root.put("defaultSchema", schemaName);
                    List<Object> schemaList = json.list();
                    root.put("schemas", schemaList);
                    Map<String, Object> schema = json.map();
                    schemaList.add(schema);
                    schema.put("type", "custom");
                    schema.put("name", schemaName);
                    schema.put("factory", schemaFactory.getClass().getName());
                    Map<String, Object> operandMap = json.map();
                    schema.put("operand", operandMap);
                    for (Map.Entry<String, String> entry : Util.toMap(info).entrySet()) {
                        if (!entry.getKey().startsWith("schema.")) continue;
                        operandMap.put(entry.getKey().substring("schema.".length()), entry.getValue());
                    }
                    return "inline:" + json.toJsonString(root);
                }
                return null;
            }
        };
    }

    protected Collection<ConnectionProperty> getConnectionProperties() {
        ArrayList<ConnectionProperty> list = new ArrayList<ConnectionProperty>();
        Collections.addAll(list, BuiltInConnectionProperty.values());
        Collections.addAll(list, CalciteConnectionProperty.values());
        return list;
    }

    public Meta createMeta(AvaticaConnection connection) {
        return new CalciteMetaImpl((CalciteConnectionImpl)connection);
    }

    CalciteConnection connect(CalciteSchema rootSchema, JavaTypeFactory typeFactory) {
        return (CalciteConnection)((CalciteFactory)this.factory).newConnection(this, this.factory, CONNECT_STRING_PREFIX, new Properties(), rootSchema, typeFactory);
    }

    static {
        new Driver().register();
    }
}

