/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.jdbc;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.hive.druid.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Primitive;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Statement;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.hive.druid.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCost;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.runtime.Hook;
import org.apache.hive.druid.org.apache.calcite.runtime.SqlFunctions;
import org.apache.hive.druid.org.apache.calcite.schema.Schemas;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDialect;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.util.BuiltInMethod;

public class JdbcToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    protected JdbcToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, traits, input);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new JdbcToEnumerableConverter(this.getCluster(), traitSet, JdbcToEnumerableConverter.sole(inputs));
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        Expression calendar_;
        BlockBuilder builder0 = new BlockBuilder(false);
        JdbcRel child = (JdbcRel)this.getInput();
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
        JdbcConvention jdbcConvention = (JdbcConvention)child.getConvention();
        String sql = this.generateSql(jdbcConvention.dialect);
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println("[" + sql + "]");
        }
        Hook.QUERY_PLAN.run(sql);
        Expression sql_ = builder0.append("sql", Expressions.constant(sql));
        int fieldCount = this.getRowType().getFieldCount();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression resultSet_ = Expressions.parameter(16, ResultSet.class, builder.newName("resultSet"));
        CalendarPolicy calendarPolicy = CalendarPolicy.of(jdbcConvention.dialect);
        switch (calendarPolicy) {
            case LOCAL: {
                calendar_ = builder0.append("calendar", Expressions.call(Calendar.class, "getInstance", new Expression[]{this.getTimeZoneExpression(implementor)}));
                break;
            }
            default: {
                calendar_ = null;
            }
        }
        if (fieldCount == 1) {
            ParameterExpression value_ = Expressions.parameter(Object.class, builder.newName("value"));
            builder.add(Expressions.declare(16, value_, null));
            this.generateGet(implementor, physType, builder, resultSet_, 0, value_, calendar_, calendarPolicy);
            builder.add(Expressions.return_(null, value_));
        } else {
            Expression values_ = builder.append("values", Expressions.newArrayBounds(Object.class, 1, Expressions.constant(fieldCount)));
            for (int i = 0; i < fieldCount; ++i) {
                this.generateGet(implementor, physType, builder, resultSet_, i, Expressions.arrayIndex(values_, Expressions.constant(i)), calendar_, calendarPolicy);
            }
            builder.add(Expressions.return_(null, values_));
        }
        ParameterExpression e_ = Expressions.parameter(SQLException.class, builder.newName("e"));
        Expression rowBuilderFactory_ = builder0.append("rowBuilderFactory", Expressions.lambda(Expressions.block(Expressions.return_(null, Expressions.lambda(Expressions.block(Expressions.tryCatch((Statement)builder.toBlock(), Expressions.catch_(e_, Expressions.throw_(Expressions.new_(RuntimeException.class, new Expression[]{e_}))))), new ParameterExpression[0]))), resultSet_));
        Expression enumerable = builder0.append("enumerable", Expressions.call(BuiltInMethod.RESULT_SET_ENUMERABLE_OF.method, Expressions.call(Schemas.unwrap(jdbcConvention.expression, JdbcSchema.class), BuiltInMethod.JDBC_SCHEMA_DATA_SOURCE.method, new Expression[0]), sql_, rowBuilderFactory_));
        builder0.add(Expressions.return_(null, enumerable));
        return implementor.result(physType, builder0.toBlock());
    }

    private UnaryExpression getTimeZoneExpression(EnumerableRelImplementor implementor) {
        return Expressions.convert_(Expressions.call((Expression)implementor.getRootExpression(), "get", Expressions.constant("timeZone")), TimeZone.class);
    }

    private void generateGet(EnumerableRelImplementor implementor, PhysType physType, BlockBuilder builder, ParameterExpression resultSet_, int i, Expression target, Expression calendar_, CalendarPolicy calendarPolicy) {
        MethodCallExpression source;
        Primitive primitive = Primitive.ofBoxOr(physType.fieldClass(i));
        RelDataType fieldType = physType.getRowType().getFieldList().get(i).getType();
        ArrayList<Expression> dateTimeArgs = new ArrayList<Expression>();
        dateTimeArgs.add(Expressions.constant(i + 1));
        SqlTypeName sqlTypeName = fieldType.getSqlTypeName();
        boolean offset = false;
        switch (calendarPolicy) {
            case LOCAL: {
                dateTimeArgs.add(calendar_);
                break;
            }
            case NULL: {
                break;
            }
            case DIRECT: {
                sqlTypeName = SqlTypeName.ANY;
                break;
            }
            case SHIFT: {
                switch (sqlTypeName) {
                    case TIMESTAMP: 
                    case DATE: {
                        offset = true;
                    }
                }
            }
        }
        switch (sqlTypeName) {
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                source = Expressions.call(this.getMethod(sqlTypeName, fieldType.isNullable(), offset), Expressions.list().append(Expressions.call((Expression)resultSet_, this.getMethod2(sqlTypeName), dateTimeArgs)).appendIf(offset, (MethodCallExpression)((Object)this.getTimeZoneExpression(implementor))));
                break;
            }
            case ARRAY: {
                UnaryExpression x = Expressions.convert_(Expressions.call((Expression)resultSet_, this.jdbcGetMethod(primitive), Expressions.constant(i + 1)), Array.class);
                source = Expressions.call(BuiltInMethod.JDBC_ARRAY_TO_LIST.method, x);
                break;
            }
            default: {
                source = Expressions.call((Expression)resultSet_, this.jdbcGetMethod(primitive), Expressions.constant(i + 1));
            }
        }
        builder.add(Expressions.statement(Expressions.assign(target, source)));
        if (primitive != null) {
            builder.add(Expressions.ifThen(Expressions.call((Expression)resultSet_, "wasNull", new Expression[0]), Expressions.statement(Expressions.assign(target, Expressions.constant(null)))));
        }
    }

    private Method getMethod(SqlTypeName sqlTypeName, boolean nullable, boolean offset) {
        switch (sqlTypeName) {
            case DATE: {
                return (nullable ? BuiltInMethod.DATE_TO_INT_OPTIONAL : BuiltInMethod.DATE_TO_INT).method;
            }
            case TIME: {
                return (nullable ? BuiltInMethod.TIME_TO_INT_OPTIONAL : BuiltInMethod.TIME_TO_INT).method;
            }
            case TIMESTAMP: {
                return (nullable ? (offset ? BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL_OFFSET : BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL) : (offset ? BuiltInMethod.TIMESTAMP_TO_LONG_OFFSET : BuiltInMethod.TIMESTAMP_TO_LONG)).method;
            }
        }
        throw new AssertionError((Object)((Object)((Object)sqlTypeName) + ":" + nullable));
    }

    private Method getMethod2(SqlTypeName sqlTypeName) {
        switch (sqlTypeName) {
            case DATE: {
                return BuiltInMethod.RESULT_SET_GET_DATE2.method;
            }
            case TIME: {
                return BuiltInMethod.RESULT_SET_GET_TIME2.method;
            }
            case TIMESTAMP: {
                return BuiltInMethod.RESULT_SET_GET_TIMESTAMP2.method;
            }
        }
        throw new AssertionError((Object)sqlTypeName);
    }

    private String jdbcGetMethod(Primitive primitive) {
        return primitive == null ? "getObject" : "get" + SqlFunctions.initcap(primitive.primitiveName);
    }

    private String generateSql(SqlDialect dialect) {
        JdbcImplementor jdbcImplementor = new JdbcImplementor(dialect, (JavaTypeFactory)this.getCluster().getTypeFactory());
        SqlImplementor.Result result = jdbcImplementor.visitChild(0, this.getInput());
        return result.asQuery().toSqlString(dialect).getSql();
    }

    private static enum CalendarPolicy {
        NONE,
        NULL,
        LOCAL,
        DIRECT,
        SHIFT;


        static CalendarPolicy of(SqlDialect dialect) {
            switch (dialect.getDatabaseProduct()) {
                case MYSQL: {
                    return SHIFT;
                }
            }
            return NULL;
        }
    }
}

