/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.timeline.partition;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpecLookup;
import org.apache.hive.druid.io.druid.timeline.partition.StringPartitionChunk;

public class SingleDimensionShardSpec
implements ShardSpec {
    private String dimension;
    private String start;
    private String end;
    private int partitionNum;

    public SingleDimensionShardSpec() {
        this(null, null, null, -1);
    }

    public SingleDimensionShardSpec(String dimension, String start, String end, int partitionNum) {
        this.dimension = dimension;
        this.start = start;
        this.end = end;
        this.partitionNum = partitionNum;
    }

    @JsonProperty(value="dimension")
    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    @JsonProperty(value="start")
    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    @JsonProperty(value="end")
    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    @Override
    public ShardSpecLookup getLookup(final List<ShardSpec> shardSpecs) {
        return new ShardSpecLookup(){

            @Override
            public ShardSpec getShardSpec(long timestamp, InputRow row) {
                for (ShardSpec spec : shardSpecs) {
                    if (!spec.isInChunk(timestamp, row)) continue;
                    return spec;
                }
                throw new ISE("row[%s] doesn't fit in any shard[%s]", row, shardSpecs);
            }
        };
    }

    @Override
    public Map<String, Range<String>> getDomain() {
        Range<Object> range = this.start == null && this.end == null ? Range.all() : (this.start == null ? Range.atMost(this.end) : (this.end == null ? Range.atLeast(this.start) : Range.closed(this.start, this.end)));
        return ImmutableMap.of(this.dimension, range);
    }

    public void setPartitionNum(int partitionNum) {
        this.partitionNum = partitionNum;
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new StringPartitionChunk<T>(this.start, this.end, this.partitionNum, obj);
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        List<String> values = inputRow.getDimension(this.dimension);
        if (values == null || values.size() != 1) {
            return this.checkValue(null);
        }
        return this.checkValue(values.get(0));
    }

    private boolean checkValue(String value) {
        if (value == null) {
            return this.start == null;
        }
        if (this.start == null) {
            return this.end == null || value.compareTo(this.end) < 0;
        }
        return value.compareTo(this.start) >= 0 && (this.end == null || value.compareTo(this.end) < 0);
    }

    public String toString() {
        return "SingleDimensionShardSpec{dimension='" + this.dimension + '\'' + ", start='" + this.start + '\'' + ", end='" + this.end + '\'' + ", partitionNum=" + this.partitionNum + '}';
    }
}

