/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.concurrent.ScheduledExecutors;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.io.druid.server.RequestLogLine;
import org.apache.hive.druid.io.druid.server.log.RequestLogger;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.MutableDateTime;

public class FileRequestLogger
implements RequestLogger {
    private final ObjectMapper objectMapper;
    private final ScheduledExecutorService exec;
    private final File baseDir;
    private final Object lock = new Object();
    private volatile DateTime currentDay;
    private volatile OutputStreamWriter fileWriter;

    public FileRequestLogger(ObjectMapper objectMapper, ScheduledExecutorService exec, File baseDir) {
        this.exec = exec;
        this.objectMapper = objectMapper;
        this.baseDir = baseDir;
    }

    @LifecycleStart
    public void start() {
        try {
            this.baseDir.mkdirs();
            MutableDateTime mutableDateTime = new DateTime().toMutableDateTime();
            mutableDateTime.setMillisOfDay(0);
            this.currentDay = mutableDateTime.toDateTime();
            this.fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.baseDir, this.currentDay.toString("yyyy-MM-dd'.log'")), true), Charsets.UTF_8);
            long nextDay = this.currentDay.plusDays(1).getMillis();
            Duration delay = new Duration(nextDay - new DateTime().getMillis());
            ScheduledExecutors.scheduleWithFixedDelay(this.exec, delay, Duration.standardDays((long)1L), new Callable<ScheduledExecutors.Signal>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ScheduledExecutors.Signal call() {
                    FileRequestLogger.this.currentDay = FileRequestLogger.this.currentDay.plusDays(1);
                    try {
                        Object object = FileRequestLogger.this.lock;
                        synchronized (object) {
                            CloseQuietly.close(FileRequestLogger.this.fileWriter);
                            FileRequestLogger.this.fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(FileRequestLogger.this.baseDir, FileRequestLogger.this.currentDay.toString()), true), Charsets.UTF_8);
                        }
                    }
                    catch (Exception e) {
                        Throwables.propagate(e);
                    }
                    return ScheduledExecutors.Signal.REPEAT;
                }
            });
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            CloseQuietly.close(this.fileWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(RequestLogLine requestLogLine) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.fileWriter.write(String.format("%s%n", requestLogLine.getLine(this.objectMapper)));
            this.fileWriter.flush();
        }
    }
}

