/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.initialization.jetty;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class JettyMonitoringConnectionFactory
extends ContainerLifeCycle
implements ConnectionFactory {
    private final ConnectionFactory connectionFactory;
    private final AtomicInteger activeConns;

    public JettyMonitoringConnectionFactory(ConnectionFactory connectionFactory, AtomicInteger activeConns) {
        this.connectionFactory = connectionFactory;
        this.addBean(connectionFactory);
        this.activeConns = activeConns;
    }

    public String getProtocol() {
        return this.connectionFactory.getProtocol();
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        Connection connection = this.connectionFactory.newConnection(connector, endPoint);
        connection.addListener(new Connection.Listener(){

            public void onOpened(Connection connection) {
                JettyMonitoringConnectionFactory.this.activeConns.incrementAndGet();
            }

            public void onClosed(Connection connection) {
                JettyMonitoringConnectionFactory.this.activeConns.decrementAndGet();
            }
        });
        return connection;
    }
}

