/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http.security;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.server.http.security.AbstractResourceFilter;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthorizationInfo;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.apache.hive.druid.io.druid.server.security.ResourceType;

public class StateResourceFilter
extends AbstractResourceFilter {
    @Inject
    public StateResourceFilter(AuthConfig authConfig) {
        super(authConfig);
    }

    public ContainerRequest filter(ContainerRequest request) {
        if (this.getAuthConfig().isEnabled()) {
            String resourceName = "STATE";
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)this.getReq().getAttribute("Druid-Auth-Token");
            Preconditions.checkNotNull(authorizationInfo, "Security is enabled but no authorization info found in the request");
            Access authResult = authorizationInfo.isAuthorized(new Resource("STATE", ResourceType.STATE), this.getAction(request));
            if (!authResult.isAllowed()) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)String.format("Access-Check-Result: %s", authResult.toString())).build());
            }
        }
        return request;
    }

    @Override
    public boolean isApplicable(String requestPath) {
        return requestPath.startsWith("druid/broker/v1") || requestPath.startsWith("druid/coordinator/v1") || requestPath.startsWith("druid/historical/v1") || requestPath.startsWith("druid/indexer/v1") || requestPath.startsWith("druid/coordinator/v1/rules") || requestPath.startsWith("druid/coordinator/v1/tiers") || requestPath.startsWith("druid/worker/v1") || requestPath.startsWith("druid/coordinator/v1/servers") || requestPath.startsWith("druid/v2") || requestPath.startsWith("status");
    }
}

