/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http.security;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.server.http.security.AbstractResourceFilter;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthorizationInfo;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.apache.hive.druid.io.druid.server.security.ResourceType;

public class RulesResourceFilter
extends AbstractResourceFilter {
    @Inject
    public RulesResourceFilter(AuthConfig authConfig) {
        super(authConfig);
    }

    public ContainerRequest filter(ContainerRequest request) {
        if (this.getAuthConfig().isEnabled()) {
            String dataSourceName = ((PathSegment)request.getPathSegments().get(Iterables.indexOf(request.getPathSegments(), new Predicate<PathSegment>(){

                @Override
                public boolean apply(PathSegment input) {
                    return input.getPath().equals("rules");
                }
            }) + 1)).getPath();
            Preconditions.checkNotNull(dataSourceName);
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)this.getReq().getAttribute("Druid-Auth-Token");
            Preconditions.checkNotNull(authorizationInfo, "Security is enabled but no authorization info found in the request");
            Access authResult = authorizationInfo.isAuthorized(new Resource(dataSourceName, ResourceType.DATASOURCE), this.getAction(request));
            if (!authResult.isAllowed()) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)String.format("Access-Check-Result: %s", authResult.toString())).build());
            }
        }
        return request;
    }

    @Override
    public boolean isApplicable(String requestPath) {
        ImmutableList<String> applicablePaths = ImmutableList.of("druid/coordinator/v1/rules/");
        for (String path : applicablePaths) {
            if (!requestPath.startsWith(path) || requestPath.equals(path)) continue;
            return true;
        }
        return false;
    }
}

