/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.helper;

import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.LoadPeonCallback;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class DruidCoordinatorCleanupUnneeded
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorCleanupUnneeded.class);
    private final DruidCoordinator coordinator;

    public DruidCoordinatorCleanupUnneeded(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        Set<DataSegment> availableSegments = params.getAvailableSegments();
        DruidCluster cluster = params.getDruidCluster();
        if (!availableSegments.isEmpty()) {
            for (MinMaxPriorityQueue<ServerHolder> serverHolders : cluster.getSortedServersByTier()) {
                for (ServerHolder serverHolder : serverHolders) {
                    ImmutableDruidServer server = serverHolder.getServer();
                    for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
                        for (DataSegment segment : dataSource.getSegments()) {
                            LoadQueuePeon queuePeon;
                            if (availableSegments.contains(segment) || (queuePeon = params.getLoadManagementPeons().get(server.getName())).getSegmentsToDrop().contains(segment)) continue;
                            queuePeon.dropSegment(segment, new LoadPeonCallback(){

                                @Override
                                public void execute() {
                                }
                            });
                            stats.addToTieredStat("unneededCount", server.getTier(), 1L);
                        }
                    }
                }
            }
        } else {
            log.info("Found 0 availableSegments, skipping the cleanup of segments from historicals. This is done to prevent a race condition in which the coordinator would drop all segments if it started running cleanup before it finished polling the metadata storage for available segments for the first time.", new Object[0]);
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

