/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.helper;

import java.util.HashMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.hive.druid.com.metamx.common.guava.Comparators;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;

public class DruidCoordinatorCleanupOvershadowed
implements DruidCoordinatorHelper {
    private final DruidCoordinator coordinator;

    public DruidCoordinatorCleanupOvershadowed(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        if (params.hasDeletionWaitTimeElapsed()) {
            DruidCluster cluster = params.getDruidCluster();
            HashMap timelines = Maps.newHashMap();
            for (MinMaxPriorityQueue<ServerHolder> serverHolders : cluster.getSortedServersByTier()) {
                for (ServerHolder serverHolder : serverHolders) {
                    ImmutableDruidServer server = serverHolder.getServer();
                    for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
                        VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)timelines.get(dataSource.getName());
                        if (timeline == null) {
                            timeline = new VersionedIntervalTimeline(Comparators.comparable());
                            timelines.put(dataSource.getName(), timeline);
                        }
                        for (DataSegment segment : dataSource.getSegments()) {
                            timeline.add(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(segment));
                        }
                    }
                }
            }
            for (VersionedIntervalTimeline timeline : timelines.values()) {
                for (TimelineObjectHolder timelineObjectHolder : timeline.findOvershadowed()) {
                    for (DataSegment dataSegment : timelineObjectHolder.getObject().payloads()) {
                        this.coordinator.removeSegment(dataSegment);
                        stats.addToGlobalStat("overShadowedCount", 1L);
                    }
                }
                for (LoadQueuePeon loadQueuePeon : this.coordinator.getLoadManagementPeons().values()) {
                    for (DataSegment dataSegment : loadQueuePeon.getSegmentsToLoad()) {
                        timeline = (VersionedIntervalTimeline)timelines.get(dataSegment.getDataSource());
                        if (timeline == null) continue;
                        timeline.add(dataSegment.getInterval(), dataSegment.getVersion(), dataSegment.getShardSpec().createChunk(dataSegment));
                        for (TimelineObjectHolder holder : timeline.findOvershadowed()) {
                            for (DataSegment segmentToRemove : holder.getObject().payloads()) {
                                if (segmentToRemove != dataSegment) continue;
                                this.coordinator.removeSegment(dataSegment);
                                stats.addToGlobalStat("overShadowedCount", 1L);
                            }
                        }
                        timeline.remove(dataSegment.getInterval(), dataSegment.getVersion(), dataSegment.getShardSpec().createChunk(dataSegment));
                    }
                }
            }
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

