/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.firehose;

import com.google.inject.Inject;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.curator.discovery.ServiceAnnouncer;
import org.apache.hive.druid.io.druid.guice.annotations.RemoteChatHandler;
import org.apache.hive.druid.io.druid.segment.realtime.firehose.ChatHandler;
import org.apache.hive.druid.io.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.hive.druid.io.druid.server.DruidNode;

public class ServiceAnnouncingChatHandlerProvider
implements ChatHandlerProvider {
    private static final Logger log = new Logger(ServiceAnnouncingChatHandlerProvider.class);
    private final DruidNode node;
    private final ServiceAnnouncer serviceAnnouncer;
    private final ConcurrentMap<String, ChatHandler> handlers;
    private final ConcurrentSkipListSet<String> announcements;

    @Inject
    public ServiceAnnouncingChatHandlerProvider(@RemoteChatHandler DruidNode node, ServiceAnnouncer serviceAnnouncer) {
        this.node = node;
        this.serviceAnnouncer = serviceAnnouncer;
        this.handlers = Maps.newConcurrentMap();
        this.announcements = new ConcurrentSkipListSet();
    }

    @Override
    public void register(String service, ChatHandler handler) {
        this.register(service, handler, true);
    }

    @Override
    public void register(String service, ChatHandler handler, boolean announce) {
        log.info("Registering Eventhandler[%s]", service);
        if (this.handlers.putIfAbsent(service, handler) != null) {
            throw new ISE("handler already registered for service[%s]", service);
        }
        if (announce) {
            try {
                this.serviceAnnouncer.announce(this.makeDruidNode(service));
                if (!this.announcements.add(service)) {
                    throw new ISE("announcements already has an entry for service[%s]", service);
                }
            }
            catch (Exception e) {
                log.warn(e, "Failed to register service[%s]", service);
                this.handlers.remove(service, handler);
            }
        }
    }

    @Override
    public void unregister(String service) {
        log.info("Unregistering chat handler[%s]", service);
        ChatHandler handler = (ChatHandler)this.handlers.get(service);
        if (handler == null) {
            log.warn("handler[%s] not currently registered, ignoring.", service);
            return;
        }
        if (this.announcements.contains(service)) {
            try {
                this.serviceAnnouncer.unannounce(this.makeDruidNode(service));
            }
            catch (Exception e) {
                log.warn(e, "Failed to unregister service[%s]", service);
            }
            this.announcements.remove(service);
        }
        this.handlers.remove(service, handler);
    }

    @Override
    public Optional<ChatHandler> get(String key) {
        return Optional.fromNullable(this.handlers.get(key));
    }

    private DruidNode makeDruidNode(String key) {
        return new DruidNode(key, this.node.getHost(), this.node.getPort());
    }
}

