/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.firehose;

import com.ircclouds.irc.api.domain.messages.ChannelPrivMsg;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.segment.realtime.firehose.IrcDecoder;
import org.joda.time.DateTime;

@JsonTypeName(value="irc")
public class IrcInputRowParser
implements InputRowParser<Pair<DateTime, ChannelPrivMsg>> {
    private final ParseSpec parseSpec;
    private final IrcDecoder decoder;

    @JsonCreator
    public IrcInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="decoder") IrcDecoder decoder) {
        this.parseSpec = parseSpec;
        this.decoder = decoder;
    }

    @JsonProperty
    public IrcDecoder getDecoder() {
        return this.decoder;
    }

    @Override
    public InputRow parse(Pair<DateTime, ChannelPrivMsg> msg) {
        return this.decoder.decodeMessage((DateTime)msg.lhs, ((ChannelPrivMsg)msg.rhs).getChannelName(), ((ChannelPrivMsg)msg.rhs).getText());
    }

    @Override
    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @Override
    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new IrcInputRowParser(parseSpec, this.decoder);
    }
}

