/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.metamx.common.MapUtils;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentKiller;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class LocalDataSegmentKiller
implements DataSegmentKiller {
    private static final Logger log = new Logger(LocalDataSegmentKiller.class);
    private static final String PATH_KEY = "path";

    @Override
    public void kill(DataSegment segment) throws SegmentLoadingException {
        block4: {
            File path = this.getPath(segment);
            log.info("killing segment[%s] mapped to path[%s]", segment.getIdentifier(), path);
            try {
                if (path.getName().endsWith(".zip")) {
                    File intervalDir;
                    File partitionNumDir = path.getParentFile();
                    FileUtils.deleteDirectory((File)partitionNumDir);
                    File versionDir = partitionNumDir.getParentFile();
                    if (versionDir.delete() && (intervalDir = versionDir.getParentFile()).delete()) {
                        File dataSourceDir = intervalDir.getParentFile();
                        dataSourceDir.delete();
                    }
                    break block4;
                }
                throw new SegmentLoadingException("Unknown file type[%s]", path);
            }
            catch (IOException e) {
                throw new SegmentLoadingException(e, "Unable to kill segment", new Object[0]);
            }
        }
    }

    private File getPath(DataSegment segment) throws SegmentLoadingException {
        return new File(MapUtils.getString(segment.getLoadSpec(), PATH_KEY));
    }
}

