/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentFinder;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class LocalDataSegmentFinder
implements DataSegmentFinder {
    private static final Logger log = new Logger(LocalDataSegmentFinder.class);
    private final ObjectMapper mapper;

    @Inject
    public LocalDataSegmentFinder(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Set<DataSegment> findSegments(String workingDirPath, boolean updateDescriptor) throws SegmentLoadingException {
        HashSet<DataSegment> segments = Sets.newHashSet();
        File workingDir = new File(workingDirPath);
        if (!workingDir.isDirectory()) {
            throw new SegmentLoadingException("Working directory [%s] didn't exist !?", workingDir);
        }
        this.recursiveSearchSegments(segments, workingDir, updateDescriptor);
        return segments;
    }

    private void recursiveSearchSegments(Set<DataSegment> segments, File workingDir, boolean updateDescriptor) throws SegmentLoadingException {
        for (File file : workingDir.listFiles()) {
            if (file.isDirectory()) {
                this.recursiveSearchSegments(segments, file, updateDescriptor);
                continue;
            }
            if (!file.getName().equals("descriptor.json")) continue;
            File indexZip = new File(file.getParentFile(), "index.zip");
            if (indexZip.exists()) {
                try {
                    DataSegment dataSegment = this.mapper.readValue(FileUtils.readFileToString((File)file), DataSegment.class);
                    log.info("Found segment [%s] located at [%s]", dataSegment.getIdentifier(), indexZip.getAbsoluteFile());
                    Map<String, Object> loadSpec = dataSegment.getLoadSpec();
                    if (!loadSpec.get("type").equals("local") || !loadSpec.get("path").equals(indexZip.getAbsoluteFile())) {
                        loadSpec.put("type", "local");
                        loadSpec.put("path", indexZip.getAbsolutePath());
                        if (updateDescriptor) {
                            log.info("Updating loadSpec in descriptor.json at [%s] with new path [%s]", file.getAbsolutePath(), indexZip.toString());
                            FileUtils.writeStringToFile((File)file, (String)this.mapper.writeValueAsString(dataSegment));
                        }
                    }
                    segments.add(dataSegment);
                    continue;
                }
                catch (IOException e) {
                    throw new SegmentLoadingException(e, "Failed to read descriptor.json for segment located at [%s]", file.getAbsoluteFile());
                }
            }
            throw new SegmentLoadingException("index.zip didn't exist at [%s] while descripter.json exists!?", indexZip.getAbsoluteFile());
        }
    }
}

