/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.format.ISODateTimeFormat;

public class DataSegmentPusherUtil {
    private static final Joiner JOINER = Joiner.on("/").skipNulls();

    public static String getStorageDir(DataSegment segment) {
        return JOINER.join(segment.getDataSource(), String.format("%s_%s", segment.getInterval().getStart(), segment.getInterval().getEnd()), segment.getVersion(), segment.getShardSpec().getPartitionNum());
    }

    public static String getHdfsStorageDir(DataSegment segment) {
        return JOINER.join(segment.getDataSource(), String.format("%s_%s", segment.getInterval().getStart().toString(ISODateTimeFormat.basicDateTime()), segment.getInterval().getEnd().toString(ISODateTimeFormat.basicDateTime())), segment.getVersion().replaceAll(":", "_"), segment.getShardSpec().getPartitionNum());
    }
}

