/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import java.util.regex.Pattern;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.segment.filter.DimensionPredicateFilter;

public class RegexFilter
extends DimensionPredicateFilter {
    public RegexFilter(String dimension, final Pattern pattern, ExtractionFn extractionFn) {
        super(dimension, new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return new Predicate<String>(){

                    @Override
                    public boolean apply(String input) {
                        return input != null && pattern.matcher(input).find();
                    }
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        return pattern.matcher(String.valueOf(input)).find();
                    }
                };
            }

            public String toString() {
                return "RegexFilter{pattern='" + pattern + '\'' + '}';
            }
        }, extractionFn);
    }
}

