/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherFactory;
import org.apache.hive.druid.io.druid.segment.filter.Filters;

public class DimensionPredicateFilter
implements Filter {
    private final String dimension;
    private final DruidPredicateFactory predicateFactory;
    private final String basePredicateString;
    private final ExtractionFn extractionFn;

    public DimensionPredicateFilter(String dimension, final DruidPredicateFactory predicateFactory, final ExtractionFn extractionFn) {
        Preconditions.checkNotNull(predicateFactory, "predicateFactory");
        this.dimension = Preconditions.checkNotNull(dimension, "dimension");
        this.basePredicateString = predicateFactory.toString();
        this.extractionFn = extractionFn;
        this.predicateFactory = extractionFn == null ? predicateFactory : new DruidPredicateFactory(){
            final Predicate<String> baseStringPredicate;
            {
                this.baseStringPredicate = predicateFactory.makeStringPredicate();
            }

            @Override
            public Predicate<String> makeStringPredicate() {
                return new Predicate<String>(){

                    @Override
                    public boolean apply(String input) {
                        return baseStringPredicate.apply(extractionFn.apply(input));
                    }
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        return baseStringPredicate.apply(extractionFn.apply(input));
                    }
                };
            }
        };
    }

    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        return Filters.matchPredicate(this.dimension, selector, this.predicateFactory.makeStringPredicate());
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, this.predicateFactory);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    public String toString() {
        if (this.extractionFn != null) {
            return String.format("%s(%s) = %s", this.extractionFn, this.dimension, this.basePredicateString);
        }
        return String.format("%s = %s", this.dimension, this.basePredicateString);
    }
}

