/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.CountingOutputStream;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.SingleValueIndexedIntsWriter;
import org.apache.hive.druid.io.druid.segment.data.VSizeIndexedInts;

public class VSizeIndexedIntsWriter
extends SingleValueIndexedIntsWriter {
    private static final byte VERSION = 0;
    private final IOPeon ioPeon;
    private final String valueFileName;
    private final int numBytes;
    private CountingOutputStream valuesOut = null;

    public VSizeIndexedIntsWriter(IOPeon ioPeon, String filenameBase, int maxValue) {
        this.ioPeon = ioPeon;
        this.valueFileName = String.format("%s.values", filenameBase);
        this.numBytes = VSizeIndexedInts.getNumBytesForMax(maxValue);
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.valueFileName));
    }

    @Override
    protected void addValue(int val) throws IOException {
        byte[] intAsBytes = Ints.toByteArray(val);
        this.valuesOut.write(intAsBytes, intAsBytes.length - this.numBytes, this.numBytes);
    }

    @Override
    public void close() throws IOException {
        byte[] bufPadding = new byte[4 - this.numBytes];
        this.valuesOut.write(bufPadding);
        this.valuesOut.close();
    }

    @Override
    public long getSerializedSize() {
        return 6L + this.valuesOut.getCount();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        long numBytesWritten = this.valuesOut.getCount();
        channel.write(ByteBuffer.wrap(new byte[]{0, (byte)this.numBytes}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)numBytesWritten)));
        ReadableByteChannel from = Channels.newChannel(this.ioPeon.makeInputStream(this.valueFileName));
        ByteStreams.copy(from, channel);
    }
}

