/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedIntsIterator;
import org.apache.hive.druid.io.druid.segment.data.WritableSupplier;

public class VSizeIndexedInts
implements IndexedInts,
Comparable<VSizeIndexedInts> {
    public static final byte VERSION = 0;
    private final ByteBuffer buffer;
    private final int numBytes;
    private final int bitsToShift;
    private final int size;

    public static VSizeIndexedInts fromArray(int[] array) {
        return VSizeIndexedInts.fromArray(array, Ints.max(array));
    }

    public static VSizeIndexedInts fromArray(int[] array, int maxValue) {
        return VSizeIndexedInts.fromList(Ints.asList(array), maxValue);
    }

    public static VSizeIndexedInts empty() {
        return VSizeIndexedInts.fromList(Lists.newArrayList(), 0);
    }

    public static byte[] getBytesNoPaddingfromList(List<Integer> list, int maxValue) {
        byte numBytes = VSizeIndexedInts.getNumBytesForMax(maxValue);
        ByteBuffer buffer = ByteBuffer.allocate(list.size() * numBytes);
        VSizeIndexedInts.writeToBuffer(buffer, list, numBytes, maxValue);
        return buffer.array();
    }

    public static VSizeIndexedInts fromList(List<Integer> list, int maxValue) {
        byte numBytes = VSizeIndexedInts.getNumBytesForMax(maxValue);
        ByteBuffer buffer = ByteBuffer.allocate(list.size() * numBytes + (4 - numBytes));
        VSizeIndexedInts.writeToBuffer(buffer, list, numBytes, maxValue);
        return new VSizeIndexedInts(buffer.asReadOnlyBuffer(), numBytes);
    }

    private static void writeToBuffer(ByteBuffer buffer, List<Integer> list, int numBytes, int maxValue) {
        int i = 0;
        for (Integer val : list) {
            if (val < 0) {
                throw new IAE("integer values must be positive, got[%d], i[%d]", val, i);
            }
            if (val > maxValue) {
                throw new IAE("val[%d] > maxValue[%d], please don't lie about maxValue.  i[%d]", val, maxValue, i);
            }
            byte[] intAsBytes = Ints.toByteArray(val);
            buffer.put(intAsBytes, intAsBytes.length - numBytes, numBytes);
            ++i;
        }
        buffer.position(0);
    }

    public static byte getNumBytesForMax(int maxValue) {
        if (maxValue < 0) {
            throw new IAE("maxValue[%s] must be positive", maxValue);
        }
        int numBytes = 4;
        if (maxValue <= 255) {
            numBytes = 1;
        } else if (maxValue <= 65535) {
            numBytes = 2;
        } else if (maxValue <= 0xFFFFFF) {
            numBytes = 3;
        }
        return (byte)numBytes;
    }

    public VSizeIndexedInts(ByteBuffer buffer, int numBytes) {
        this.buffer = buffer;
        this.numBytes = numBytes;
        this.bitsToShift = 32 - (numBytes << 3);
        int numBufferBytes = 4 - numBytes;
        this.size = (buffer.remaining() - numBufferBytes) / numBytes;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int get(int index) {
        return this.buffer.getInt(this.buffer.position() + index * this.numBytes) >>> this.bitsToShift;
    }

    public byte[] getBytesNoPadding() {
        int bytesToTake = this.buffer.remaining() - (4 - this.numBytes);
        byte[] bytes = new byte[bytesToTake];
        this.buffer.asReadOnlyBuffer().get(bytes);
        return bytes;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.buffer.remaining()];
        this.buffer.asReadOnlyBuffer().get(bytes);
        return bytes;
    }

    @Override
    public int compareTo(VSizeIndexedInts o) {
        int retVal = Ints.compare(this.numBytes, o.numBytes);
        if (retVal == 0) {
            retVal = this.buffer.compareTo(o.buffer);
        }
        return retVal;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public long getSerializedSize() {
        return 6 + this.buffer.remaining();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IndexedIntsIterator(this);
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{0, (byte)this.numBytes}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.buffer.remaining())));
        channel.write(this.buffer.asReadOnlyBuffer());
    }

    public static VSizeIndexedInts readFromByteBuffer(ByteBuffer buffer) {
        byte versionFromBuffer = buffer.get();
        if (0 == versionFromBuffer) {
            byte numBytes = buffer.get();
            int size = buffer.getInt();
            ByteBuffer bufferToUse = buffer.asReadOnlyBuffer();
            bufferToUse.limit(bufferToUse.position() + size);
            buffer.position(bufferToUse.limit());
            return new VSizeIndexedInts(bufferToUse, numBytes);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    @Override
    public void fill(int index, int[] toFill) {
        throw new UnsupportedOperationException("fill not supported");
    }

    @Override
    public void close() throws IOException {
    }

    public WritableSupplier<IndexedInts> asWritableSupplier() {
        return new VSizeIndexedIntsSupplier(this);
    }

    public static class VSizeIndexedIntsSupplier
    implements WritableSupplier<IndexedInts> {
        final VSizeIndexedInts delegate;

        public VSizeIndexedIntsSupplier(VSizeIndexedInts delegate) {
            this.delegate = delegate;
        }

        @Override
        public long getSerializedSize() {
            return this.delegate.getSerializedSize();
        }

        @Override
        public void writeToChannel(WritableByteChannel channel) throws IOException {
            this.delegate.writeToChannel(channel);
        }

        @Override
        public IndexedInts get() {
            return this.delegate;
        }
    }
}

