/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionMergerLegacy;
import org.apache.hive.druid.io.druid.segment.DimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.ProgressIndicator;
import org.apache.hive.druid.io.druid.segment.SegmentValidationException;
import org.apache.hive.druid.io.druid.segment.StringDimensionIndexer;
import org.apache.hive.druid.io.druid.segment.StringDimensionMergerLegacy;
import org.apache.hive.druid.io.druid.segment.StringDimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;

public class StringDimensionHandler
implements DimensionHandler<Integer, int[], String> {
    private static final Logger log = new Logger(StringDimensionHandler.class);
    private final String dimensionName;
    public static final Function<Object, String> STRING_TRANSFORMER = new Function<Object, String>(){

        @Override
        public String apply(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof String) {
                return (String)o;
            }
            return o.toString();
        }
    };
    public static final Comparator<Integer> ENCODED_COMPARATOR = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };
    public static final Comparator<String> UNENCODED_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };

    public StringDimensionHandler(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public int getLengthFromEncodedArray(int[] dimVals) {
        return dimVals.length;
    }

    @Override
    public int compareSortedEncodedArrays(int[] lhs, int[] rhs) {
        int lhsLen = lhs.length;
        int rhsLen = rhs.length;
        int retVal = Ints.compare(lhsLen, rhsLen);
        for (int valsIndex = 0; retVal == 0 && valsIndex < lhsLen; ++valsIndex) {
            retVal = Ints.compare(lhs[valsIndex], rhs[valsIndex]);
        }
        return retVal;
    }

    @Override
    public void validateSortedEncodedArrays(int[] lhs, int[] rhs, Indexed<String> lhsEncodings, Indexed<String> rhsEncodings) throws SegmentValidationException {
        int rhsLen;
        if (lhs == null || rhs == null) {
            if (lhs != rhs) {
                throw new SegmentValidationException("Expected nulls, found %s and %s", Arrays.toString(lhs), Arrays.toString(rhs));
            }
            return;
        }
        int lhsLen = Array.getLength(lhs);
        if (lhsLen != (rhsLen = Array.getLength(rhs))) {
            if (lhsLen == 0 && rhsLen == 1) {
                String dimValName = rhsEncodings.get(rhs[0]);
                if (dimValName == null) {
                    return;
                }
                throw new SegmentValidationException("Dim [%s] value [%s] is not null", this.dimensionName, dimValName);
            }
            if (rhsLen == 0 && lhsLen == 1) {
                String dimValName = lhsEncodings.get(lhs[0]);
                if (dimValName == null) {
                    return;
                }
                throw new SegmentValidationException("Dim [%s] value [%s] is not null", this.dimensionName, dimValName);
            }
            throw new SegmentValidationException("Dim [%s] value lengths not equal. Expected %d found %d", this.dimensionName, lhsLen, rhsLen);
        }
        for (int j = 0; j < Math.max(lhsLen, rhsLen); ++j) {
            String dim2ValName;
            int dIdex1 = lhsLen <= j ? -1 : lhs[j];
            int dIdex2 = rhsLen <= j ? -1 : rhs[j];
            String dim1ValName = dIdex1 < 0 ? null : lhsEncodings.get(dIdex1);
            String string = dim2ValName = dIdex2 < 0 ? null : rhsEncodings.get(dIdex2);
            if (dim1ValName == null || dim2ValName == null) {
                if (dim1ValName == null && dim2ValName == null) continue;
                throw new SegmentValidationException("Dim [%s] value not equal. Expected [%s] found [%s]", this.dimensionName, dim1ValName, dim2ValName);
            }
            if (dim1ValName.equals(dim2ValName)) continue;
            throw new SegmentValidationException("Dim [%s] value not equal. Expected [%s] found [%s]", this.dimensionName, dim1ValName, dim2ValName);
        }
    }

    @Override
    public Closeable getSubColumn(Column column) {
        return column.getDictionaryEncoding();
    }

    @Override
    public Object getRowValueArrayFromColumn(Closeable column, int currRow) {
        int[] theVals;
        DictionaryEncodedColumn dict = (DictionaryEncodedColumn)column;
        if (dict.hasMultipleValues()) {
            IndexedInts dimVals = dict.getMultiValueRow(currRow);
            theVals = new int[dimVals.size()];
            for (int i = 0; i < theVals.length; ++i) {
                theVals[i] = dimVals.get(i);
            }
        } else {
            theVals = new int[]{dict.getSingleValueRow(currRow)};
        }
        return theVals;
    }

    @Override
    public DimensionIndexer<Integer, int[], String> makeIndexer() {
        return new StringDimensionIndexer();
    }

    @Override
    public DimensionMergerV9 makeMerger(IndexSpec indexSpec, File outDir, IOPeon ioPeon, ColumnCapabilities capabilities, ProgressIndicator progress) {
        return new StringDimensionMergerV9(this.dimensionName, indexSpec, outDir, ioPeon, capabilities, progress);
    }

    @Override
    public DimensionMergerLegacy makeLegacyMerger(IndexSpec indexSpec, File outDir, IOPeon ioPeon, ColumnCapabilities capabilities, ProgressIndicator progress) {
        return new StringDimensionMergerLegacy(this.dimensionName, indexSpec, outDir, ioPeon, capabilities, progress);
    }
}

