/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.query.ChainedExecutionQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryEngine;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.io.druid.segment.Segment;

public class TopNQueryRunnerFactory
implements QueryRunnerFactory<Result<TopNResultValue>, TopNQuery> {
    private final StupidPool<ByteBuffer> computationBufferPool;
    private final TopNQueryQueryToolChest toolchest;
    private final QueryWatcher queryWatcher;

    @Inject
    public TopNQueryRunnerFactory(@Global StupidPool<ByteBuffer> computationBufferPool, TopNQueryQueryToolChest toolchest, QueryWatcher queryWatcher) {
        this.computationBufferPool = computationBufferPool;
        this.toolchest = toolchest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> createRunner(final Segment segment) {
        final TopNQueryEngine queryEngine = new TopNQueryEngine(this.computationBufferPool);
        return new QueryRunner<Result<TopNResultValue>>(){

            @Override
            public Sequence<Result<TopNResultValue>> run(Query<Result<TopNResultValue>> input, Map<String, Object> responseContext) {
                if (!(input instanceof TopNQuery)) {
                    throw new ISE("Got a [%s] which isn't a %s", input.getClass(), TopNQuery.class);
                }
                return queryEngine.query((TopNQuery)input, segment.asStorageAdapter());
            }
        };
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<TopNResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TopNResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TopNResultValue>, TopNQuery> getToolchest() {
        return this.toolchest;
    }
}

