/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeseries;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Queries;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;

@JsonTypeName(value="timeseries")
public class TimeseriesQuery
extends BaseQuery<Result<TimeseriesResultValue>> {
    private final DimFilter dimFilter;
    private final QueryGranularity granularity;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;

    @JsonCreator
    public TimeseriesQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="descending") boolean descending, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") QueryGranularity granularity, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, descending, context);
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.aggregatorSpecs = aggregatorSpecs == null ? ImmutableList.of() : aggregatorSpecs;
        this.postAggregatorSpecs = postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs;
        Queries.verifyAggregations(this.aggregatorSpecs, this.postAggregatorSpecs);
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "timeseries";
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="postAggregations")
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    public boolean isSkipEmptyBuckets() {
        return this.getContextBoolean("skipEmptyBuckets", false);
    }

    public TimeseriesQuery withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return new TimeseriesQuery(this.getDataSource(), querySegmentSpec, this.isDescending(), this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.getContext());
    }

    @Override
    public Query<Result<TimeseriesResultValue>> withDataSource(DataSource dataSource) {
        return new TimeseriesQuery(dataSource, this.getQuerySegmentSpec(), this.isDescending(), this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.getContext());
    }

    public TimeseriesQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        return new TimeseriesQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.isDescending(), this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.computeOverridenContext(contextOverrides));
    }

    public TimeseriesQuery withDimFilter(DimFilter dimFilter) {
        return new TimeseriesQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.isDescending(), dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.getContext());
    }

    public String toString() {
        return "TimeseriesQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", descending=" + this.isDescending() + ", dimFilter=" + this.dimFilter + ", granularity='" + this.granularity + '\'' + ", aggregatorSpecs=" + this.aggregatorSpecs + ", postAggregatorSpecs=" + this.postAggregatorSpecs + ", context=" + this.getContext() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeseriesQuery that = (TimeseriesQuery)o;
        if (this.aggregatorSpecs != null ? !this.aggregatorSpecs.equals(that.aggregatorSpecs) : that.aggregatorSpecs != null) {
            return false;
        }
        if (this.dimFilter != null ? !this.dimFilter.equals(that.dimFilter) : that.dimFilter != null) {
            return false;
        }
        if (this.granularity != null ? !this.granularity.equals(that.granularity) : that.granularity != null) {
            return false;
        }
        return !(this.postAggregatorSpecs != null ? !this.postAggregatorSpecs.equals(that.postAggregatorSpecs) : that.postAggregatorSpecs != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dimFilter != null ? this.dimFilter.hashCode() : 0);
        result = 31 * result + (this.granularity != null ? this.granularity.hashCode() : 0);
        result = 31 * result + (this.aggregatorSpecs != null ? this.aggregatorSpecs.hashCode() : 0);
        result = 31 * result + (this.postAggregatorSpecs != null ? this.postAggregatorSpecs.hashCode() : 0);
        return result;
    }
}

