/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeboundary;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.joda.time.DateTime;

public class TimeBoundaryResultValue {
    private final Object value;

    @JsonCreator
    public TimeBoundaryResultValue(Object value) {
        this.value = value;
    }

    @JsonValue
    public Object getBaseObject() {
        return this.value;
    }

    public DateTime getMaxTime() {
        if (this.value instanceof Map) {
            return this.getDateTimeValue(((Map)this.value).get("maxTime"));
        }
        return this.getDateTimeValue(this.value);
    }

    public DateTime getMinTime() {
        if (this.value instanceof Map) {
            return this.getDateTimeValue(((Map)this.value).get("minTime"));
        }
        throw new IAE("MinTime not supported!", new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeBoundaryResultValue that = (TimeBoundaryResultValue)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "TimeBoundaryResultValue{value=" + this.value + '}';
    }

    private DateTime getDateTimeValue(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof DateTime) {
            return (DateTime)val;
        }
        if (val instanceof String) {
            return new DateTime(val);
        }
        throw new IAE("Cannot get time from type[%s]", val.getClass());
    }
}

