/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeboundary;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.BaseSequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.io.druid.granularity.AllGranularity;
import org.apache.hive.druid.io.druid.query.ChainedExecutionQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerHelper;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.joda.time.DateTime;

public class TimeBoundaryQueryRunnerFactory
implements QueryRunnerFactory<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> {
    private static final TimeBoundaryQueryQueryToolChest toolChest = new TimeBoundaryQueryQueryToolChest();
    private final QueryWatcher queryWatcher;

    @Inject
    public TimeBoundaryQueryRunnerFactory(QueryWatcher queryWatcher) {
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> createRunner(Segment segment) {
        return new TimeBoundaryQueryRunner(segment);
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<TimeBoundaryResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TimeBoundaryResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> getToolchest() {
        return toolChest;
    }

    private static class TimeBoundaryQueryRunner
    implements QueryRunner<Result<TimeBoundaryResultValue>> {
        private final StorageAdapter adapter;
        private final Function<Cursor, Result<DateTime>> skipToFirstMatching;

        public TimeBoundaryQueryRunner(Segment segment) {
            this.adapter = segment.asStorageAdapter();
            this.skipToFirstMatching = new Function<Cursor, Result<DateTime>>(){

                @Override
                public Result<DateTime> apply(Cursor cursor) {
                    if (cursor.isDone()) {
                        return null;
                    }
                    LongColumnSelector timestampColumnSelector = cursor.makeLongColumnSelector("__time");
                    DateTime timestamp = new DateTime(timestampColumnSelector.get());
                    return new Result<DateTime>(TimeBoundaryQueryRunner.this.adapter.getInterval().getStart(), timestamp);
                }
            };
        }

        private DateTime getTimeBoundary(StorageAdapter adapter, TimeBoundaryQuery legacyQuery, boolean descending) {
            Sequence resultSequence = QueryRunnerHelper.makeCursorBasedQuery(adapter, legacyQuery.getQuerySegmentSpec().getIntervals(), Filters.toFilter(legacyQuery.getDimensionsFilter()), descending, new AllGranularity(), this.skipToFirstMatching);
            ArrayList resultList = Sequences.toList(Sequences.limit(resultSequence, 1), Lists.newArrayList());
            if (resultList.size() > 0) {
                return (DateTime)((Result)resultList.get(0)).getValue();
            }
            return null;
        }

        @Override
        public Sequence<Result<TimeBoundaryResultValue>> run(Query<Result<TimeBoundaryResultValue>> input, Map<String, Object> responseContext) {
            if (!(input instanceof TimeBoundaryQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", input.getClass(), TimeBoundaryQuery.class);
            }
            final TimeBoundaryQuery legacyQuery = (TimeBoundaryQuery)input;
            return new BaseSequence<Result<TimeBoundaryResultValue>, Iterator<Result<TimeBoundaryResultValue>>>(new BaseSequence.IteratorMaker<Result<TimeBoundaryResultValue>, Iterator<Result<TimeBoundaryResultValue>>>(){

                @Override
                public Iterator<Result<TimeBoundaryResultValue>> make() {
                    DateTime maxTime;
                    DateTime minTime;
                    if (TimeBoundaryQueryRunner.this.adapter == null) {
                        throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
                    }
                    if (legacyQuery.getDimensionsFilter() != null) {
                        minTime = TimeBoundaryQueryRunner.this.getTimeBoundary(TimeBoundaryQueryRunner.this.adapter, legacyQuery, false);
                        maxTime = minTime == null ? null : TimeBoundaryQueryRunner.this.getTimeBoundary(TimeBoundaryQueryRunner.this.adapter, legacyQuery, true);
                    } else {
                        minTime = legacyQuery.getBound().equalsIgnoreCase("maxTime") ? null : TimeBoundaryQueryRunner.this.adapter.getMinTime();
                        maxTime = legacyQuery.getBound().equalsIgnoreCase("minTime") ? null : TimeBoundaryQueryRunner.this.adapter.getMaxTime();
                    }
                    return legacyQuery.buildResult(TimeBoundaryQueryRunner.this.adapter.getInterval().getStart(), minTime, maxTime).iterator();
                }

                @Override
                public void cleanup(Iterator<Result<TimeBoundaryResultValue>> toClean) {
                }
            });
        }
    }
}

